# Average Blood Pressure Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Average Blood Pressure Example**

## Example Observation: Average Blood Pressure Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Average Blood Pressure Profileversion: null8.0.1)](StructureDefinition-us-core-average-blood-pressure.md)

**status**: Final

**category**: Vital Signs

**code**: Avg Blood pressure systolic and diastolic

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03 01:06:52+0000 --> 2023-08-06 13:07:01+0000

**performer**: [Amy Shaw](Patient-example.md)

**note**: 

> 

Average blood pressure is calculated from 12 measurements taken by the patient over 3 days.


> **component****code**:Average systolic blood pressure**value**: 109 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Average diastolic blood pressure**value**: 72 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Number of measurements**value**: 3 #



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "average-blood-pressure",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-average-blood-pressure|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "96607-7",
        "display" : "Blood pressure panel mean systolic and mean diastolic"
      }
    ],
    "text" : "Avg Blood pressure systolic and diastolic"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectivePeriod" : {
    "start" : "2023-08-03T01:06:52.480Z",
    "end" : "2023-08-06T13:07:01.166Z"
  },
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "note" : [
    {
      "text" : "Average blood pressure is calculated from 12 measurements taken by the patient over 3 days."
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "96608-5",
            "display" : "Systolic blood pressure mean"
          }
        ],
        "text" : "Average systolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 109,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "96609-3",
            "display" : "Diastolic blood pressure mean"
          }
        ],
        "text" : "Average diastolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 72,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "246432004",
            "display" : "Number of occurrences (qualifier value)"
          }
        ],
        "text" : "Number of measurements"
      },
      "valueQuantity" : {
        "value" : 3,
        "unit" : "#"
      }
    }
  ]
}

```
