# At Home In Vitro Test Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **At Home In Vitro Test Example**

## Example Observation: At Home In Vitro Test Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2021-01-28 16:06:21-0500

Profile: [US Core Laboratory Result Observation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-lab.md)

**status**: Final

**category**: Laboratory

**code**: Rapid Covid Antigen Test

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**effective**: 2021-01-28 16:06:21-0500

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: Detected

**device**: Acme COVID-19 Home Test_Acme Limited



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "at-home-in-vitro-test",
  "meta" : {
    "lastUpdated" : "2021-01-28T16:06:21-05:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "95209-3",
        "display" : "SARS-CoV+SARS-CoV-2 (COVID-19) Ag [Presence] in Respiratory system specimen by Rapid immunoassay"
      }
    ],
    "text" : "Rapid Covid Antigen Test"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "effectiveDateTime" : "2021-01-28T16:06:21-05:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "260373001",
        "display" : "Detected"
      }
    ]
  },
  "device" : {
    "display" : "Acme COVID-19 Home Test_Acme Limited"
  }
}

```
