# Alcoholic Drinks Per Day Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alcoholic Drinks Per Day Example**

## Example Observation: Alcoholic Drinks Per Day Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Social History

**code**: Alcoholic drinks per day

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03

**performer**: [Amy Shaw](Patient-example.md)

**value**: 0 # per day



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "alcoholic-drinks-per-day",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "74013-4",
        "display" : "Alcoholic drinks per day"
      }
    ],
    "text" : "Alcoholic drinks per day"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-03",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueQuantity" : {
    "value" : 0,
    "unit" : "# per day"
  }
}

```
