# Alcohol Use Status Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alcohol Use Status Example**

## Example Observation: Alcohol Use Status Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Social History

**code**: Alcohol use status

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03

**performer**: [Amy Shaw](Patient-example.md)

**value**: other choices - non-drinker, former drinker, current drinker



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "alcohol-use-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11331-6",
        "display" : "History of Alcohol use"
      }
    ],
    "text" : "Alcohol use status"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-03",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "228276006",
        "display" : "Occasional drinker"
      }
    ],
    "text" : "other choices - non-drinker, former drinker, current drinker"
  }
}

```
