# Prapare Panel Example 93041-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prapare Panel Example 93041-2**

## Example Observation: Prapare Panel Example 93041-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Money and resources

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-28 18:30:40-0700

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**hasMember**: 

* [Observation Highest level of educ](Observation-PRAPARE-item-example-82589-3.md)
* [Observation Employment status current](Observation-PRAPARE-item-example-67875-5.md)
* [Observation Primary insurance](Observation-PRAPARE-item-example-76437-3.md)
* [Observation What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]](Observation-PRAPARE-item-example-63586-2.md)
* [Observation Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md)
* [Observation Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md)
* [Observation Has lack of transportation kept you from medical appointments, meetings, work, or from getting things needed for daily living](Observation-PRAPARE-item-example-93030-5.md)

**derivedFrom**: [Response to Questionnaire '->Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]' about '->Amy V. Shaw'](QuestionnaireResponse-prapare-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PRAPARE-panel-example-93041-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93041-2",
        "display" : "Money and resources [PRAPARE]"
      }
    ],
    "text" : "Money and resources"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-28T18:30:40-07:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/PRAPARE-item-example-82589-3"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-67875-5"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-76437-3"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-63586-2"
    },
    {
      "reference" : "Observation/PRAPARE-multiselect-item-example-93031-3-answer0"
    },
    {
      "reference" : "Observation/PRAPARE-multiselect-item-example-93031-3-answer1"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-93030-5"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/prapare-example"
    }
  ]
}

```
