# Prapare Panel Example 93040-4 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prapare Panel Example 93040-4**

## Example Observation: Prapare Panel Example 93040-4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Social and emotional health

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-28 18:30:40-0700

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**hasMember**: 

* [Observation How often do you see or talk to people that you care about and feel close to [PRAPARE]](Observation-PRAPARE-item-example-93029-7.md)
* [Observation Stress level](Observation-PRAPARE-item-example-93038-8.md)

**derivedFrom**: [Response to Questionnaire '->Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]' about '->Amy V. Shaw'](QuestionnaireResponse-prapare-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PRAPARE-panel-example-93040-4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93040-4",
        "display" : "Social and emotional health [PRAPARE]"
      }
    ],
    "text" : "Social and emotional health"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-28T18:30:40-07:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/PRAPARE-item-example-93029-7"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-93038-8"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/prapare-example"
    }
  ]
}

```
