# PHQ9 Panel Example 44249-1 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PHQ9 Panel Example 44249-1**

## Example Observation: PHQ9 Panel Example 44249-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey, Disability Status

**code**: PHQ-9 quick depression assessment panel [Reported.PHQ]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-11-29 20:50:32+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**hasMember**: 

* [Observation Little interest or pleasure in doing things in last 2 weeks](Observation-PHQ9-item-example-44250-9.md)
* [Observation Feeling down, depressed, or hopeless in last 2 weeks](Observation-PHQ9-item-example-44255-8.md)
* [Observation Trouble falling or staying asleep, or sleeping too much in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44259-0.md)
* [Observation Feeling tired or having little energy in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44254-1.md)
* [Observation Poor appetite or overeating in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44251-7.md)
* [Observation Feeling bad about yourself - or that you are a failure or have let yourself or your family down in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44258-2.md)
* [Observation Trouble concentrating on things, such as reading the newspaper or watching television in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44252-5.md)
* [Observation Moving or speaking so slowly that other people could have noticed. Or the opposite - being so fidgety or restless that you have been moving around a lot more than usual in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44253-3.md)
* [Observation Thoughts that you would be better off dead, or of hurting yourself in some way in last 2 weeks [Reported.PHQ]](Observation-PHQ9-item-example-44260-8.md)
* [Observation Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]](Observation-PHQ9-item-example-44261-6.md)
* [Observation How difficult have these made it for you to do your work, take care of things at home, or get along with other people [Reported.PHQ]](Observation-PHQ9-item-example-69722-7.md)

**derivedFrom**: [Response to Questionnaire '->PHQ-9 Example' about '->Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))'](QuestionnaireResponse-phq-9-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PHQ9-panel-example-44249-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "disability-status",
          "display" : "Disability Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "44249-1",
        "display" : "PHQ-9 quick depression assessment panel [Reported.PHQ]"
      }
    ],
    "text" : "PHQ-9 quick depression assessment panel [Reported.PHQ]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-11-29T20:50:32.718000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/PHQ9-item-example-44250-9"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44255-8"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44259-0"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44254-1"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44251-7"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44258-2"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44252-5"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44253-3"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44260-8"
    },
    {
      "reference" : "Observation/PHQ9-item-example-44261-6"
    },
    {
      "reference" : "Observation/PHQ9-item-example-69722-7"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/phq-9-example"
    }
  ]
}

```
