# HVS Item Example 88123-5 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HVS Item Example 88123-5**

## Example Observation: HVS Item Example 88123-5

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Within the past 12 months the food we bought just didn't last and we didn't have money to get more

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2020-09-10 21:56:54+0000

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: Often true

**derivedFrom**: [Response to Questionnaire '->Hunger Vital Sign Example' about '->Amy V. Shaw'](QuestionnaireResponse-hunger-vital-sign-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "HVS-item-example-88123-5",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "88123-5",
        "display" : "Within the past 12 months the food we bought just didn't last and we didn't have money to get more"
      }
    ],
    "text" : "Within the past 12 months the food we bought just didn't last and we didn't have money to get more"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2020-09-10T21:56:54.671000+00:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/itemWeight",
            "valueDecimal" : 1
          }
        ],
        "system" : "http://loinc.org",
        "code" : "LA28397-0",
        "display" : "Often true"
      }
    ],
    "text" : "Often true"
  },
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/hunger-vital-sign-example"
    }
  ]
}

```
