# Evs Item Example 89555-7 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Evs Item Example 89555-7**

## Example Observation: Evs Item Example 89555-7

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: How many days per week did you engage in moderate to strenuous physical activity in the last 30 days

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-04 03:52:52+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: 3

**derivedFrom**: [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "EVS-item-example-89555-7",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "89555-7",
        "display" : "How many days per week did you engage in moderate to strenuous physical activity in the last 30 days"
      }
    ],
    "text" : "How many days per week did you engage in moderate to strenuous physical activity in the last 30 days"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-04T03:52:52.685000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueString" : "3",
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/exercise-vital-sign",
      "display" : "Exercise Vital Sign QuestionnaireResponse Example"
    }
  ]
}

```
