# Evs Item Example 68516-4 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Evs Item Example 68516-4**

## Example Observation: Evs Item Example 68516-4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-04 03:52:52+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: 60

**derivedFrom**: [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "EVS-item-example-68516-4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "68516-4",
        "display" : "On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise"
      }
    ],
    "text" : "On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-04T03:52:52.685000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueString" : "60",
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/exercise-vital-sign",
      "display" : "Exercise Vital Sign QuestionnaireResponse Example"
    }
  ]
}

```
