# Audit-C Panel Example 72109-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Audit-C Panel Example 72109-2**

## Example Observation: Audit-C Panel Example 72109-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-14 20:40:49+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**hasMember**: 

* [Observation How many times in the past year have you have X or more drinks in a day](Observation-AUDIT-C-item-example-68517-2.md)
* [Observation How many standard drinks containing alcohol do you have on a typical day](Observation-AUDIT-C-item-example-68519-8.md)
* [Observation How often do you have 6 or more drinks on 1 occasion](Observation-AUDIT-C-item-example-68520-6.md)
* [Observation Total score [AUDIT-C]](Observation-AUDIT-C-item-example-75626-2.md)

**derivedFrom**: [Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "AUDIT-C-panel-example-72109-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72109-2",
        "display" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]"
      }
    ],
    "text" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-14T20:40:49.675000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/AUDIT-C-item-example-68517-2"
    },
    {
      "reference" : "Observation/AUDIT-C-item-example-68519-8"
    },
    {
      "reference" : "Observation/AUDIT-C-item-example-68520-6"
    },
    {
      "reference" : "Observation/AUDIT-C-item-example-75626-2"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/AUDIT-C",
      "display" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example"
    }
  ]
}

```
