# Audit-C Item Example 75626-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Audit-C Item Example 75626-2**

## Example Observation: Audit-C Item Example 75626-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Total score [AUDIT-C]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-14 20:40:49+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: 0 score(Details: UCUM code1 = '1')

**note**: 

> 

The Alcohol Use Disorders Identification Test C (AUDIT-C) is scored on a scale of 0-12 where the higher the score, the more likely the patient's drinking is hazardous. A score of 4 or more for men and 3 or more for women is considered positive for hazardous drinking or active alcohol use disorders. If the points are all from Question 1 alone where 2 and 3 are 0, it is likely the patient is drinking below recommended limits. The care provider may review the patients alcohol intake over that past few months to confirm accuracy. [PMID: 12695273]


**derivedFrom**: [Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "AUDIT-C-item-example-75626-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "75626-2",
        "display" : "Total score [AUDIT-C]"
      }
    ],
    "text" : "Total score [AUDIT-C]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-14T20:40:49.675000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueQuantity" : {
    "value" : 0,
    "unit" : "score",
    "system" : "http://unitsofmeasure.org",
    "code" : "1"
  },
  "note" : [
    {
      "text" : "The Alcohol Use Disorders Identification Test C (AUDIT-C) is scored on a scale of 0-12 where the higher the score, the more likely the patient's drinking is hazardous. A score of 4 or more for men and 3 or more for women is considered positive for hazardous drinking or active alcohol use disorders. If the points are all from Question 1 alone where 2 and 3 are 0, it is likely the patient is drinking below recommended limits. The care provider may review the patients alcohol intake over that past few months to confirm accuracy. [PMID: 12695273]"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/AUDIT-C",
      "display" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example"
    }
  ]
}

```
