# MedicationRequest Self Tylenol Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Self Tylenol Example**

## Example MedicationRequest: MedicationRequest Self Tylenol Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core MedicationRequest Profileversion: null8.0.1)](StructureDefinition-us-core-medicationrequest.md)

> **US Core Medication Adherence Extension**
* medicationAdherence: Drugs - partial non-compliance (finding)
* dateAsserted: 2023-08-11 08:15:49+0000
* informationSource: Spouse

**identifier**: `http://acme.org/prescriptions`/12345689 (use: official, )

**status**: Active

**intent**: Plan

**reported**: true

**medication**: Tylenol PM Pill

**subject**: [Amy V. Shaw](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**authoredOn**: 2019-06-24

**requester**: [**self-prescribed**](Patient-example.md)

**reasonCode**: Headache

### DosageInstructions

| | |
| :--- | :--- |
| - | **Text** |
| * | Takes 1-2 tablets once daily at bedtime as needed for restless legs |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "self-tylenol",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|8.0.1"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "medicationAdherence",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "275928001",
                "display" : "Drugs - partial non-compliance (finding)"
              }
            ]
          }
        },
        {
          "url" : "dateAsserted",
          "valueDateTime" : "2023-08-11T08:15:49.449Z"
        },
        {
          "url" : "informationSource",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "SPS",
                "display" : "Spouse"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "http://acme.org/prescriptions",
      "value" : "12345689"
    }
  ],
  "status" : "active",
  "intent" : "plan",
  "reportedBoolean" : true,
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "1187314",
        "display" : "Tylenol PM Pill"
      }
    ],
    "text" : "Tylenol PM Pill"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "authoredOn" : "2019-06-24",
  "requester" : {
    "reference" : "Patient/example",
    "display" : "**self-prescribed**"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "25064002",
          "display" : "Headache (finding)"
        }
      ],
      "text" : "Headache"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "Takes 1-2 tablets once daily at bedtime as needed for restless legs"
    }
  ]
}

```
