# MedicationRequest Referenced Oral Axid Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Referenced Oral Axid Example**

## Example MedicationRequest: MedicationRequest Referenced Oral Axid Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core MedicationRequest Profileversion: null8.0.1)](StructureDefinition-us-core-medicationrequest.md)

**status**: Active

**intent**: Order

**medication**: [Nizatidine 15 MG/ML Oral Solution [Axid]](Medication-uscore-med2.md)

**subject**: [Amy Shaw](Patient-example.md)

**authoredOn**: 2008-04-05

**requester**: [Ronald Bone, MD](Practitioner-practitioner-1.md)

**reasonReference**: [Active Duodenal Ulcer](Condition-condition-duodenal-ulcer.md)

> **dosageInstruction****text**: 10 mL bid**timing**: 2 per 1 day**route**:Oral route

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 10 ml(Details: UCUM codemL = 'mL') |


> **dispenseRequest****numberOfRepeatsAllowed**: 1**quantity**: 480 mL(Details: UCUM codemL = 'mL')

### ExpectedSupplyDurations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Value** | **Unit** | **System** | **Code** |
| * | 30 | days | [http://unitsofmeasure.org](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html) | d |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "medicationrequest-referenced-oral-axid",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "Medication/uscore-med2",
    "display" : "Nizatidine 15 MG/ML Oral Solution [Axid]"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "authoredOn" : "2008-04-05",
  "requester" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Ronald Bone, MD"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/condition-duodenal-ulcer",
      "display" : "Active Duodenal Ulcer"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "10 mL bid",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2008-04-05"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/731000124108",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 10,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "mL"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 480,
      "unit" : "mL",
      "system" : "http://unitsofmeasure.org",
      "code" : "mL"
    },
    "expectedSupplyDuration" : {
      "value" : 30,
      "unit" : "days",
      "system" : "http://unitsofmeasure.org",
      "code" : "d"
    }
  }
}

```
