# MedicationRequest Coded Oral Axid Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Coded Oral Axid Example**

## Example MedicationRequest: MedicationRequest Coded Oral Axid Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core MedicationRequest Profileversion: null8.0.1)](StructureDefinition-us-core-medicationrequest.md)

> **US Core Medication Adherence Extension**
* medicationAdherence: Drugs - partial non-compliance (finding)
* dateAsserted: 2023-08-11 08:15:49+0000
* informationSource: Patient (person)
* informationSource: Pharmacy

**status**: Active

**intent**: Order

**medication**: Nizatidine 15 MG/ML Oral Solution

**subject**: [Amy Shaw](Patient-example.md)

**authoredOn**: 2008-04-05

**requester**: [Ronald Bone, MD](Practitioner-practitioner-1.md)

**reasonCode**: Active Duodenal Ulcer

> **dosageInstruction****text**: 10 mL bid**timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 10 ml(Details: UCUM codemL = 'mL') |


> **dispenseRequest****numberOfRepeatsAllowed**: 1**quantity**: 480 mL(Details: UCUM codemL = 'mL')

### ExpectedSupplyDurations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Value** | **Unit** | **System** | **Code** |
| * | 30 | days | [http://unitsofmeasure.org](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html) | d |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "medicationrequest-coded-oral-axid",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|8.0.1"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "medicationAdherence",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "275928001",
                "display" : "Drugs - partial non-compliance (finding)"
              }
            ]
          }
        },
        {
          "url" : "dateAsserted",
          "valueDateTime" : "2023-08-11T08:15:49.449Z"
        },
        {
          "url" : "informationSource",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "116154003",
                "display" : "Patient (person)"
              }
            ]
          }
        },
        {
          "url" : "informationSource",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html",
                "code" : "1179-1",
                "display" : "Pharmacy"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "476872",
        "display" : "Nizatidine 15 MG/ML Oral Solution"
      }
    ],
    "text" : "Nizatidine 15 MG/ML Oral Solution"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "authoredOn" : "2008-04-05",
  "requester" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Ronald Bone, MD"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "51868009",
          "display" : "Ulcer of duodenum (disorder)"
        }
      ],
      "text" : "Active Duodenal Ulcer"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "10 mL bid",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2008-04-05"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 10,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "mL"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 480,
      "unit" : "mL",
      "system" : "http://unitsofmeasure.org",
      "code" : "mL"
    },
    "expectedSupplyDuration" : {
      "value" : 30,
      "unit" : "days",
      "system" : "http://unitsofmeasure.org",
      "code" : "d"
    }
  }
}

```
