# HL7East Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7East Example**

## Example Location: HL7East Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Location Profileversion: null8.0.1)](StructureDefinition-us-core-location.md)

**identifier**: `http://www.acme.org/location`/29

**status**: Active

**name**: Health Level Seven International - Amherst

**description**: HL7 Headquarters - East

**type**: Administrative Office

**telecom**: ph: (+1) 734-677-7777

**address**: 3300 WASHTENAW AVE STE 227 AMHERST MA 01002 USA 

### Positions

| | | |
| :--- | :--- | :--- |
| - | **Longitude** | **Latitude** |
| * | -72.519854 | 42.373222 |

**managingOrganization**: Health Level Seven International



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "hl7east",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/location",
      "value" : "29"
    }
  ],
  "status" : "active",
  "name" : "Health Level Seven International - Amherst",
  "description" : "HL7 Headquarters - East",
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html",
          "code" : "1184-1",
          "display" : "Administrative Areas"
        }
      ],
      "text" : "Administrative Office"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 734-677-7777"
    }
  ],
  "address" : {
    "line" : ["3300 WASHTENAW AVE STE 227"],
    "city" : "AMHERST",
    "state" : "MA",
    "postalCode" : "01002",
    "country" : "USA"
  },
  "position" : {
    "longitude" : -72.519854,
    "latitude" : 42.373222
  },
  "managingOrganization" : {
    "display" : "Health Level Seven International"
  }
}

```
