# US Core Version 8.0.1 Model Definition - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Version 8.0.1 Model Definition**

## Library: US Core Version 8.0.1 Model Definition 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/Library/uscore-8.0.1-model-definition | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:USCoreVersion801ModelDefinition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.28.6 | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | |

 
Model definition for US Core Version 8.0.1 Model 

* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Id:**
  * ?: uscore-8.0.1-model-definition
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Version:**
  * ?: 8.0.1
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Url:**
  * ?: [US Core Version 8.0.1 Model Definition](Library-uscore-8.0.1-model-definition.md)
* * **Content:**application/xml: ````Encoded data (316408 characters)````: ****
  * ?: urn:oid:2.16.840.1.113883.4.642.40.2.28.6
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Date:**
  * ?: 2025-11-11
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Publisher:**
  * ?: HL7 International / Cross-Group Projects
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Description:**
  * ?: Model definition for US Core Version 8.0.1 Model
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Jurisdiction:**
  * ?: US
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Topic:**
  * ?: 
* * **Content:**application/xml: ````Encoded data (316408 characters)````: **Copyright:**
  * ?: Used by permission of HL7 International, all rights reserved Creative Commons License



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-8.0.1-model-definition",
  "url" : "http://hl7.org/fhir/Library/uscore-8.0.1-model-definition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.28.6"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreVersion801ModelDefinition",
  "title" : "US Core Version 8.0.1 Model Definition",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "model-definition"
      }
    ]
  },
  "date" : "2025-11-11",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Model definition for US Core Version 8.0.1 Model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "lastReviewDate" : "2025-11-11",
  "topic" : [
    {
      "text" : "US Core Version 8.0.1"
    }
  ],
  "content" : [
    {
      "contentType" : "application/xml",
      "data" : "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"
    }
  ]
}

```
