# US Core Version 5.0.1 Model Definition - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Version 5.0.1 Model Definition**

## Library: US Core Version 5.0.1 Model Definition 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/Library/uscore-5.0.1-model-definition | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:USCoreVersion501ModelDefinition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.28.3 | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | |

 
Model definition for US Core Version 5.0.1 Model 

* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Id:**
  * ?: uscore-5.0.1-model-definition
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Version:**
  * ?: 8.0.1
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Url:**
  * ?: [US Core Version 5.0.1 Model Definition](Library-uscore-5.0.1-model-definition.md)
* * **Content:**application/xml: ````Encoded data (292248 characters)````: ****
  * ?: urn:oid:2.16.840.1.113883.4.642.40.2.28.3
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Date:**
  * ?: 2025-05-07
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Publisher:**
  * ?: HL7 International / Cross-Group Projects
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Description:**
  * ?: Model definition for US Core Version 5.0.1 Model
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Jurisdiction:**
  * ?: US
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Topic:**
  * ?: 
* * **Content:**application/xml: ````Encoded data (292248 characters)````: **Copyright:**
  * ?: Used by permission of HL7 International, all rights reserved Creative Commons License



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-5.0.1-model-definition",
  "url" : "http://hl7.org/fhir/Library/uscore-5.0.1-model-definition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.28.3"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreVersion501ModelDefinition",
  "title" : "US Core Version 5.0.1 Model Definition",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "model-definition"
      }
    ]
  },
  "date" : "2025-05-07",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Model definition for US Core Version 5.0.1 Model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "lastReviewDate" : "2025-05-07",
  "topic" : [
    {
      "text" : "US Core Version 5.0.1"
    }
  ],
  "content" : [
    {
      "contentType" : "application/xml",
      "data" : "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"
    }
  ]
}

```
