# US Core Version 4.0.0 Model Definition - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Version 4.0.0 Model Definition**

## Library: US Core Version 4.0.0 Model Definition 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/Library/uscore-4.0.0-model-definition | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:USCoreVersion400ModelDefinition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.28.2 | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | |

 
Model definition for US Core Version 4.0.0 Model 

* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Id:**
  * ?: uscore-4.0.0-model-definition
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Version:**
  * ?: 8.0.1
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Url:**
  * ?: [US Core Version 4.0.0 Model Definition](Library-uscore-4.0.0-model-definition.md)
* * **Content:**application/xml: ````Encoded data (252356 characters)````: ****
  * ?: urn:oid:2.16.840.1.113883.4.642.40.2.28.2
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Date:**
  * ?: 2025-05-07
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Publisher:**
  * ?: HL7 International / Cross-Group Projects
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Description:**
  * ?: Model definition for US Core Version 4.0.0 Model
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Jurisdiction:**
  * ?: US
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Topic:**
  * ?: 
* * **Content:**application/xml: ````Encoded data (252356 characters)````: **Copyright:**
  * ?: Used by permission of HL7 International, all rights reserved Creative Commons License



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-4.0.0-model-definition",
  "url" : "http://hl7.org/fhir/Library/uscore-4.0.0-model-definition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.28.2"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreVersion400ModelDefinition",
  "title" : "US Core Version 4.0.0 Model Definition",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "model-definition"
      }
    ]
  },
  "date" : "2025-05-07",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Model definition for US Core Version 4.0.0 Model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "lastReviewDate" : "2025-05-07",
  "topic" : [
    {
      "text" : "US Core Version 4.0.0"
    }
  ],
  "content" : [
    {
      "contentType" : "application/xml",
      "data" : "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"
    }
  ]
}

```
