# Encounter Delivery Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Delivery Example**

## Example Encounter: Encounter Delivery Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2024-01-28 16:06:21-0800

Profile: [US Core Encounter Profileversion: null8.0.1)](StructureDefinition-us-core-encounter.md)

**status**: Finished

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**type**: Normal delivery procedure (procedure)

**subject**: [Amy V. Shaw](Patient-example.md)

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Holy Family Hospital](Location-hospital.md) |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "delivery",
  "meta" : {
    "lastUpdated" : "2024-01-28T16:06:21-08:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|8.0.1"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "177184002",
          "display" : "Normal delivery procedure (procedure)"
        }
      ],
      "text" : "Normal delivery procedure (procedure)"
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/hospital",
        "display" : "Holy Family Hospital"
      }
    }
  ]
}

```
