# Encounter 1036 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter 1036 Example**

## Example Encounter: Encounter 1036 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2024-01-28 16:06:21-0800

Profile: [US Core Encounter Profileversion: null8.0.1)](StructureDefinition-us-core-encounter.md)

**status**: In Progress

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**type**: Unknown (qualifier value)

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

### Hospitalizations

| | |
| :--- | :--- |
| - | **DischargeDisposition** |
| * | Discharged to Home |

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Holy Family Hospital](Location-hospital.md) |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "1036",
  "meta" : {
    "lastUpdated" : "2024-01-28T16:06:21-08:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|8.0.1"
    ]
  },
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "261665006",
          "display" : "Unknown (qualifier value)"
        }
      ],
      "text" : "Unknown (qualifier value)"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "hospitalization" : {
    "dischargeDisposition" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/nubc-UB92",
          "code" : "01",
          "display" : "Discharged to Home"
        }
      ]
    }
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/hospital",
        "display" : "Holy Family Hospital"
      }
    }
  ]
}

```
