# Episode Summary Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Episode Summary Example**

## Example DocumentReference: Episode Summary Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core DocumentReference Profileversion: null8.0.1)](StructureDefinition-us-core-documentreference.md)

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/5.5.0/NamingSystem-uri.html)/urn:oid:2.16.840.1.113883.19.5.99999.1

**status**: Current

**type**: CCD Document

**category**: Clinical Note

**subject**: [Amy Shaw](Patient-example.md)

**date**: 2016-03-09 15:29:46+0000

**author**: [Ronald Bone, MD](Practitioner-practitioner-1.md)

**description**: Pulmonology clinic acute visit

> **content**

### Attachments

| | | | |
| :--- | :--- | :--- | :--- |
| - | **ContentType** | **Url** | **Title** |
| * | text/plain | [http://example.org/fhir/Binary/1-note](http://example.org/fhir/Binary/1-note) | URI where the data can be found: http://example.org/fhir/Binary/1-note |

**format**:[IHE Format Code set for use with Document Sharing: urn:hl7-org:sdwg:ccda-structuredBody:2.1](http://tx.fhir.org/r4/ValueSet/formatcode#formatcode-urn.58hl7-org.58sdwg.58ccda-structuredBody.582.461)(For documents following C-CDA 2.1 constraints using a structured body.)

### Contexts

| | |
| :--- | :--- |
| - | **Period** |
| * | 2004-12-23 08:00:00+1100 --> 2004-12-23 08:01:00+1100 |



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "episode-summary",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
    }
  ],
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "34133-9",
        "display" : "Summary of episode note"
      }
    ],
    "text" : "CCD Document"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }
      ],
      "text" : "Clinical Note"
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "date" : "2016-03-09T15:29:46Z",
  "author" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Ronald Bone, MD"
    }
  ],
  "description" : "Pulmonology clinic acute visit",
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/plain",
        "url" : "http://example.org/fhir/Binary/1-note",
        "title" : "URI where the data can be found: http://example.org/fhir/Binary/1-note"
      },
      "format" : {
        "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
        "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1",
        "display" : "For documents following C-CDA 2.1 constraints using a structured body."
      }
    }
  ],
  "context" : {
    "period" : {
      "start" : "2004-12-23T08:00:00+11:00",
      "end" : "2004-12-23T08:01:00+11:00"
    }
  }
}

```
