# Discharge Summary Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Discharge Summary Example**

## Example DocumentReference: Discharge Summary Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "discharge-summary",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|8.0.1"
    ]
  },
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18842-5",
        "display" : "Discharge Summary"
      }
    ],
    "text" : "Discharge Summary"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }
      ],
      "text" : "Clinical No"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/plain",
        "data" : "Tm8gYWN0aXZpdHkgcmVzdHJpY3Rpb24sIHJlZ3VsYXIgZGlldCwgZm9sbG93IHVwIGluIHR3byB0byB0aHJlZSB3ZWVrcyB3aXRoIHByaW1hcnkgY2FyZSBwcm92aWRlci4="
      }
    }
  ],
  "context" : {
    "encounter" : [
      {
        "reference" : "Encounter/example-1"
      }
    ]
  }
}

```
