# DocumentReference DNR - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DocumentReference DNR**

## Example DocumentReference: DocumentReference DNR

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core ADI DocumentReference Profileversion: null8.0.1)](StructureDefinition-us-core-adi-documentreference.md)

**US Core Authentication Time Extension**: 2024-10-08 19:48:54-0700

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/5.5.0/NamingSystem-uri.html)/urn:oid:2.16.840.1.113883.19.5.99999.1

**status**: Current

**type**: Do Not Resuscitate

**category**: Advance Directives

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**date**: 2024-10-08 19:48:54-0700

**author**: [Example](Patient-example.md)

**authenticator**: [Practitioner-1](Practitioner-practitioner-1.md)

> **content**

### Attachments

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Data** | **Title** | **Creation** |
| * | application/pdf | (base64 data - 60,756 base64 chars) | ADI-DNR | 2024-10-04 |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "adi-dnr",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-adi-documentreference|8.0.1"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-authentication-time",
      "valueDateTime" : "2024-10-08T19:48:54.316108-07:00"
    }
  ],
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
    }
  ],
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84095-9",
        "display" : "Do not resuscitate"
      }
    ],
    "text" : "Do Not Resuscitate"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "42348-3",
          "display" : "Advance healthcare directives"
        }
      ],
      "text" : "Advance Directives"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "date" : "2024-10-08T19:48:54.316108-07:00",
  "author" : [
    {
      "reference" : "Patient/example",
      "display" : "Example"
    }
  ],
  "authenticator" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Practitioner-1"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "application/pdf",
        "data" : "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",
        "title" : "ADI-DNR",
        "creation" : "2024-10-04"
      }
    }
  ]
}

```
