# Basic Metabolic Panel Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Metabolic Panel Example**

## Example DiagnosticReport: Basic Metabolic Panel Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-06 15:29:58+0000

Profile: [US Core DiagnosticReport Profile for Laboratory Results Reportingversion: null8.0.1)](StructureDefinition-us-core-diagnosticreport-lab.md)

## Basic Metabolic Panel (BMP) (Laboratory ) 

| | |
| :--- | :--- |
| Subject | Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, )) |
| When For | 2005-07-04 |
| Reported | 2005-07-06 11:45:33+0000 |
| Performer | [Acme Laboratory, Inc](Organization-acme-lab.md) |

**Report Details**

* **Code**: [Sodium, Blood](Observation-serum-sodium.md)
  * **Value**: 137 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Reference Range**: Normal Range: 135 mmol/L(Details: UCUM codemmol/L = 'mmol/L')- 145 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05
* **Code**: [Potassium, Blood](Observation-serum-potassium.md)
  * **Value**: 5.4 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Reference Range**: Normal Range: 3.5 mmol/L(Details: UCUM codemmol/L = 'mmol/L')- 5.5 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05
* **Code**: [Creatinine, Blood](Observation-serum-creatinine.md)
  * **Value**: 1 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Reference Range**: Normal Range: 0.2 mg/dL(Details: UCUM codemg/dL = 'mg/dL')- 0.6 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Flags**: Final,High
  * **When For**: 2005-07-05
* **Code**: [Carbon Dioxide (CO2), Blood](Observation-serum-co2.md)
  * **Value**: 24 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Reference Range**: Normal Range: 22 mmol/L(Details: UCUM codemmol/L = 'mmol/L')- 29 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05
* **Code**: [Chloride, Blood](Observation-serum-chloride.md)
  * **Value**: 105 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Reference Range**: Normal Range: 95 mmol/L(Details: UCUM codemmol/L = 'mmol/L')- 105 mmol/L(Details: UCUM codemmol/L = 'mmol/L')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05
* **Code**: [Calcium, Blood](Observation-serum-calcium.md)
  * **Value**: 7.7 mg/dL
  * **Reference Range**: Normal Range: 8.5 mg/dL(Details: UCUM codemg/dL = 'mg/dL')- 10.5 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Flags**: Final,Low
  * **When For**: 2005-07-05
* **Code**: [Urea Nitrogen (BUN), Blood](Observation-serum-bun.md)
  * **Value**: 10 mg/dL
  * **Reference Range**: Normal Range: 5 mg/dL(Details: UCUM codemg/dL = 'mg/dL')- 20 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05
* **Code**: [Glucose, Blood](Observation-serum-glucose.md)
  * **Value**: 76 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Reference Range**: Normal Range: 40 mg/dL(Details: UCUM codemg/dL = 'mg/dL')- 109 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Flags**: Final,Normal
  * **When For**: 2005-07-05



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "metabolic-panel",
  "meta" : {
    "lastUpdated" : "2005-07-06T15:29:58.597Z",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|8.0.1"
    ]
  },
  "basedOn" : [
    {
      "reference" : "ServiceRequest/bmp",
      "display" : "Basic Metabolic Panel (BMP) Order"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "LAB",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "24321-2",
        "display" : "Basic metabolic 2000 panel - Serum or Plasma"
      }
    ],
    "text" : "Basic Metabolic Panel (BMP)"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "effectiveDateTime" : "2005-07-04",
  "issued" : "2005-07-06T11:45:33Z",
  "performer" : [
    {
      "reference" : "Organization/acme-lab",
      "display" : "Acme Laboratory, Inc"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/serum-sodium",
      "display" : "SODIUM"
    },
    {
      "reference" : "Observation/serum-potassium",
      "display" : "Potassium"
    },
    {
      "reference" : "Observation/serum-creatinine",
      "display" : "CREATININE"
    },
    {
      "reference" : "Observation/serum-co2",
      "display" : "TOTAL CO2"
    },
    {
      "reference" : "Observation/serum-chloride",
      "display" : "CHLORIDE"
    },
    {
      "reference" : "Observation/serum-calcium",
      "display" : "CALCIUM"
    },
    {
      "reference" : "Observation/serum-bun",
      "display" : "BUN"
    },
    {
      "reference" : "Observation/serum-glucose",
      "display" : "GLUCOSE"
    }
  ]
}

```
