# CBC Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CBC Example**

## Example DiagnosticReport: CBC Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-06 15:29:58+0000

Profile: [US Core DiagnosticReport Profile for Laboratory Results Reportingversion: null8.0.1)](StructureDefinition-us-core-diagnosticreport-lab.md)

## CBC panel - Blood by Automated count (Laboratory ) 

| | |
| :--- | :--- |
| Subject | Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, )) |
| When For | 2005-07-05 |
| Reported | 2005-07-06 11:45:33+0000 |
| Performer | [Acme Laboratory, Inc](Organization-acme-lab.md) |

**Report Details**

* **Code**: [White blood cell (WBC) count, Blood](Observation-cbc-leukocytes.md)
  * **Value**: 10 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')
  * **Reference Range**: Normal Range: 4.5 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')- 11 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')
  * **Flags**: Final,Normal
* **Code**: [Red Blood Cell (RBC) Count, Blood](Observation-cbc-erythrocytes.md)
  * **Value**: 4.58 10*6/uL(Details: UCUM code10*6/uL = '10*6/uL')
  * **Reference Range**: Normal Range: 4.1 10*6/uL(Details: UCUM code10*6/uL = '10*6/uL')- 6.1 10*6/uL(Details: UCUM code10*6/uL = '10*6/uL')
  * **Flags**: Final,Normal
* **Code**: [Hemoglobin, Blood](Observation-cbc-hemoglobin.md)
  * **Value**: 17 g/dL(Details: UCUM codeg/dL = 'g/dL')
  * **Reference Range**: Normal Range: 16.5 g/dL(Details: UCUM codeg/dL = 'g/dL')- 21.5 g/dL(Details: UCUM codeg/dL = 'g/dL')
  * **Flags**: Final,Normal
* **Code**: [Hematocrit, Blood](Observation-cbc-hematocrit.md)
  * **Value**: 43 %(Details: UCUM code% = '%')
  * **Reference Range**: Normal Range: 46 %(Details: UCUM code% = '%')- 38 %(Details: UCUM code% = '%')
  * **Flags**: Final,Normal
* **Code**: [Mean Corpuscular Volume (MCV), Red blood cells](Observation-cbc-mcv.md)
  * **Value**: 85 fL(Details: UCUM codefL = 'fL')
  * **Reference Range**: Normal Range: 87.3 fL(Details: UCUM codefL = 'fL')- 82.4 fL(Details: UCUM codefL = 'fL')
  * **Flags**: Final,Normal
* **Code**: [Mean Corpuscular Hemoglobin (MCH), Red blood cells](Observation-cbc-mch.md)
  * **Value**: 30 pg(Details: UCUM codepg = 'pg')
  * **Reference Range**: Normal Range: 33.2 pg(Details: UCUM codepg = 'pg')- 27.5 pg(Details: UCUM codepg = 'pg')
  * **Flags**: Final,Normal
* **Code**: [MCHC](Observation-cbc-mchc.md)
  * **Value**: 34.7 g/dL(Details: UCUM codeg/dL = 'g/dL')
  * **Reference Range**: Normal Range: 30 g/dL(Details: UCUM codeg/dL = 'g/dL')- 34 g/dL(Details: UCUM codeg/dL = 'g/dL')
  * **Flags**: Final,High
* **Code**: [Platelet count, Blood](Observation-cbc-platelets.md)
  * **Value**: 200 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')
  * **Reference Range**: Normal Range: 150 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')- 450 10*3/uL(Details: UCUM code10*3/uL = '10*3/uL')
  * **Flags**: Final,Normal



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "cbc",
  "meta" : {
    "lastUpdated" : "2005-07-06T15:29:58.597Z",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "LAB",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "58410-2",
        "display" : "CBC panel - Blood by Automated count"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "effectiveDateTime" : "2005-07-05",
  "issued" : "2005-07-06T11:45:33Z",
  "performer" : [
    {
      "reference" : "Organization/acme-lab",
      "display" : "Acme Laboratory, Inc"
    }
  ],
  "resultsInterpreter" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/cbc-leukocytes",
      "display" : "LEUKOCYTES"
    },
    {
      "reference" : "Observation/cbc-erythrocytes",
      "display" : "ERYTHROCYTES"
    },
    {
      "reference" : "Observation/cbc-hemoglobin",
      "display" : "HEMOGLOBIN"
    },
    {
      "reference" : "Observation/cbc-hematocrit",
      "display" : "HEMATOCRIT"
    },
    {
      "reference" : "Observation/cbc-mcv",
      "display" : "MCV"
    },
    {
      "reference" : "Observation/cbc-mch",
      "display" : "MCH"
    },
    {
      "reference" : "Observation/cbc-mchc",
      "display" : "MCHC"
    },
    {
      "reference" : "Observation/cbc-platelets",
      "display" : "PLATELETS"
    }
  ]
}

```
