# Device Defib Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device Defib Example**

## Example Device: Device Defib Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Implantable Device Profileversion: null8.0.1)](StructureDefinition-us-core-implantable-device.md)

### UdiCarriers

| | | | |
| :--- | :--- | :--- | :--- |
| - | **DeviceIdentifier** | **CarrierHRF** | **EntryType** |
| * | 99863313444316 | (01)99863313444316(17)220101(10)M320(21)AC221 | RFID |

**status**: Active

**manufacturer**: ACME Biomedical

**expirationDate**: 2022-01-01

**lotNumber**: M320

**serialNumber**: AC221

### DeviceNames

| | | |
| :--- | :--- | :--- |
| - | **Name** | **Type** |
| * | ACME Defibrillator Analyzer, with Transcutaneous Pacemaker Input | UDI Label name |

**modelNumber**: 1.0

**type**: Implant

**patient**: [Amy Shaw](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "udi-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|8.0.1"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "99863313444316",
      "carrierHRF" : "(01)99863313444316(17)220101(10)M320(21)AC221",
      "entryType" : "rfid"
    }
  ],
  "status" : "active",
  "manufacturer" : "ACME Biomedical",
  "expirationDate" : "2022-01-01",
  "lotNumber" : "M320",
  "serialNumber" : "AC221",
  "deviceName" : [
    {
      "name" : "ACME Defibrillator Analyzer, with Transcutaneous Pacemaker Input",
      "type" : "udi-label-name"
    }
  ],
  "modelNumber" : "1.0",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "19257004",
        "display" : "Defibrillator, device"
      }
    ],
    "text" : "Implant"
  },
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  }
}

```
