# UDI 1 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **UDI 1 Example**

## Example Device: UDI 1 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Implantable Device Profileversion: null8.0.1)](StructureDefinition-us-core-implantable-device.md)

### UdiCarriers

| | | |
| :--- | :--- | :--- |
| - | **DeviceIdentifier** | **CarrierHRF** |
| * | 09504000059118 | (01)09504000059118(17)141120(10)7654321D(21)10987654d321 |

**status**: Active

**expirationDate**: 2014-11-20

**lotNumber**: 7654321D

**serialNumber**: 10987654d321

**type**: Coated femoral stem prosthesis, modular

**patient**: [Amy Shaw](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "udi-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|8.0.1"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "09504000059118",
      "carrierHRF" : "(01)09504000059118(17)141120(10)7654321D(21)10987654d321"
    }
  ],
  "status" : "active",
  "expirationDate" : "2014-11-20",
  "lotNumber" : "7654321D",
  "serialNumber" : "10987654d321",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "468063009",
        "display" : "Coated femoral stem prosthesis, modular"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  }
}

```
