# Health Concern Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Concern Example**

## Example Condition: Health Concern Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2007-12-14 07:15:07-0800

Profile: [US Core Condition Problems and Health Concerns Profileversion: null8.0.1)](StructureDefinition-us-core-condition-problems-health-concerns.md)

**Condition Asserted Date**: 2007-12-14

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Health Concern

**code**: Fear of becoming fat

**subject**: [Amy Shaw](Patient-example.md)

**onset**: 2007-12-14

**recordedDate**: 2007-12-14 07:15:07-0800

**recorder**: [Dr Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "health-concern-example",
  "meta" : {
    "lastUpdated" : "2007-12-14T07:15:07-08:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|8.0.1"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2007-12-14"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category",
          "code" : "health-concern",
          "display" : "Health Concern"
        }
      ],
      "text" : "Health Concern"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "247824007",
        "display" : "Fear of becoming fat"
      }
    ],
    "text" : "Fear of becoming fat"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "onsetDateTime" : "2007-12-14",
  "recordedDate" : "2007-12-14T07:15:07-08:00",
  "recorder" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  }
}

```
