# US Core Category - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Category**

## CodeSystem: US Core Category 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/CodeSystem/us-core-category | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.16.3 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
Category codes used across US Core Profiles and resource types. They are typically used when there is a need for categorization for searching and finding resources or workflow hints. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [USCoreScreeningAssessmentConditionCategory](ValueSet-us-core-screening-assessment-condition-category.md)
* [USCoreScreeningAssessmentObservationCategory](ValueSet-us-core-screening-assessment-observation-category.md)
* [USCoreScreeningAssessmentObservationMaximumCategory](ValueSet-us-core-screening-assessment-observation-maximum-category.md)
* [USCoreServiceRequestCategoryCodes](ValueSet-us-core-servicerequest-category.md)
* [USCoreSimpleObservationCategory](ValueSet-us-core-simple-observation-category.md)

**Changes since version 7.0.0:**

* The list of codes defined by the code system has changed



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "us-core-category",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.16.3"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreCategory",
  "title" : "US Core Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-04-20",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Category codes used across US Core Profiles and resource types. They are typically used when there is a need for categorization for searching and finding resources or workflow hints.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "sdoh",
      "display" : "SDOH",
      "definition" : "Social Determinants of Health category"
    },
    {
      "code" : "functional-status",
      "display" : "Functional Status",
      "definition" : "Functional Status category"
    },
    {
      "code" : "disability-status",
      "display" : "Disability Status",
      "definition" : "Disability Status category"
    },
    {
      "code" : "cognitive-status",
      "display" : "Cognitive Status",
      "definition" : "Cognitive Status category"
    },
    {
      "code" : "treatment-intervention-preference",
      "display" : "Treatment Intervention Preference",
      "definition" : "A personal preference for a type of medical intervention (treatment) request under certain conditions."
    },
    {
      "code" : "care-experience-preference",
      "display" : "Care Experience Preference",
      "definition" : "Personal thoughts about something a person feels is relevant to their care experience and may be pertinent when planning their care."
    },
    {
      "code" : "observation-adi-documentation",
      "display" : "Observation ADI Documentation",
      "definition" : "Statement of presence and properties of patient or provider authored documents that record a patient's goals, preferences and priorities should a patient be unable to communicate them to a provider."
    }
  ]
}

```
