# Missing Coded Data Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Missing Coded Data Example**

## Example CareTeam: Missing Coded Data Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core CareTeam Profileversion: null8.0.1)](StructureDefinition-us-core-careteam.md)

**status**: Active

**name**: US-Core example CareTeam

**subject**: [Amy V. Shaw](Patient-example.md)

> **participant****role**:unknown**member**:[Ronald Bone, MD](Practitioner-practitioner-1.md)

> **participant****role**:Primary care provider**member**:[Kathy Fielding, MD](Practitioner-practitioner-2.md)

> **participant****role**:Patient (person)**member**:[Amy V. Shaw](Patient-example.md)

> **participant****role**:Caregiver (person)**member**:[Sarah van Putten](RelatedPerson-shaw-niece.md)



## Resource Content

```json
{
  "resourceType" : "CareTeam",
  "id" : "missing-coded-data-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|8.0.1"
    ]
  },
  "status" : "active",
  "name" : "US-Core example CareTeam",
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "participant" : [
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
              "code" : "unknown",
              "display" : "unknown"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/practitioner-1",
        "display" : "Ronald Bone, MD"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/731000124108",
              "code" : "453231000124104",
              "display" : "Primary care provider"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/practitioner-2",
        "display" : "Kathy Fielding, MD"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/731000124108",
              "code" : "116154003",
              "display" : "Patient (person)"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Patient/example",
        "display" : "Amy V. Shaw"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/731000124108",
              "code" : "133932002",
              "display" : "Caregiver (person)"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "RelatedPerson/shaw-niece",
        "display" : "Sarah van Putten"
      }
    }
  ]
}

```
