# Colonoscopy Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Colonoscopy Example**

## Example CarePlan: Colonoscopy Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Subject:**Amy Shaw
**Author:**Dr Ronald Bone
**Assessment**
1. Recurrent GI bleed of unknown etiology; hypotension perhaps secondary to this but as likely secondary to polypharmacy.
1. Acute on chronic anemia secondary to #1.
1. Azotemia, acute renal failure with volume loss secondary to #1.
1. Hyperkalemia secondary to #3 and on ACE and K+ supplement.
1. Other chronic diagnoses as noted above, currently stable.

| | |
| :--- | :--- |
| Colonoscopy | April 21, 2000 |



## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "colonoscopy",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|8.0.1"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/careplan-category",
          "code" : "assess-plan"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "contributor" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ]
}

```
