# AllergyIntolerance Provenance Example 1 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance Provenance Example 1**

## Example Bundle: AllergyIntolerance Provenance Example 1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "allergyintolerance-provenance-example1",
  "meta" : {
    "lastUpdated" : "2019-07-09T18:49:01.235+00:00"
  },
  "type" : "searchset",
  "total" : 1,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://example.org/fhir/AllergyIntolerance?patient=Patient/example&_revinclude=Provenance:target"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/AllergyIntolerance/79613",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "79613",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2019-07-09T15:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_79613\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 79613</b></p><a name=\"79613\"> </a><a name=\"hc79613\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2019-07-09 15:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-us-core-allergyintolerance.html\">US Core AllergyIntolerance Profile</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>category</b>: Medication</p><p><b>criticality</b>: High Risk</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 762952008}\">Peanuts</span></p><p><b>patient</b>: <a href=\"Patient-example.html\">Amy V. Baxter  (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))</a></p><p><b>onset</b>: 2017-06-09</p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td><td><b>Onset</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 247472004}\">Hives</span></td><td>2017-06-09</td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : ["medication"],
        "criticality" : "high",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/731000124108",
              "code" : "762952008",
              "display" : "Peanuts"
            }
          ],
          "text" : "Peanuts"
        },
        "patient" : {
          "reference" : "Patient/example"
        },
        "onsetDateTime" : "2017-06-09",
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "version" : "http://snomed.info/sct/731000124108",
                    "code" : "247472004",
                    "display" : "Hives"
                  }
                ]
              }
            ],
            "onset" : "2017-06-09"
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Provenance/79614",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "79614",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2019-07-09T15:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_79614\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 79614</b></p><a name=\"79614\"> </a><a name=\"hc79614\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2019-07-09 15:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-us-core-provenance.html\">US Core Provenance Profile</a></p></div><p>Provenance for <a href=\"Bundle-allergyintolerance-provenance-example1.html#AllergyIntolerance_79613\">AllergyIntolerance Peanuts</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>2019-07-09 15:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td><td><b>On Behalf Of</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td><a href=\"Practitioner-practitioner-1.html\">Practitioner Ronald Bone </a></td><td><a href=\"Organization-saint-luke-w-endpoint.html\">Organization Saint Luke's Hospital of Kansas City</a></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td><a href=\"Practitioner-practitioner-2.html\">Practitioner Fielding Kathy </a></td><td><a href=\"Organization-saint-luke-w-endpoint.html\">Organization Saint Luke's Hospital of Kansas City</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "AllergyIntolerance/79613/_history/1"
          }
        ],
        "recorded" : "2019-07-09T15:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author",
                  "display" : "Author"
                }
              ]
            },
            "who" : {
              "reference" : "Practitioner/practitioner-1"
            },
            "onBehalfOf" : {
              "reference" : "Organization/saint-luke-w-endpoint"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author",
                  "display" : "Author"
                }
              ]
            },
            "who" : {
              "reference" : "Practitioner/practitioner-2"
            },
            "onBehalfOf" : {
              "reference" : "Organization/saint-luke-w-endpoint"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    }
  ]
}

```
