# PractitionerRole_Practitioner_Endpoint_Bundle_Example Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole_Practitioner_Endpoint_Bundle_Example Example**

## Example Bundle: PractitionerRole_Practitioner_Endpoint_Bundle_Example Example



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "66c8856b-ba11-4876-8aa8-467aad8c11a2",
  "type" : "searchset",
  "total" : 1,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://example.org/fhir/PractitionerRole?_id=PractitionerRole-1&_include=PractitionerRole%3Apractitioner&_include=PractitionerRole%3Aendpoint"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://52.90.126.238:8080/fhir/baseDstu3/PractitionerRole/PractitionerRole-1",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "PractitionerRole-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_PractitionerRole-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole PractitionerRole-1</b></p><a name=\"PractitionerRole-1\"> </a><a name=\"hcPractitionerRole-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-us-core-practitionerrole.html\">US Core PractitionerRole Profile</a></p></div><p><b>practitioner</b>: <a href=\"Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.html#Practitioner_Practitioner-1011\">Brenda Jennings Richard MD</a></p><p><b>organization</b>: <a href=\"Organization-acme-lab.html\">Acme Lab</a></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction PCP}, {http://nucc.org/provider-taxonomy 261QP2300X}\">primary care physician</span></p><p><b>specialty</b>: <span title=\"Codes:{http://nucc.org/provider-taxonomy 208D00000X}\">General Practice Physician</span></p><p><b>location</b>: <a href=\"Location-hl7east.html\">Health Level Seven International</a></p><p><b>endpoint</b>: </p><ul><li><a href=\"Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.html#http-//52.90.126.238-8080/fhir/baseDstu3/Endpoint/71\">Westwood Physicians Organization ADT</a></li><li><a href=\"Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.html#http-//52.90.126.238-8080/fhir/baseDstu3/Endpoint/71\">Brenda.Jennings.Richard.MD@direct.example.org</a></li></ul></div>"
        },
        "practitioner" : {
          "reference" : "Practitioner/Practitioner-1011",
          "display" : "Brenda Jennings Richard MD"
        },
        "organization" : {
          "reference" : "Organization/acme-lab",
          "display" : "Acme Lab"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction",
                "code" : "PCP",
                "display" : "primary care physician"
              },
              {
                "system" : "http://nucc.org/provider-taxonomy",
                "code" : "261QP2300X",
                "display" : "Primary Care Clinic/Center"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "http://nucc.org/provider-taxonomy",
                "code" : "208D00000X",
                "display" : "General Practice Physician"
              }
            ]
          }
        ],
        "location" : [
          {
            "reference" : "Location/hl7east",
            "display" : "Health Level Seven International"
          }
        ],
        "endpoint" : [
          {
            "reference" : "http://52.90.126.238:8080/fhir/baseDstu3/Endpoint/71",
            "display" : "Westwood Physicians Organization ADT"
          },
          {
            "reference" : "http://52.90.126.238:8080/fhir/baseDstu3/Endpoint/71",
            "display" : "Brenda.Jennings.Richard.MD@direct.example.org"
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://52.90.126.238:8080/fhir/baseDstu3/Practitioner/Practitioner-1011",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Practitioner-1011",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Practitioner-1011\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Practitioner-1011</b></p><a name=\"Practitioner-1011\"> </a><a name=\"hcPractitioner-1011\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-us-core-practitioner.html\">US Core Practitioner Profile</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-ssn.html\" title=\"United States Social Security Number (SSN).  Assigned by the U.S. Social Security Administration.  Note: IRS assigned ITINs are often used as drop-ins for social security numbers.  The SSN is represented in resources with dashes removed. See http://www.ssa.gov/.\">United States Social Security Number</a>/000001011 (use: official, ), <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/9999991018 (use: official, ), <code>http://example.org/fhir/cks</code>/d46f70565a1042f6a6ece48dd81b408f (use: official, )</p><p><b>name</b>: Brenda Jennings Richard </p><p><b>telecom</b>: ph: 313-555-6868(Home), ph: 313-555-6443(Work)</p><p><b>address</b>: 346 W Plum Avenu Dearborn MI 48123</p><p><b>birthDate</b>: 1976-11-15</p><h3>Qualifications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td><td><b>Issuer</b></td></tr><tr><td style=\"display: none\">*</td><td>Michigan Medical License/LARA-1011 (use: official, )</td><td><span title=\"Codes:{http://example.org/fhir/michigan.gov/lara/license-type 4305}\">Medical Doctor</span></td><td>Michigan Department of Licensing and Regulatory Affairs</td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "http://hl7.org/fhir/sid/us-ssn",
            "value" : "000001011"
          },
          {
            "use" : "official",
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9999991018"
          },
          {
            "use" : "official",
            "system" : "http://example.org/fhir/cks",
            "value" : "d46f70565a1042f6a6ece48dd81b408f"
          }
        ],
        "name" : [
          {
            "family" : "Richard",
            "given" : ["Brenda", "Jennings"],
            "suffix" : ["MD"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "313-555-6868",
            "use" : "home"
          },
          {
            "system" : "phone",
            "value" : "313-555-6443",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "text" : "346 W Plum Avenu Dearborn MI 48123",
            "line" : ["346 W Plum Avenue"],
            "city" : "Dearborn",
            "state" : "MI",
            "postalCode" : "48126"
          }
        ],
        "birthDate" : "1976-11-15",
        "qualification" : [
          {
            "identifier" : [
              {
                "use" : "official",
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MD",
                      "display" : "Medical License number"
                    }
                  ],
                  "text" : "Michigan Medical License"
                },
                "system" : "http://example.org/fhir/michigan.gov/fhir/medical-license",
                "value" : "LARA-1011",
                "assigner" : {
                  "display" : "State of Michigan"
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://example.org/fhir/michigan.gov/lara/license-type",
                  "code" : "4305",
                  "display" : "Medical Doctor"
                }
              ]
            },
            "issuer" : {
              "display" : "Michigan Department of Licensing and Regulatory Affairs"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://52.90.126.238:8080/fhir/baseDstu3/Endpoint/71",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "71",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_71\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 71</b></p><a name=\"71\"> </a><a name=\"hc71\"> </a><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-direct-project\">Endpoint Connection Type: direct-project</a> (Direct Project)</p><p><b>name</b>: Brenda.Jennings.Richard.MD@direct.example.org</p><p><b>managingOrganization</b>: <a href=\"Organization-acme-lab.html\">Organization Acme Labs</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode urn:hl7-org:sdwg:ccda-structuredBody:1.1}\">For documents following C-CDA 1.1 constraints using a structured body.</span></p><p><b>payloadMimeType</b>: text/xml</p><p><b>address</b>: <a href=\"mailto:Brenda.Jennings.Richard.MD@direct.example.org\">Brenda.Jennings.Richard.MD@direct.example.org</a></p></div>"
        },
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "direct-project"
        },
        "name" : "Brenda.Jennings.Richard.MD@direct.example.org",
        "managingOrganization" : {
          "reference" : "Organization/acme-lab"
        },
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
                "code" : "urn:hl7-org:sdwg:ccda-structuredBody:1.1"
              }
            ]
          }
        ],
        "payloadMimeType" : ["text/xml"],
        "address" : "mailto:Brenda.Jennings.Richard.MD@direct.example.org"
      },
      "search" : {
        "mode" : "include"
      }
    }
  ]
}

```
