# hl7.cda.uv.core#2.0.2-sd: Clinical Document Architecture

## Pages

* [IG Home Page](index.md)
* [Graphical Map of Datatypes](dt-uml.md)
* [Terminology](terminology.md)
* [Good Health Clinic Consultation Note (April 7, 2000)](transformed-example.md)
* [Narrative Block](narrative.md)
* [Implementation Notes](implementation.md)
* [Overview](overview.md)
* [Graphical Map of CDA](cda-rmim.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)

## Resources

### CodeSystems

* [Binary Data Encoding Code System](CodeSystem-BinaryDataEncoding.md)
* [IG Parameters CDA Validation](CodeSystem-IGParametersCDAValidation.md)

### ValueSets

* [CDABinaryDataEncoding](ValueSet-BinaryDataEncoding.md)
* [CDAActClass](ValueSet-CDAActClass.md)
* [CDAActClassObservation](ValueSet-CDAActClassObservation.md)
* [CDAActMood](ValueSet-CDAActMood.md)
* [CDAActMoodIntent](ValueSet-CDAActMoodIntent.md)
* [CDAActRelationshipType](ValueSet-CDAActRelationshipType.md)
* [CDAActSubstanceAdministrationCode](ValueSet-CDAActSubstanceAdministrationCode.md)
* [CDACompressionAlgorithm](ValueSet-CDACompressionAlgorithm.md)
* [CDAContextControl](ValueSet-CDAContextControl.md)
* [CDAEntityCode](ValueSet-CDAEntityCode.md)
* [CDAEntityNamePartQualifier](ValueSet-CDAEntityNamePartQualifier.md)
* [CDAEntityNameUse](ValueSet-CDAEntityNameUse.md)
* [CDAInformationRecipientRole](ValueSet-CDAInformationRecipientRole.md)
* [CDAMaterialEntityClassType](ValueSet-CDAMaterialEntityClassType.md)
* [CDANullFlavor](ValueSet-CDANullFlavor.md)
* [CDAObservationInterpretation](ValueSet-CDAObservationInterpretation.md)
* [CDAParticipationType](ValueSet-CDAParticipationType.md)
* [CDAPostalAddressUse](ValueSet-CDAPostalAddressUse.md)
* [CDARoleClass](ValueSet-CDARoleClass.md)
* [CDARoleClassAssociative](ValueSet-CDARoleClassAssociative.md)
* [CDARoleClassMutualRelationship](ValueSet-CDARoleClassMutualRelationship.md)
* [CDARoleClassRoot](ValueSet-CDARoleClassRoot.md)
* [CDARoleCode](ValueSet-CDARoleCode.md)
* [CDASetOperator](ValueSet-CDASetOperator.md)
* [CDASignatureCode](ValueSet-CDASignatureCode.md)
* [CDATimingEvent](ValueSet-CDATimingEvent.md)

### Logicals

* [AD: PostalAddress (V3 Data Type)](StructureDefinition-AD.md)
* [ADXP: CharacterString (V3 Data Type)](StructureDefinition-ADXP.md)
* [ANY: DataValue (V3 Data Type)](StructureDefinition-ANY.md)
* [Act (CDA Class)](StructureDefinition-Act.md)
* [AlternateIdentification (CDA Class)](StructureDefinition-AlternateIdentification.md)
* [AssignedAuthor (CDA Class)](StructureDefinition-AssignedAuthor.md)
* [AssignedCustodian (CDA Class)](StructureDefinition-AssignedCustodian.md)
* [AssignedEntity (CDA Class)](StructureDefinition-AssignedEntity.md)
* [AssociatedEntity (CDA Class)](StructureDefinition-AssociatedEntity.md)
* [Authenticator (CDA Class)](StructureDefinition-Authenticator.md)
* [Author (CDA Class)](StructureDefinition-Author.md)
* [AuthoringDevice (CDA Class)](StructureDefinition-AuthoringDevice.md)
* [Authorization (CDA Class)](StructureDefinition-Authorization.md)
* [BL: Boolean (V3 Data Type)](StructureDefinition-BL.md)
* [Birthplace (CDA Class)](StructureDefinition-Birthplace.md)
* [CD: ConceptDescriptor (V3 Data Type)](StructureDefinition-CD.md)
* [CE: CodedWithEquivalents (V3 Data Type)](StructureDefinition-CE.md)
* [CO: CodedOrdinal (V3 Data Type)](StructureDefinition-CO.md)
* [CR: ConceptRole (V3 Data Type)](StructureDefinition-CR.md)
* [CS: CodedSimpleValue (V3 Data Type)](StructureDefinition-CS.md)
* [CV: CodedValue (V3 Data Type)](StructureDefinition-CV.md)
* [ClinicalDocument (CDA Class)](StructureDefinition-ClinicalDocument.md)
* [Component (CDA Class)](StructureDefinition-Component.md)
* [ComponentOf (CDA Class)](StructureDefinition-ComponentOf.md)
* [Consent (CDA Class)](StructureDefinition-Consent.md)
* [Criterion (CDA Class)](StructureDefinition-Criterion.md)
* [Custodian (CDA Class)](StructureDefinition-Custodian.md)
* [CustodianOrganization (CDA Class)](StructureDefinition-CustodianOrganization.md)
* [DataEnterer (CDA Class)](StructureDefinition-DataEnterer.md)
* [Device (CDA Class)](StructureDefinition-Device.md)
* [DocumentationOf (CDA Class)](StructureDefinition-DocumentationOf.md)
* [ED: EncapsulatedData (V3 Data Type)](StructureDefinition-ED.md)
* [EIVL_TS: EventRelatedPeriodicInterval (V3 Data Type)](StructureDefinition-EIVL-TS.md)
* [EN: EntityName (V3 Data Type)](StructureDefinition-EN.md)
* [ENXP: Entity Name Part (V3 Data Type)](StructureDefinition-ENXP.md)
* [EncompassingEncounter (CDA Class)](StructureDefinition-EncompassingEncounter.md)
* [Encounter (CDA Class)](StructureDefinition-Encounter.md)
* [EncounterParticipant (CDA Class)](StructureDefinition-EncounterParticipant.md)
* [Entity (CDA Class)](StructureDefinition-Entity.md)
* [Entry (CDA Class)](StructureDefinition-Entry.md)
* [EntryRelationship (CDA Class)](StructureDefinition-EntryRelationship.md)
* [ExternalAct (CDA Class)](StructureDefinition-ExternalAct.md)
* [ExternalDocument (CDA Class)](StructureDefinition-ExternalDocument.md)
* [ExternalObservation (CDA Class)](StructureDefinition-ExternalObservation.md)
* [ExternalProcedure (CDA Class)](StructureDefinition-ExternalProcedure.md)
* [Guardian (CDA Class)](StructureDefinition-Guardian.md)
* [HealthCareFacility (CDA Class)](StructureDefinition-HealthCareFacility.md)
* [II: InstanceIdentifier (V3 Data Type)](StructureDefinition-II.md)
* [INT_POS: Positive integer numbers (V3 Data Type)](StructureDefinition-INT-POS.md)
* [INT: IntegerNumber (V3 Data Type)](StructureDefinition-INT.md)
* [IVL_INT: Interval (V3 Data Type)](StructureDefinition-IVL-INT.md)
* [IVL_PQ: Interval (V3 Data Type)](StructureDefinition-IVL-PQ.md)
* [IVL_TS: Interval (V3 Data Type)](StructureDefinition-IVL-TS.md)
* [IVXB_INT: Interval Boundary IntegerNumber (V3 Data Type)](StructureDefinition-IVXB-INT.md)
* [IVXB_PQ: Interval Boundary PhysicalQuantity (V3 Data Type)](StructureDefinition-IVXB-PQ.md)
* [IVXB_TS: Interval Boundary PointInTime (V3 Data Type)](StructureDefinition-IVXB-TS.md)
* [IdentifiedBy (CDA Class)](StructureDefinition-IdentifiedBy.md)
* [InFulfillmentOf (CDA Class)](StructureDefinition-InFulfillmentOf.md)
* [InFulfillmentOf1 (CDA Class)](StructureDefinition-InFulfillmentOf1.md)
* [Informant (CDA Class)](StructureDefinition-Informant.md)
* [InformationRecipient (CDA Class)](StructureDefinition-InformationRecipient.md)
* [InfrastructureRoot (Base Type for all CDA Classes)](StructureDefinition-InfrastructureRoot.md)
* [IntendedRecipient (CDA Class)](StructureDefinition-IntendedRecipient.md)
* [LabeledDrug (CDA Class)](StructureDefinition-LabeledDrug.md)
* [LanguageCommunication (CDA Class)](StructureDefinition-LanguageCommunication.md)
* [LegalAuthenticator (CDA Class)](StructureDefinition-LegalAuthenticator.md)
* [MO: MonetaryAmount (V3 Data Type)](StructureDefinition-MO.md)
* [MaintainedEntity (CDA Class)](StructureDefinition-MaintainedEntity.md)
* [ManufacturedProduct (CDA Class)](StructureDefinition-ManufacturedProduct.md)
* [Material (CDA Class)](StructureDefinition-Material.md)
* [NonXMLBody (CDA Class)](StructureDefinition-NonXMLBody.md)
* [ON: OrganizationName (V3 Data Type)](StructureDefinition-ON.md)
* [Observation (CDA Class)](StructureDefinition-Observation.md)
* [ObservationMedia (CDA Class)](StructureDefinition-ObservationMedia.md)
* [ObservationRange (CDA Class)](StructureDefinition-ObservationRange.md)
* [Order (CDA Class)](StructureDefinition-Order.md)
* [Organization (CDA Class)](StructureDefinition-Organization.md)
* [OrganizationPartOf (CDA Class)](StructureDefinition-OrganizationPartOf.md)
* [Organizer (CDA Class)](StructureDefinition-Organizer.md)
* [OrganizerComponent (CDA Class)](StructureDefinition-OrganizerComponent.md)
* [PIVL_TS: PeriodicIntervalOfTime (V3 Data Type)](StructureDefinition-PIVL-TS.md)
* [PN: PersonName (V3 Data Type)](StructureDefinition-PN.md)
* [PQ: PhysicalQuantity (V3 Data Type)](StructureDefinition-PQ.md)
* [PQR: PhysicalQuantityRepresentation (V3 Data Type)](StructureDefinition-PQR.md)
* [ParentDocument (CDA Class)](StructureDefinition-ParentDocument.md)
* [Participant1 (CDA Class)](StructureDefinition-Participant1.md)
* [Participant2 (CDA Class)](StructureDefinition-Participant2.md)
* [ParticipantRole (CDA Class)](StructureDefinition-ParticipantRole.md)
* [Patient (CDA Class)](StructureDefinition-Patient.md)
* [PatientRole (CDA Class)](StructureDefinition-PatientRole.md)
* [Performer1 (CDA Class)](StructureDefinition-Performer1.md)
* [Performer2 (CDA Class)](StructureDefinition-Performer2.md)
* [Person (CDA Class)](StructureDefinition-Person.md)
* [Place (CDA Class)](StructureDefinition-Place.md)
* [PlayingEntity (CDA Class)](StructureDefinition-PlayingEntity.md)
* [Precondition (CDA Class)](StructureDefinition-Precondition.md)
* [Precondition2 (CDA Class)](StructureDefinition-Precondition2.md)
* [PreconditionBase (CDA Class)](StructureDefinition-PreconditionBase.md)
* [Procedure (CDA Class)](StructureDefinition-Procedure.md)
* [QTY: Quantity (V3 Data Type)](StructureDefinition-QTY.md)
* [REAL: RealNumber (V3 Data Type)](StructureDefinition-REAL.md)
* [RTO_PQ_PQ: Ratio (V3 Data Type)](StructureDefinition-RTO-PQ-PQ.md)
* [RecordTarget (CDA Class)](StructureDefinition-RecordTarget.md)
* [Reference (CDA Class)](StructureDefinition-Reference.md)
* [RegionOfInterest (CDA Class)](StructureDefinition-RegionOfInterest.md)
* [RelatedDocument (CDA Class)](StructureDefinition-RelatedDocument.md)
* [RelatedEntity (CDA Class)](StructureDefinition-RelatedEntity.md)
* [RelatedSubject (CDA Class)](StructureDefinition-RelatedSubject.md)
* [SC: CharacterStringWithCode (V3 Data Type)](StructureDefinition-SC.md)
* [ST: CharacterString (V3 Data Type)](StructureDefinition-ST.md)
* [SXCM_TS: GeneralTimingSpecification (V3 Data Type)](StructureDefinition-SXCM-TS.md)
* [SXPR_TS: Component part of GTS (V3 Data Type)](StructureDefinition-SXPR-TS.md)
* [Section (CDA Class)](StructureDefinition-Section.md)
* [ServiceEvent (CDA Class)](StructureDefinition-ServiceEvent.md)
* [Specimen (CDA Class)](StructureDefinition-Specimen.md)
* [SpecimenRole (CDA Class)](StructureDefinition-SpecimenRole.md)
* [StructuredBody (CDA Class)](StructureDefinition-StructuredBody.md)
* [Subject (CDA Class)](StructureDefinition-Subject.md)
* [SubjectPerson (CDA Class)](StructureDefinition-SubjectPerson.md)
* [SubstanceAdministration (CDA Class)](StructureDefinition-SubstanceAdministration.md)
* [Supply (CDA Class)](StructureDefinition-Supply.md)
* [TEL: TelecommunicationAddress (V3 Data Type)](StructureDefinition-TEL.md)
* [TN: TrivialName (V3 Data Type)](StructureDefinition-TN.md)
* [TS: PointInTime (V3 Data Type)](StructureDefinition-TS.md)

### Primitive-type Profiles

* [bin: Binary Data](StructureDefinition-bin.md)
* [bl: Boolean](StructureDefinition-bl-simple.md)
* [bn: BooleanNonNull](StructureDefinition-bn.md)
* [cs: Coded Simple Value](StructureDefinition-cs-simple.md)
* [int: Integer Number](StructureDefinition-int-simple.md)
* [oid: ISO Object Identifier](StructureDefinition-oid.md)
* [probability: Probability](StructureDefinition-probability.md)
* [real: Real Number](StructureDefinition-real-simple.md)
* [ruid: HL7 Reserved Identifier Scheme](StructureDefinition-ruid.md)
* [st: Character String](StructureDefinition-st-simple.md)
* [ts: Point in Time](StructureDefinition-ts-simple.md)
* [uid: Unique Identifier String](StructureDefinition-uid.md)
* [url: Universal Resource Locator](StructureDefinition-url.md)
* [uuid: DCE Universal Unique Identifier](StructureDefinition-uuid.md)
* [xs:ID](StructureDefinition-xs-ID.md)

### ImplementationGuides

* [Clinical Document Architecture](index.md)

### Examples

* [clinicaldocument-example (Binary)](Binary-clinicaldocument-example.md)
