# IG Home Page - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* **IG Home Page**

## IG Home Page

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/stds/core/ImplementationGuide/hl7.cda.uv.core | *Version*:2.0.2-sd |
| Active as of 2025-12-11 | *Computable Name*:ClinicalDocumentArchitecture |

### CDA Definition

This Implementation Guide is a representation of the [Clinical Document Architecture (CDA) R2.0 specification](https://hl7.org/cda/stds/online-navigation/index.html) using FHIR Logical Models expressed as FHIR StructureDefinition instances. The main purpose of the guide is to support the Consolidated CDA specification which defines its templates using these logical structures. Other CDA-based guides can also use this guide and these structures to create specifications like Consolidated CDA.

This guide does not replace the CDA specification. It includes the Overview, Implementation Notes, and Narrative Block information from the specification to provide context and guidance. To understand CDA, readers should consult the actual CDA specification. If there are any differences found between the specification and this guide, the specification takes precedence and is assumed to be correct.

#### Versioning of this guide

This guide takes its version from the underlying CDA specification, i.e. 2.0. It also includes the tag '-sd' to make it clear that it is a StructureDefinition representation of the CDA 2.0 specification. It is currently versioned at 2.0.2 as this is the 3rd version of this guide. 2.0.0-sd was the original guide, 2.0.1-sd was published in 2024, and 2.0.2-sd was published in 2025. Each version of this guide includes any errata fixes that have been found since the previous version, as well as any new sdtc schema extensions that have been introduced since the previous version.

| | | |
| :--- | :--- | :--- |
| ### CDA Classes* [**ClinicalDocument**](StructureDefinition-ClinicalDocument.md)
* [Act](StructureDefinition-Act.md)
* [AlternateIdentification](StructureDefinition-AlternateIdentification.md)
* [AssignedAuthor](StructureDefinition-AssignedAuthor.md)
* [AssignedCustodian](StructureDefinition-AssignedCustodian.md)
* [AssignedEntity](StructureDefinition-AssignedEntity.md)
* [AssociatedEntity](StructureDefinition-AssociatedEntity.md)
* [Authenticator](StructureDefinition-Authenticator.md)
* [Author](StructureDefinition-Author.md)
* [AuthoringDevice](StructureDefinition-AuthoringDevice.md)
* [Authorization](StructureDefinition-Authorization.md)
* [Birthplace](StructureDefinition-Birthplace.md)
* [Component](StructureDefinition-Component.md)
* [ComponentOf](StructureDefinition-ComponentOf.md)
* [Consent](StructureDefinition-Consent.md)
* [Criterion](StructureDefinition-Criterion.md)
* [Custodian](StructureDefinition-Custodian.md)
* [CustodianOrganization](StructureDefinition-CustodianOrganization.md)
* [DataEnterer](StructureDefinition-DataEnterer.md)
* [Device](StructureDefinition-Device.md)
* [DocumentationOf](StructureDefinition-DocumentationOf.md)
* [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md)
* [Encounter](StructureDefinition-Encounter.md)
* [EncounterParticipant](StructureDefinition-EncounterParticipant.md)
* [Entity](StructureDefinition-Entity.md)
* [Entry](StructureDefinition-Entry.md)
* [EntryRelationship](StructureDefinition-EntryRelationship.md)
* [ExternalAct](StructureDefinition-ExternalAct.md)
* [ExternalDocument](StructureDefinition-ExternalDocument.md)
* [ExternalObservation](StructureDefinition-ExternalObservation.md)
* [ExternalProcedure](StructureDefinition-ExternalProcedure.md)
* [Guardian](StructureDefinition-Guardian.md)
* [HealthCareFacility](StructureDefinition-HealthCareFacility.md)
* [IdentifiedBy](StructureDefinition-IdentifiedBy.md)
* [InFulfillmentOf](StructureDefinition-InFulfillmentOf.md)
* [InFulfillmentOf1](StructureDefinition-InFulfillmentOf1.md)
* [Informant](StructureDefinition-Informant.md)
* [InformationRecipient](StructureDefinition-InformationRecipient.md)
* [InfrastructureRoot](StructureDefinition-InfrastructureRoot.md)
* [IntendedRecipient](StructureDefinition-IntendedRecipient.md)
* [LabeledDrug](StructureDefinition-LabeledDrug.md)
* [LanguageCommunication](StructureDefinition-LanguageCommunication.md)
* [LegalAuthenticator](StructureDefinition-LegalAuthenticator.md)
* [MaintainedEntity](StructureDefinition-MaintainedEntity.md)
* [ManufacturedProduct](StructureDefinition-ManufacturedProduct.md)
* [Material](StructureDefinition-Material.md)
* [NonXMLBody](StructureDefinition-NonXMLBody.md)
* [Observation](StructureDefinition-Observation.md)
* [ObservationMedia](StructureDefinition-ObservationMedia.md)
* [ObservationRange](StructureDefinition-ObservationRange.md)
* [Order](StructureDefinition-Order.md)
* [Organization](StructureDefinition-Organization.md)
* [OrganizationPartOf](StructureDefinition-OrganizationPartOf.md)
* [Organizer](StructureDefinition-Organizer.md)
* [OrganizerComponent](StructureDefinition-OrganizerComponent.md)
* [ParentDocument](StructureDefinition-ParentDocument.md)
* [Participant1](StructureDefinition-Participant1.md)
* [Participant2](StructureDefinition-Participant2.md)
* [ParticipantRole](StructureDefinition-ParticipantRole.md)
* [Patient](StructureDefinition-Patient.md)
* [PatientRole](StructureDefinition-PatientRole.md)
* [Performer1](StructureDefinition-Performer1.md)
* [Performer2](StructureDefinition-Performer2.md)
* [Person](StructureDefinition-Person.md)
* [Place](StructureDefinition-Place.md)
* [PlayingEntity](StructureDefinition-PlayingEntity.md)
* [Precondition](StructureDefinition-Precondition.md)
* [Precondition2](StructureDefinition-Precondition2.md)
* [Procedure](StructureDefinition-Procedure.md)
* [RecordTarget](StructureDefinition-RecordTarget.md)
* [Reference](StructureDefinition-Reference.md)
* [RegionOfInterest](StructureDefinition-RegionOfInterest.md)
* [RelatedDocument](StructureDefinition-RelatedDocument.md)
* [RelatedEntity](StructureDefinition-RelatedEntity.md)
* [RelatedSubject](StructureDefinition-RelatedSubject.md)
* [Section](StructureDefinition-Section.md)
* [ServiceEvent](StructureDefinition-ServiceEvent.md)
* [Specimen](StructureDefinition-Specimen.md)
* [SpecimenRole](StructureDefinition-SpecimenRole.md)
* [StructuredBody](StructureDefinition-StructuredBody.md)
* [Subject](StructureDefinition-Subject.md)
* [SubjectPerson](StructureDefinition-SubjectPerson.md)
* [SubstanceAdministration](StructureDefinition-SubstanceAdministration.md)
* [Supply](StructureDefinition-Supply.md)
 | ### V3 Complex Data Types* [AD: PostalAddress](StructureDefinition-AD.md)
* [ADXP: CharacterString](StructureDefinition-ADXP.md)
* [ANY: DataValue](StructureDefinition-ANY.md)
* [BL: Boolean](StructureDefinition-BL.md)
* [CD: ConceptDescriptor](StructureDefinition-CD.md)
* [CE: CodedWithEquivalents](StructureDefinition-CE.md)
* [CO: CodedOrdinal](StructureDefinition-CO.md)
* [CR: ConceptRole](StructureDefinition-CR.md)
* [CS: CodedSimpleValue](StructureDefinition-CS.md)
* [CV: CodedValue](StructureDefinition-CV.md)
* [ED: EncapsulatedData](StructureDefinition-ED.md)
* [EIVL_TS: EventRelatedPeriodicInterval](StructureDefinition-EIVL-TS.md)
* [EN: EntityName](StructureDefinition-EN.md)
* [ENXP: Entity Name Part](StructureDefinition-ENXP.md)
* [II: InstanceIdentifier](StructureDefinition-II.md)
* [INT_POS: Positive integer numbers](StructureDefinition-INT-POS.md)
* [INT: IntegerNumber](StructureDefinition-INT.md)
* [IVL_INT: Interval](StructureDefinition-IVL-INT.md)
* [IVL_PQ: Interval](StructureDefinition-IVL-PQ.md)
* [IVL_TS: Interval](StructureDefinition-IVL-TS.md)
* [IVXB_INT: Interval Boundary IntegerNumber](StructureDefinition-IVXB-INT.md)
* [IVXB_PQ: Interval Boundary PhysicalQuantity](StructureDefinition-IVXB-PQ.md)
* [IVXB_TS: Interval Boundary PointInTime](StructureDefinition-IVXB-TS.md)
* [MO: MonetaryAmount](StructureDefinition-MO.md)
* [ON: OrganizationName](StructureDefinition-ON.md)
* [PIVL_TS: PeriodicIntervalOfTime](StructureDefinition-PIVL-TS.md)
* [PN: PersonName](StructureDefinition-PN.md)
* [PQ: PhysicalQuantity](StructureDefinition-PQ.md)
* [PQR: PhysicalQuantityRepresentation](StructureDefinition-PQR.md)
* [QTY: Quantity](StructureDefinition-QTY.md)
* [REAL: RealNumber](StructureDefinition-REAL.md)
* [RTO_PQ_PQ: Ratio](StructureDefinition-RTO-PQ-PQ.md)
* [SC: CharacterStringWithCode](StructureDefinition-SC.md)
* [ST: CharacterString](StructureDefinition-ST.md)
* [SXCM_TS: GeneralTimingSpecification](StructureDefinition-SXCM-TS.md)
* [SXPR_TS: Component part of GTS](StructureDefinition-SXPR-TS.md)
* [TEL: TelecommunicationAddress](StructureDefinition-TEL.md)
* [TN: TrivialName](StructureDefinition-TN.md)
* [TS: PointInTime](StructureDefinition-TS.md)
 | ### V3 Simple Data Types* [bin: Binary Data](StructureDefinition-bin.md)
* [bl: Boolean](StructureDefinition-bl-simple.md)
* [bn: BooleanNonNull](StructureDefinition-bn.md)
* [cs: Coded Simple Value](StructureDefinition-cs-simple.md)
* [int: Integer Number](StructureDefinition-int-simple.md)
* [oid: ISO Object Identifier](StructureDefinition-oid.md)
* [probability: Probability](StructureDefinition-probability.md)
* [real: Real Number](StructureDefinition-real-simple.md)
* [ruid: HL7 Reserved Identifier Scheme](StructureDefinition-ruid.md)
* [st: Character String](StructureDefinition-st-simple.md)
* [ts: Point in Time](StructureDefinition-ts-simple.md)
* [uid: Unique Identifier String](StructureDefinition-uid.md)
* [url: Universal Resource Locator](StructureDefinition-url.md)
* [uuid: DCE Universal Unique Identifier](StructureDefinition-uuid.md)
 |

### CDA Extensions

This guide also incorporates the [approved SDTC extensions](https://confluence.hl7.org/display/SD/CDA+Extensions). Elements from the extensions will be found with 'sdtc' before their name. They also are defined to be in the `urn:hl7-org:sdtc` namespace and that is visible in the structure pages. [Custodian Organization](StructureDefinition-CustodianOrganization.md) has an example of an extension element (sdtcTelecom). Note that while extensions are prefixed with 'sdtc', their actual XML name does not include this. Their XML name is displayed in the structure pages as `XML`. For example, the CustodianOrganization's sdtcTelecom would appear in an instance as either `<telecom xmlns="urn:hl7-org:sdtc" value="...." />` or in a document with a defined prefix for sdtc:

```
<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:v3/voc">
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<sdtc:telecom value="..." />
	...

```

### CDA Example

An [example of a CDA document](Binary-clinicaldocument-example.md) has been provided along with a [transformed version of the example](transformed-example.md) using the [informative CDA stylesheet](https://github.com/HL7/cda-core-xsl).

### CDA Validation

With the representation of the CDA structures using FHIR StructureDefinitions, there is now an option on how to validate CDA documents. The CDA schemas are still valid and can be [found here](https://github.com/HL7/CDA-core-2.0). Additionally, by pointing the FHIR validator at this guide, CDA instances can be validated using FHIR validators.

#### FHIRPath Supplements

The FHIRPath language defines a set of contexts that get passed into expressions and also allows the definition of additional contexts and functions. CDA provides the following supplemental guidance for evaluating FHIRPath:

* The `%resource` variable when it appears in expressions on CDA profiles will be evaluated as the root `ClinicalDocument`.
* A new function: `hasTemplateIdOf([ProfileUrl])` evaluates to true or false based on whether the XML contains a `<templateId />` element corresponding to the identifier of a particular profile.

For example, if a profile like `http://hl7.org/cda/us/custom/StructureDefinition/ExampleSection` contains an identifier property like `urn:hl7ii:2.16.840.1.113883.10.20.22.99.999:2024-05-01`, then the following XPath:

`%resource.component.structuredBody.component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/custom/StructureDefinition/ExampleSection'))`

will return true if the document contains a section with the templateId of Example Section.

It is equivalent to the following, but allows an IG author to easily update the templateId extensions without finding-and-replacing constraint expressions:

`%resource.component.structuredBody.component.where(section.templateId.where(root = '2.16.840.1.113883.10.20.22.99.999' and extension = '2024-05-01'))`

#### Implementation Guide Parameters

Parameters from the [IG Parameters CDA Validation Code System](CodeSystem-IGParametersCDAValidation.md) may be included to control the behavior of Schematron generation in CDA implementation guides written in FHIR StructureDefinition format.

### Authors

The current specification lists the following people as editors/authors:

* Robert H. Dolin, MD
* Liora Alschuler
* Sandy Boyer, BSP
* Calvin Beebe
* Fred M. Behlen, PhD
* Paul V. Biron
* Amnon Shabo (Shvo), PhD

This guide has the following authors:

* Jean Duteau
* Rosemary Hofstede
* Benjamin Flessner
* Susan Rand

The CDA community also benefits from the following people who have contributed to the guide:

* Austin Kreisler
* John D'Amore
* Lisa Nelson
* Brett Marquard
* Gay Dolin
* Matt Szczepankiewicz

### Other Information

This publication includes IP covered under the following statements.

* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.2.0/CodeSystem-v3-loinc.html): [ClinicalDocument](StructureDefinition-ClinicalDocument.md), [ExternalDocument](StructureDefinition-ExternalDocument.md) and [ParentDocument](StructureDefinition-ParentDocument.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [ActCode](http://tx.fhir.org/r5/ValueSet/v3-ActCode): [Act](StructureDefinition-Act.md), [CDAActSubstanceAdministrationCode](ValueSet-CDAActSubstanceAdministrationCode.md)...Show 14 more,[Consent](StructureDefinition-Consent.md),[Criterion](StructureDefinition-Criterion.md),[EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[Encounter](StructureDefinition-Encounter.md),[ExternalAct](StructureDefinition-ExternalAct.md),[ExternalObservation](StructureDefinition-ExternalObservation.md),[ExternalProcedure](StructureDefinition-ExternalProcedure.md),[Observation](StructureDefinition-Observation.md),[ObservationRange](StructureDefinition-ObservationRange.md),[Order](StructureDefinition-Order.md),[Organizer](StructureDefinition-Organizer.md),[RegionOfInterest](StructureDefinition-RegionOfInterest.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md)and[Supply](StructureDefinition-Supply.md)


-------



-------

*There are no Global profiles defined*

