# Artifacts Summary - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### CDA Classes 

Primary CDA Objects

| | |
| :--- | :--- |
| [Act (CDA Class)](StructureDefinition-Act.md) | A derivative of the RIM Act class, to be used when the other more specific classes aren't appropriate.Act.negationInd, when set to "true", is a positive assertion that the Act as a whole is negated. Some properties such as Act.id, Act.moodCode, and the participations are not affected. These properties always have the same meaning: i.e., the author remains the author of the negative Act. An act statement with negationInd is still a statement about the specific fact described by the Act. For instance, a negated "finding of wheezing on July 1" means that the author positively denies that there was wheezing on July 1, and that he takes the same responsibility for such statement and the same requirement to have evidence for such statement than if he had not used negation. |
| [AlternateIdentification (CDA Class)](StructureDefinition-AlternateIdentification.md) | The alternateIdentification extension provides additional information about an identifier found in the linked role. The extensions augment the id information in the linked role. The id in the alternateIdentification extension SHALL match an id in the linked role. The alternateIdentification provides additional information about a particular identifier, such as its type. As an extension it needs to be safe for implementers to ignore this additional information. |
| [AssignedAuthor (CDA Class)](StructureDefinition-AssignedAuthor.md) | An author is a person in the role of an assigned author (AssignedAuthor class). |
| [AssignedCustodian (CDA Class)](StructureDefinition-AssignedCustodian.md) | A custodian is a scoping organization in the role of an assigned custodian (AssignedCustodian class). |
| [AssignedEntity (CDA Class)](StructureDefinition-AssignedEntity.md) | AssignedEntity (CDA Class) |
| [AssociatedEntity (CDA Class)](StructureDefinition-AssociatedEntity.md) | A participant is a person or organization in the role of a participating entity (AssociatedEntity class). |
| [Authenticator (CDA Class)](StructureDefinition-Authenticator.md) | Represents a participant who has attested to the accuracy of the document, but who does not have privileges to legally authenticate the document. An example would be a resident physician who sees a patient and dictates a note, then later signs it. A clinical document can have zero to many authenticators. While electronic signatures are not captured in a CDA document, both authentication and legal authentication require that a document has been signed manually or electronically by the responsible individual. An authenticator has a required authenticator.time indicating the time of authentication, and a required authenticator.signatureCode, indicating that a signature has been obtained and is on file. |
| [Author (CDA Class)](StructureDefinition-Author.md) | Represents the humans and/or machines that authored the document. In some cases, the role or function of the author is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is "Medical Student Progress Note". The role of the author can also be recorded in the Author.functionCode or AssignedAuthor.code attribute. If either of these attributes is included, they should be equivalent to or further specialize the role inherent in the ClinicalDocument.code (such as where the ClinicalDocument.code is simply "Physician Progress Note" and the value of Author.functionCode is "rounding physician"), and shall not conflict with the role inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation. |
| [AuthoringDevice (CDA Class)](StructureDefinition-AuthoringDevice.md) | AuthoringDevice (CDA Class) |
| [Authorization (CDA Class)](StructureDefinition-Authorization.md) | Authorization (CDA Class) |
| [Birthplace (CDA Class)](StructureDefinition-Birthplace.md) | A Patient's birthplace is represented as a relationship between a patient and a place. |
| [ClinicalDocument (CDA Class)](StructureDefinition-ClinicalDocument.md) | This is a generated StructureDefinition that describes CDA - that is, CDA as it actually is for R2. The intent of this StructureDefinition is to enable CDA to be a FHIR resource. That enables the FHIR infrastructure - API, conformance, query - to be used directly against CDA |
| [Component (CDA Class)](StructureDefinition-Component.md) | The CDA body can be either an unstructured blob, or can be comprised of structured markup. Every CDA document has exactly one body, associated with the ClinicalDocument class through the component relationship. |
| [ComponentOf (CDA Class)](StructureDefinition-ComponentOf.md) | Pointer to EncompassingEncounter |
| [Consent (CDA Class)](StructureDefinition-Consent.md) | This class references the consents associated with this document. The type of consent (e.g. a consent to perform the related[ServiceEvent](StructureDefinition-ServiceEvent.md), a consent for the information contained in the document to be released to a third party) is conveyed in Consent.code. Consents referenced in the CDA Header have been finalized (Consent.statusCode must equal "completed") and should be on file. |
| [Criterion (CDA Class)](StructureDefinition-Criterion.md) | Criterion (CDA Class) |
| [Custodian (CDA Class)](StructureDefinition-Custodian.md) | Represents the organization that is in charge of maintaining the document. The custodian is the steward that is entrusted with the care of the document. Every CDA document has exactly one custodian.The custodian participation satisfies the CDA definition of Stewardship (see[What is the CDA](overview.md#what-is-the-cda)). Because CDA is an exchange standard and may not represent the original form of the authenticated document, the custodian represents the steward of the original source document. |
| [CustodianOrganization (CDA Class)](StructureDefinition-CustodianOrganization.md) | The steward organization (CustodianOrganization class) is an entity scoping the role of AssignedCustodian, and has a required CustodianOrganization.id. |
| [DataEnterer (CDA Class)](StructureDefinition-DataEnterer.md) | Represents the participant who has transformed a dictated note into text. |
| [Device (CDA Class)](StructureDefinition-Device.md) | A ManufacturedMaterial used in an activity without being substantially changed through that activity.This includes durable (reusable) medical equipment as well as disposable equipment. The kind of device is identified by the code attribute inherited from Entity. |
| [DocumentationOf (CDA Class)](StructureDefinition-DocumentationOf.md) | Pointer to ServiceEvent |
| [Performer1 (CDA Class)](StructureDefinition-Performer1.md) | TODO |
| [Performer2 (CDA Class)](StructureDefinition-Performer2.md) | TODO |
| [EncompassingEncounter (CDA Class)](StructureDefinition-EncompassingEncounter.md) | This optional class represents the setting of the clinical encounter during which the documented act(s) or[ServiceEvent](StructureDefinition-ServiceEvent.md)occurred. Documents are not necessarily generated during an encounter, such as when a clinician, in response to an abnormal lab result, attempts to contact the patient but can't, and writes a Progress Note.In some cases, the setting of the encounter is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is "Diabetes Clinic Progress Note". The setting of an encounter can also be transmitted in the[HealthCareFacility](StructureDefinition-HealthCareFacility.md).code attribute. If HealthCareFacility.code is sent, it should be equivalent to or further specialize the value inherent in the ClinicalDocument.code (such as where the ClinicalDocument.code is simply "Clinic Progress Note" and the value of HealthCareFacility.code is "cardiology clinic"), and shall not conflict with the value inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation.EncompassingEncounter.dischargeDispositionCode can be used to depict the disposition of the patient at the time of hospital discharge (e.g., discharged to home, expired, against medical advice, etc.). |
| [Encounter (CDA Class)](StructureDefinition-Encounter.md) | A derivative of the RIM PatientEncounter class, used to represent related encounters, such as follow-up visits or referenced past encounters.NOTE: The[EncompassingEncounter](StructureDefinition-EncompassingEncounter.md)class in the CDA Header represents the setting of the clinical encounter during which the documented act occurred. The Encounter class in the CDA Body is used to represent other related encounters. |
| [EncounterParticipant (CDA Class)](StructureDefinition-EncounterParticipant.md) | TODO |
| [Entity (CDA Class)](StructureDefinition-Entity.md) | A physical thing, group of physical things or an organization capable of participating in Acts while in a role.An entity is a physical object that has, had or will have existence. The only exception to this is[Organization](StructureDefinition-Organization.md), which while not having a physical presence, fulfills the other characteristics of an Entity. Entity stipulates the thing itself, not the Roles it may play: the Role of Patient, e.g., is played by the[Person](StructureDefinition-Person.md)Entity.Living subjects (including human beings), organizations, materials, places and their specializations. |
| [Entry (CDA Class)](StructureDefinition-Entry.md) | CDA entries represent the structured computer-processable components within a document section. Each section can contain zero to many entries.Clinical documents contain a wide breadth of content, requiring much of the RIM to enable a full and complete encoding. The current set of CDA entries have been developed in response to identified requirements and scenarios that are in CDA's scope. Rather than creating specific entries for each scenario, similar requirements are merged to create broader entries, which can then be constrained within a particular realm or implementation. This approach is consistent with the approach taken by CEN, DICOM, and OpenEHR.The model for CDA entries is derived from the shared HL7 Clinical Statement model, which is a collaborative project between several committees striving to provide a consistent representation of clinical observations and acts across various V3 specifications. |
| [EntryRelationship (CDA Class)](StructureDefinition-EntryRelationship.md) | CDA entries represent the structured computer-processable components within a document section. Each section can contain zero to many entries. |
| [ExternalAct (CDA Class)](StructureDefinition-ExternalAct.md) | ExternalAct is a derivative of the RIM Act class, to be used when the other more specific classes are not appropriate. |
| [ExternalDocument (CDA Class)](StructureDefinition-ExternalDocument.md) | ExternalDocument is a derivative of the RIM Document class, used for representing external documents. ExternalDocument.text is modeled as an ED data type - allowing for the expression of the MIME type of the external document. |
| [ExternalObservation (CDA Class)](StructureDefinition-ExternalObservation.md) | ExternalObservation is a derivative of the RIM Observation class, used for representing external coded and other observations. |
| [ExternalProcedure (CDA Class)](StructureDefinition-ExternalProcedure.md) | ExternalProcedure is a derivative of the RIM Procedure class, used for representing external procedures. |
| [Guardian (CDA Class)](StructureDefinition-Guardian.md) | A patient's guardian is a person or organization in the role of guardian (Guardian class). The entity playing the role of guardian is a person ([Person](StructureDefinition-Person.md)class) or organization ([Organization](StructureDefinition-Organization.md)class). The entity scoping the role is the patient ([Patient](StructureDefinition-Patient.md)class).Where a guardian is not explicitly stated, the value should default to local business practice (e.g. the patient makes their own health care decisions unless incapacitated in which case healthcare decisions are made by the patient's spouse). |
| [HealthCareFacility (CDA Class)](StructureDefinition-HealthCareFacility.md) | HealthCareFacility (CDA Class) |
| [IdentifiedBy (CDA Class)](StructureDefinition-IdentifiedBy.md) | The alternateIdentification extension provides additional information about an identifier found in the linked role. The extensions augment the id information in the linked role. The id in the alternateIdentification extension SHALL match an id in the linked role. The alternateIdentification provides additional information about a particular identifier, such as its type. As an extension it needs to be safe for implementers to ignore this additional information. |
| [Informant (CDA Class)](StructureDefinition-Informant.md) | An informant (or source of information) is a person that provides relevant information, such as the parent of a comatose patient who describes the patient's behavior prior to the onset of coma. |
| [InformationRecipient (CDA Class)](StructureDefinition-InformationRecipient.md) | Represents the participant who has transformed a dictated note into text. |
| [InfrastructureRoot (Base Type for all CDA Classes)](StructureDefinition-InfrastructureRoot.md) | Defines the base elements and attributes on all CDA elements (other than data types) |
| [InFulfillmentOf (CDA Class)](StructureDefinition-InFulfillmentOf.md) | This class represents those orders that are fulfilled by this document. For instance, a provider orders an X-Ray. The X-Ray is performed. A radiologist reads the X-Ray and generates a report. The X-Ray order identifier is transmitted in the Order class, the performed X-Ray procedure is transmitted in the ServiceEvent class, and the ClinicalDocument.code would be valued with "Diagnostic Imaging Report". |
| [InFulfillmentOf1 (CDA Class)](StructureDefinition-InFulfillmentOf1.md) | This is an actRelationship called inFulfillmentOf1 that represents the Fulfills General Relationship Operator in QDM 4.1.x in QDM-Base QRDA Category 1, R3. |
| [IntendedRecipient (CDA Class)](StructureDefinition-IntendedRecipient.md) | IntendedRecipient (CDA Class) |
| [LabeledDrug (CDA Class)](StructureDefinition-LabeledDrug.md) | The LabeledDrug class, which is an Entity class playing the Role of Manufactured Product, identifies the drug that is consumed in the substance administration. The medication is identified by means of the LabeledDrug.code or the LabeledDrug.name. |
| [LanguageCommunication (CDA Class)](StructureDefinition-LanguageCommunication.md) | The language communication capabilities of an Entity.While it may seem on the surface that this class would be restricted in usage to only the LivingSubject subtypes, Devices also have the ability to communicate, such as automated telephony devices that transmit patient information to live operators on a triage line or provide automated laboratory results to clinicians.A patient who originally came from Mexico may have fluent language capabilities to speak, read and write in Spanish, and rudimentary capabilities in English. A person from Russia may have the capability to communicate equally well in spoken language in Russian, Armenian or Ukrainian, and a preference to speak in Armenian. |
| [LegalAuthenticator (CDA Class)](StructureDefinition-LegalAuthenticator.md) | Represents a participant who has legally authenticated the document. The CDA is a standard that specifies the structure of exchanged clinical documents. In the case where a local document is transformed into a CDA document for exchange, authentication occurs on the local document, and that fact is reflected in the exchanged CDA document. A CDA document can reflect the unauthenticated, authenticated, or legally authenticated state. The unauthenticated state exists when no authentication information has been recorded (i.e., it is the absence of being either authenticated or legally authenticated). While electronic signatures are not captured in a CDA document, both authentication and legal authentication require that a document has been signed manually or electronically by the responsible individual. A legalAuthenticator has a required legalAuthenticator.time indicating the time of authentication, and a required legalAuthenticator.signatureCode, indicating that a signature has been obtained and is on file. |
| [MaintainedEntity (CDA Class)](StructureDefinition-MaintainedEntity.md) | The MaintainedEntity class is present for backwards compatibility, and its use is discouraged, except where needed to support the transformation of CDA, Release One documents.NOTE: In CDA, Release One, it was possible to specify those individuals responsible for the device. This functionality has been deprecated in CDA, Release Two. |
| [ManufacturedProduct (CDA Class)](StructureDefinition-ManufacturedProduct.md) | ManufacturedProduct (CDA Class) |
| [Material (CDA Class)](StructureDefinition-Material.md) | A subtype of Entity that is inanimate and locationally independent.Materials are entities that are neither Living Subjects nor places. Manufactured or processed products are considered material, even if they originate as living matter. Materials come in a wide variety of physical forms and can pass through different states (ie. Gas, liquid, solid) while still retaining their physical composition and material characteristics.Clarify the meaning of "locationally independent"; suggest removing it and supplanting with first Usage Note sentence.Pharmaceutical substances (including active vaccines containing retarded virus), disposable supplies, durable equipment, implantable devices, food items (including meat or plant products), waste, traded goods. |
| [NonXMLBody (CDA Class)](StructureDefinition-NonXMLBody.md) | The NonXMLBody class represents a document body that is in some format other than XML. NonXMLBody.text is used to reference data that is stored externally to the CDA document or to encode the data directly inline.Rendering a referenced non-XML body requires a software tool that recognizes the particular MIME media type of the blob. |
| [Observation (CDA Class)](StructureDefinition-Observation.md) | A derivative of the RIM Observation class, used for representing coded and other observations.Observation.negationInd, when set to "true", is a positive assertion that the Observation as a whole is negated. Some properties such as Observation.id, Observation.moodCode, and the participations are not negated. These properties always have the same meaning: i.e., the author remains the author of the negative Observation. An observation statement with negationInd is still a statement about the specific fact described by the Observation. For instance, a negated "finding of wheezing on July 1" means that the author positively denies that there was wheezing on July 1, and that he takes the same responsibility for such statement and the same requirement to have evidence for such statement than if he had not used negation. |
| [ObservationMedia (CDA Class)](StructureDefinition-ObservationMedia.md) | A derivative of the RIM Observation class that represents multimedia that is logically part of the current document. This class is only for multimedia that is logically part of the attested content of the document. Rendering a referenced ObservationMedia requires a software tool that recognizes the particular MIME media type.An XML attribute "ID" of type XML ID, is added to ObservationMedia within the CDA Schema. This attribute serves as the target of a renderMultiMedia reference (see[renderMultiMedia](narrative.md#rendermultimedia)). All values of attributes of type XML ID must be unique within the document (per the W3C XML specification).The distinction between ObservationMedia and[ExternalObservation](StructureDefinition-ExternalObservation.md)is that ObservationMedia entries are part of the attested content of the document whereas ExternalObservations are not. For instance, when a clinician draws a picture as part of a progress note, that picture is represented as a CDA ObservationMedia. If that clinician is also describing a finding seen on a chest-x-ray, the referenced chest-x-ray is represented as a CDA[ExternalObservation](StructureDefinition-ExternalObservation.md). |
| [ObservationRange (CDA Class)](StructureDefinition-ObservationRange.md) | ObservationRange (CDA Class) |
| [Order (CDA Class)](StructureDefinition-Order.md) | This class represents those orders that are fulfilled by this document. For instance, a provider orders an X-Ray. The X-Ray is performed. A radiologist reads the X-Ray and generates a report. The X-Ray order identifier is transmitted in the Order class, the performed X-Ray procedure is transmitted in the ServiceEvent class, and the ClinicalDocument.code would be valued with "Diagnostic Imaging Report". |
| [Organization (CDA Class)](StructureDefinition-Organization.md) | An Entity representing a formalized group of persons or other organizations with a common purpose and the infrastructure to carry out that purpose.Companies and institutions, a government department, an incorporated body that is responsible for administering a facility, an insurance company. |
| [OrganizationPartOf (CDA Class)](StructureDefinition-OrganizationPartOf.md) | OrganizationPartOf (CDA Class) |
| [Organizer (CDA Class)](StructureDefinition-Organizer.md) | A derivative of the RIM Act class, which can be used to create arbitrary groupings of other CDA entries that share a common context. An Organizer can contain other Organizers and/or other CDA entries, by traversing the[component](StructureDefinition-Component.md)relationship. An Organizer can refer to external acts by traversing the[reference](StructureDefinition-Reference.md)relationship. An Organizer cannot be the source of an[entryRelationship](StructureDefinition-EntryRelationship.md)relationship. NOTE: CDA entries such as[Observation](StructureDefinition-Observation.md)can also contain other CDA entries by traversing the entryRelationship class. There is no requirement that the Organizer entry be used in order to group CDA entries. |
| [OrganizerComponent (CDA Class)](StructureDefinition-OrganizerComponent.md) | CDA entries represent the structured computer-processable components within a document section. Each section can contain zero to many entries. |
| [ParentDocument (CDA Class)](StructureDefinition-ParentDocument.md) | The ParentDocument represents the source of a document revision, addenda, or transformation. ParentDocument.text is modeled as an ED data type - allowing for the expression of the MIME type of the parent document. It is not to be used to embed the related document, and thus ParentDocument.text.BIN is precluded from use. |
| [Participant1 (CDA Class)](StructureDefinition-Participant1.md) | Used to represent other participants not explicitly mentioned by other classes, that were somehow involved in the documented acts. |
| [Participant2 (CDA Class)](StructureDefinition-Participant2.md) | Can be used to represent any other participant that cannot be represented with one of the more specific participants. The participant can be ascribed to a CDA entry, and propagates to nested CDA entries, unless overridden. |
| [ParticipantRole (CDA Class)](StructureDefinition-ParticipantRole.md) | ParticipantRole (CDA Class) |
| [Patient (CDA Class)](StructureDefinition-Patient.md) | A LivingSubject as a recipient of health care services from a healthcare provider. The patient is the player; the provider is the scoper. |
| [PatientRole (CDA Class)](StructureDefinition-PatientRole.md) | A recordTarget is represented as a relationship between a person and an organization, where the person is in a patient role (PatientRole class). The entity playing the role is a patient ([Patient](StructureDefinition-Patient.md)class). The entity scoping the role is an organization ([Organization](StructureDefinition-Organization.md)class). A patient is uniquely identified via the PatientRole.id attribute. |
| [Person (CDA Class)](StructureDefinition-Person.md) | A human being.This class can be used to represent either a single individual, a group of individuals or a kind of individual based on the values of Entity.determinerCode and Entity.quantity. |
| [Place (CDA Class)](StructureDefinition-Place.md) | A bounded physical place or site, including any contained structures.Place may be natural or man-made. The geographic position of a place may or may not be constant. Places may be work facilities (where relevant acts occur), homes (where people live) or offices (where people work). Places may contain sub-places (floor, room, booth, bed). Places may also be sites that are investigated in the context of health care, social work, public health administration (e.g., buildings, picnic grounds, day care centers, prisons, counties, states, and other focuses of epidemiological events).Examples: A field, lake, city, county, state, country, lot (land), building, pipeline, power line, playground, ship, truck |
| [PlayingEntity (CDA Class)](StructureDefinition-PlayingEntity.md) | PlayingEntity (CDA Class) |
| [Precondition (CDA Class)](StructureDefinition-Precondition.md) | The precondition class, derived from the ActRelationship class, is used along with the Precondition class to express a condition that must hold true before some over activity occurs. |
| [Precondition2 (CDA Class)](StructureDefinition-Precondition2.md) | The sdtc:precondition2 extension allows a more flexible set of skip conditions on a set of criteria. Without this extension the skip condition is restricted to all criteria true. The extension allows a choice of the following logical operation extensions sdtc:allTrue, sdtc:allFalse, sdtc:atLeastOneTrue, sdtc:atLeastOneFalse, sdtc:onlyOneFalse, and sdtc:onlyOneTrue to be placed upon the encapsulated criteria or a criterion. The logical operation extensions nest a [0 .. *] sdtc:precondition2 extension allowing for a complex specification of nested skip conditions if needed. |
| [PreconditionBase (CDA Class)](StructureDefinition-PreconditionBase.md) | An abstract class containing the common fields used by sdtc:allTrue, sdtc:allFalse, sdtc:atLeastOneTrue, sdtc:atLeastOneFalse, sdtc:onlyOneTrue, and sdtc:onlyOneFalse. |
| [Procedure (CDA Class)](StructureDefinition-Procedure.md) | A derivative of the RIM Procedure class, used for representing procedures.Procedure.negationInd, when set to "true", is a positive assertion that the Procedure as a whole is negated. Some properties such as Procedure.id, Procedure.moodCode, and the participations are not affected. These properties always have the same meaning: i.e., the author remains the author of the negative Procedure. A procedure statement with negationInd is still a statement about the specific fact described by the Procedure. For instance, a negated "appendectomy performed" means that the author positively denies that there was ever an appendectomy performed, and that he takes the same responsibility for such statement and the same requirement to have evidence for such statement than if he had not used negation. |
| [RecordTarget (CDA Class)](StructureDefinition-RecordTarget.md) | The recordTarget represents the medical record that this document belongs to. A clinical document typically has exactly one recordTarget participant. In the uncommon case where a clinical document (such as a group encounter note) is placed into more than one patient chart, more than one recordTarget participants can be stated. The recordTarget(s) of a document are stated in the header and propagate to nested content, where they cannot be overridden (see See[CDA Context](overview.md#cda-context)). |
| [Reference (CDA Class)](StructureDefinition-Reference.md) | CDA entries can reference external objects such as external images and prior reports. These external objects are not part of the authenticated document content. They contain sufficient attributes to enable an explicit reference rather than duplicating the entire referenced object. The CDA entry that wraps the external reference can be used to encode the specific portions of the external reference that are addressed in the narrative block.Each object allows for an identifier and a code, and contains the RIM Act.text attribute, which can be used to store the URL and MIME type of the object. External objects always have a fixed moodCode of "EVN".The reference class contains the attribute reference.seperatableInd, which indicates whether or not the source is intended to be interpreted independently of the target. The indicator cannot prevent an individual or application from separating the source and target, but indicates the author's desire and willingness to attest to the content of the source if separated from the target. Typically, where seperatableInd is "false", the exchanged package should include the target of the reference so that the recipient can render it. |
| [RegionOfInterest (CDA Class)](StructureDefinition-RegionOfInterest.md) | A derivative of the RIM Observation class that represents a region of interest on an image, using an overlay shape. RegionOfInterest is used to make reference to specific regions in images, e.g., to specify the site of a physical finding by "circling" a region in a schematic picture of a human body. The units of the coordinate values in RegionOfInterest.value are in pixels, expressed as a list of integers. The origin is in the upper left hand corner, with positive X values going to the right and positive Y values going down. The relationship between a RegionOfInterest and its referenced[ObservationMedia](StructureDefinition-ObservationMedia.md)or[ExternalObservation](StructureDefinition-ExternalObservation.md)is specified by traversing the entryRelationship or reference class, respectively, where typeCode equals "SUBJ". A RegionOfInterest must reference exactly one ObservationMedia or one ExternalObservation. If the RegionOfInterest is the target of a renderMultimedia reference, then it shall only reference an ObservationMedia and not an ExternalObservation.An XML attribute "ID" of type XML ID, is added to RegionOfInterest within the CDA Schema. This attribute serves as the target of a renderMultiMedia reference (see[renderMultiMedia](narrative.md#rendermultimedia)). All values of attributes of type XML ID must be unique within the document (per the W3C XML specification). |
| [RelatedDocument (CDA Class)](StructureDefinition-RelatedDocument.md) | **Document Identification, Revisions, and Addenda**A clinical document can be replaced by a new document and/or appended with an addendum.A replacement document is a new version of the parent document. The parent document is considered superseded, but a system may retain it for historical or auditing purposes. The parent document being replaced is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal "RPLC" (for "replaces"). An example is a report found to contain an error that is subsequently replaced by the corrected report.An addendum is a separate document that references the parent document, and may extend or alter the observations in the prior document. The parent document remains a current component of the patient record, and the addendum and its parent are both read by report recipients. The parent report (represented by the ParentDocument class) being appended is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal "APND" (for "appends").Every CDA document must have a unique ClinicalDocument.id, and thus the replacement or addendum documents each have ClinicalDocument.id that is different from that of the parent document.CDA documents may also contain a ClinicalDocument.setId and a ClinicalDocument.versionNumber, which together support a document identification and versioning scheme used in some document management systems. In this scheme, all documents in a chain of replacements have the same ClinicalDocument.setId and are distinguished by an incrementing ClinicalDocument.versionNumber. The initial version of a document gets, in addition to a new unique value for ClinicalDocument.id, a new value for ClinicalDocument.setId, and has the value of ClinicalDocument.versionNumber set to equal "1". A replacement document gets a new globally unique ClinicalDocument.id value, and uses the same value for ClinicalDocument.setId as the parent report being replaced, and increments the value of ClinicalDocument.versionNumber by 1. (Note that version number must be incremented by one when a report is replaced, but can also be incremented more often to meet local requirements.)**Document transformations**A CDA document can be a transformation from some other format, meaning that it has undergone a machine translation from some other format (such as DICOM SR). In this case, relatedDocument.typeCode should be set to "XFRM".A proper transformation must ensure that the human readable clinical content of the report is not impacted. Local business rules determine whether or not a transformed report replaces the source, but typically this would not be the case. If it is, an additional relationship of type "RPLC" is to be used. The "XFRM" relationship can also be used when translating a document in a local format into CDA for the purpose of exchange. In this case, the target of the "XFRM" relationship is the local document identifier. |
| [RelatedEntity (CDA Class)](StructureDefinition-RelatedEntity.md) | The RelatedEntity role is used to represent an informant without a role.id (e.g. a parent or guy on the street). |
| [RelatedSubject (CDA Class)](StructureDefinition-RelatedSubject.md) | A subject is a person playing one of several possible roles (RelatedSubject class). The entity playing the role is a person (SubjectPerson class). |
| [Section (CDA Class)](StructureDefinition-Section.md) | Document sections can nest, can override context propagated from the header (See[CDA Context](overview.md#cda-context)), and can contain narrative and CDA entries.An XML attribute "ID" of type XML ID, is added to Section within the CDA Schema. This attribute serves as the target of a linkHtml reference (see[linkHtml](narrative.md#linkhtml)). All values of attributes of type XML ID must be unique within the document (per the W3C XML specification).The narrative of each Section, together with the multimedia content referenced in the narrative, comprises the complete authenticated content of the Section. This multimedia content consists of[ObservationMedia](StructureDefinition-ObservationMedia.md)and[RegionOfInterest](StructureDefinition-RegionOfInterest.md)entries referenced by renderMultimedia tags in the Section.text. This is the only case where the entries contain authenticated content that must be rendered with the narrative.**'COMP' vs 'DRIV' Entries**In terms of the relationship between a section and its entries, CDA defines a default general case, and a more specific case that can be used when applicable.The entry relationship is defaulted to "COMP" (component), for the general case where the only assertion is that the related entries are contained within the source section and no other semantics are implied. In this case, the narrative is the original authenticated content. The CDA entries are created by various techniques (e.g., natural language processing, a human coder, a structured data entry tool that outputs both entries and a text report). The method of entry creation may be indicated by the entry participants (e.g., by identifying the algorithm or person that generated them). Relationships between various entries (such as two Observations or an[Observation](StructureDefinition-Observation.md)and an[ObservationMedia](StructureDefinition-ObservationMedia.md)) are encoded using the relationship types defined in[EntryRelationship](StructureDefinition-EntryRelationship.md).A section may also have no narrative content in the case where the entries represent information that is not part of the clinical content of the document. A report may embed information referencing evidence data, reagents, calibration or other information that may be used for later processing but is not part of the clinical content. Such entries are also linked to the Section with ActRelationships possessing typeCode="COMP".The entry relationship "DRIV" (is derived from) can be used in the special case where the narrative is fully derived from CDA Entries. When a report consisting entirely of structured entries is transformed into CDA, the encoding application must ensure that the authenticated content (narrative plus multimedia) is a faithful and complete rendering of the clinical content of the structured source data. This ensures that the narrative plus multimedia represents, as in all CDA documents, the complete authenticated content of the Section. In this case, narrative plus multimedia does not contain any clinical content that is not present in the Entries. An example of this case is a DICOM Structured Reporting document of obstetrical measurements made by ultrasound, rendered into a tabular report by a program converting it to CDA narrative block. If the typeCode of the ActRelationship linking these Entries to the Section was "DRIV", it would indicate to a receiving application: 1) the source of the narrative block is the Entries; 2) the contents of the two are equivalent.The entries sourced from a Section may have a mix of ActRelationship typeCodes. In such a case, the union of the targets with a "DRIV" relationship are those used to generate the narrative block, and are those that, taken in total, are equivalent to the narrative block. Additional entries with "COMP" relationships are contained within the same section, with no implied semantics. |
| [ServiceEvent (CDA Class)](StructureDefinition-ServiceEvent.md) | This class represents the main Act, such as a colonoscopy or an appendectomy, being documented.In some cases, the ServiceEvent is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is "History and Physical Report" and the procedure being documented is a "History and Physical" act. A ServiceEvent can further specialize the act inherent in the ClinicalDocument.code, such as where the ClinicalDocument.code is simply "Procedure Report" and the procedure was a "colonoscopy". If ServiceEvent is included, it must be equivalent to or further specialize the value inherent in the ClinicalDocument.code, and shall not conflict with the value inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation.ServiceEvent.effectiveTime can be used to indicate the time the actual event (as opposed to the encounter surrounding the event) took place. |
| [Specimen (CDA Class)](StructureDefinition-Specimen.md) | A specimen is a part of some entity, typically the subject, that is the target of focused laboratory, radiology or other observations. In many clinical observations, such as physical examination of a patient, the patient is the subject of the observation, and there is no specimen. The specimen participant is only used when observations are made against some substance or object that is taken or derived from the subject. |
| [SpecimenRole (CDA Class)](StructureDefinition-SpecimenRole.md) | SpecimenRole (CDA Class) |
| [StructuredBody (CDA Class)](StructureDefinition-StructuredBody.md) | The StructuredBody class represents a CDA document body that is comprised of one or more document sections.The StructuredBody class is associated with one or more[Section](StructureDefinition-Section.md)classes through a component relationship. |
| [Subject (CDA Class)](StructureDefinition-Subject.md) | The subject participant represents the primary target of the entries recorded in the document. Most of the time the subject is the same as the[recordTarget](StructureDefinition-RecordTarget.md), but need not be, for instance when the subject is a fetus observed in an obstetrical ultrasound.The subject participant can be ascribed to a CDA[section](StructureDefinition-Section.md)or a CDA[entry](StructureDefinition-Entry.md). It propagates to nested components, unless overridden. The subject of a document is presumed to be the patient. |
| [SubjectPerson (CDA Class)](StructureDefinition-SubjectPerson.md) | The entity playing the role is a person (SubjectPerson class). |
| [SubstanceAdministration (CDA Class)](StructureDefinition-SubstanceAdministration.md) | A derivative of the RIM SubstanceAdministration class, used for representing medication-related events such as medication history or planned medication administration orders.SubstanceAdministration.negationInd, when set to "true", is a positive assertion that the SubstanceAdministration as a whole is negated. Some properties such as SubstanceAdministration.id, SubstanceAdministration.moodCode, and the participations are not affected. These properties always have the same meaning: i.e., the author remains the author of the negative SubstanceAdministration. A substance administration statement with negationInd is still a statement about the specific fact described by the SubstanceAdministration. For instance, a negated "aspirin administration" means that the author positively denies that aspirin is being administered, and that he takes the same responsibility for such statement and the same requirement to have evidence for such statement than if he had not used negation.SubstanceAdministration.priorityCode categorizes the priority of a substance administration. SubstanceAdministration.doseQuantity indicates how much medication is given per dose. SubstanceAdministration.rateQuantity can be used to indicate the rate at which the dose is to be administered (e.g., the flow rate for intravenous infusions). SubstanceAdministration.maxDoseQuantity is used to capture the maximum dose of the medication that can be given over a stated time interval (e.g., maximum daily dose of morphine, maximum lifetime dose of doxorubicin). SubstanceAdministration.effectiveTime is used to describe the timing of administration. It is modeled using the GTS data type to accommodate various dosing scenarios.The capture of medication-related information also involves the interrelationship of SubstanceAdministration with several other classes. The consumable participation is used to bring in the[LabeledDrug](StructureDefinition-LabeledDrug.md)or[Material](StructureDefinition-Material.md)entity that describes the administered substance. The[LabeledDrug](StructureDefinition-LabeledDrug.md)class, which is an Entity class playing the Role of Manufactured Product, identifies the drug that is consumed in the substance administration. The medication is identified by means of the LabeledDrug.code or the LabeledDrug.name. The[Material](StructureDefinition-Material.md)entity is used to identify non-drug administered substances such as vaccines and blood products. |
| [Supply (CDA Class)](StructureDefinition-Supply.md) | A derivative of the RIM Supply class, used for representing the provision of a material by one entity to another.The dispensed product is associated with the Supply act via a product participant, which connects to the same[ManufacturedProduct](StructureDefinition-ManufacturedProduct.md)role used for[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md).The Supply class represents dispensing, whereas the SubstanceAdministration class represents administration. Prescriptions are complex activities that involve both an administration request to the patient (e.g. take digoxin 0.125mg by mouth once per day) and a supply request to the pharmacy (e.g. dispense 30 tablets, with 5 refills). This should be represented in CDA by a SubstanceAdministration entry that has a component Supply entry. The nested Supply entry can have Supply.independentInd set to "false" to signal that the Supply cannot stand alone, without it's containing SubstanceAdministration. The following example illustrates a prescription representation in CDA. |

### V3 Complex Data Types 

General-purpose complex types, which are re-usable clusters of elements

| | |
| :--- | :--- |
| [AD: PostalAddress (V3 Data Type)](StructureDefinition-AD.md) | Mailing and home or office addresses. A sequence of address parts, such as street or post office Box, city, postal code, country, etc. |
| [ADXP: CharacterString (V3 Data Type)](StructureDefinition-ADXP.md) | A character string that may have a type-tag signifying its role in the address. Typical parts that exist in about every address are street, house number, or post box, postal code, city, country but other roles may be defined regionally, nationally, or on an enterprise level (e.g. in military addresses). Addresses are usually broken up into lines, which are indicated by special line-breaking delimiter elements (e.g., DEL). |
| [ANY: DataValue (V3 Data Type)](StructureDefinition-ANY.md) | Defines the basic properties of every data value. This is an abstract type, meaning that no value can be just a data value without belonging to any concrete type. Every concrete type is a specialization of this general abstract DataValue type. |
| [BL: Boolean (V3 Data Type)](StructureDefinition-BL.md) | The Boolean type stands for the values of two-valued logic. A Boolean value can be either true or false, or, as any other value may be NULL. |
| [CD: ConceptDescriptor (V3 Data Type)](StructureDefinition-CD.md) | A concept descriptor represents any kind of concept usually by giving a code defined in a code system. A concept descriptor can contain the original text or phrase that served as the basis of the coding and one or more translations into different coding systems. A concept descriptor can also contain qualifiers to describe, e.g., the concept of a "left foot" as a postcoordinated term built from the primary code "FOOT" and the qualifier "LEFT". In cases of an exceptional value, the concept descriptor need not contain a code but only the original text describing that concept. |
| [CE: CodedWithEquivalents (V3 Data Type)](StructureDefinition-CE.md) | Coded data that consists of a coded value (CV) and, optionally, coded value(s) from other coding systems that identify the same concept. Used when alternative codes may exist. |
| [CO: CodedOrdinal (V3 Data Type)](StructureDefinition-CO.md) | Coded data, where the coding system from which the code comes is ordered |
| [CR: ConceptRole (V3 Data Type)](StructureDefinition-CR.md) | A concept qualifier code with optionally named role. Both qualifier role and value codes must be defined by the coding system of the CD containing the concept qualifier. For example, if SNOMED RT defines a concept "leg", a role relation "has-laterality", and another concept "left", the concept role relation allows to add the qualifier "has-laterality: left" to a primary code "leg" to construct the meaning "left leg". |
| [CS: CodedSimpleValue (V3 Data Type)](StructureDefinition-CS.md) | Coded data in its simplest form, where only the code is not predetermined. The code system and code system version are fixed by the context in which the CS value occurs. CS is used for coded attributes that have a single HL7-defined value set. |
| [CV: CodedValue (V3 Data Type)](StructureDefinition-CV.md) | Coded data, specifying only a code, code system, and optionally display name and original text. Used only as the data type for other data types' properties. |
| [ED: EncapsulatedData (V3 Data Type)](StructureDefinition-ED.md) | Data that is primarily intended for human interpretation or for further machine processing outside the scope of HL7. This includes unformatted or formatted written language, multimedia data, or structured information in as defined by a different standard (e.g., XML-signatures.) Instead of the data itself, an may contain only a reference (see[TEL](StructureDefinition-TEL.md).) Note that the data type is a specialization of the data type when the media type is text/plain. |
| [EIVL_TS: EventRelatedPeriodicInterval (V3 Data Type)](StructureDefinition-EIVL-TS.md) | Specifies a periodic interval of time where the recurrence is based on activities of daily living or other important events that are time-related but not fully determined by time. |
| [EN: EntityName (V3 Data Type)](StructureDefinition-EN.md) | A name for a person, organization, place or thing. A sequence of name parts, such as given name or family name, prefix, suffix, etc. Examples for entity name values are "Jim Bob Walton, Jr.", "Health Level Seven, Inc.", "Lake Tahoe", etc. An entity name may be as simple as a character string or may consist of several entity name parts, such as, "Jim", "Bob", "Walton", and "Jr.", "Health Level Seven" and "Inc.", "Lake" and "Tahoe". |
| [ENXP: Entity Name Part (V3 Data Type)](StructureDefinition-ENXP.md) | A character string token representing a part of a name. May have a type code signifying the role of the part in the whole entity name, and a qualifier code for more detail about the name part type. Typical name parts for person names are given names, and family names, titles, etc. |
| [II: InstanceIdentifier (V3 Data Type)](StructureDefinition-II.md) | An identifier that uniquely identifies a thing or object. Examples are object identifier for HL7 RIM objects, medical record number, order id, service catalog item id, Vehicle Identification Number (VIN), etc. Instance identifiers are defined based on ISO object identifiers. |
| [INT: IntegerNumber (V3 Data Type)](StructureDefinition-INT.md) | Integer numbers (-1,0,1,2, 100, 3398129, etc.) are precise numbers that are results of counting and enumerating. Integer numbers are discrete, the set of integers is infinite but countable. No arbitrary limit is imposed on the range of integer numbers. Two NULL flavors are defined for the positive and negative infinity. |
| [INT_POS: Positive integer numbers (V3 Data Type)](StructureDefinition-INT-POS.md) | Positive integer numbers. |
| [IVL_INT: Interval (V3 Data Type)](StructureDefinition-IVL-INT.md) | A set of consecutive values of an ordered base data type. |
| [IVL_PQ: Interval (V3 Data Type)](StructureDefinition-IVL-PQ.md) | A set of consecutive values of an ordered base data type. |
| [IVL_TS: Interval (V3 Data Type)](StructureDefinition-IVL-TS.md) | A set of consecutive values of an ordered base data type. |
| [IVXB_INT: Interval Boundary IntegerNumber (V3 Data Type)](StructureDefinition-IVXB-INT.md) | An integer interval boundary containing an inclusive/exclusive flag. |
| [IVXB_PQ: Interval Boundary PhysicalQuantity (V3 Data Type)](StructureDefinition-IVXB-PQ.md) | A physical quantity interval boundary containing an inclusive/exclusive flag. |
| [IVXB_TS: Interval Boundary PointInTime (V3 Data Type)](StructureDefinition-IVXB-TS.md) | A timestamp interval boundary containing an inclusive/exclusive flag. |
| [MO: MonetaryAmount (V3 Data Type)](StructureDefinition-MO.md) | A monetary amount is a quantity expressing the amount of money in some currency. Currencies are the units in which monetary amounts are denominated in different economic regions. While the monetary amount is a single kind of quantity (money) the exchange rates between the different units are variable. This is the principle difference between physical quantity and monetary amounts, and the reason why currency units are not physical units. |
| [ON: OrganizationName (V3 Data Type)](StructureDefinition-ON.md) | A name for an organization. A sequence of name parts. Examples for organization name values are "Health Level Seven, Inc.", "Hospital", etc. An organization name may be as simple as a character string or may consist of several person name parts, such as, "Health Level 7", "Inc.". ON differs from EN because certain person related name parts are not possible. |
| [PIVL_TS: PeriodicIntervalOfTime (V3 Data Type)](StructureDefinition-PIVL-TS.md) | An interval of time that recurs periodically. Periodic intervals have two properties, phase and period. The phase specifies the "interval prototype" that is repeated every period. |
| [PN: PersonName (V3 Data Type)](StructureDefinition-PN.md) | A name for a person. A sequence of name parts, such as given name or family name, prefix, suffix, etc. Examples for person name values are "Jim Bob Walton, Jr.", "Adam Everyman", etc. A person name may be as simple as a character string or may consist of several person name parts, such as, "Jim", "Bob", "Walton", and "Jr.". PN differs from EN because the qualifier type cannot include LS (Legal Status). |
| [PQ: PhysicalQuantity (V3 Data Type)](StructureDefinition-PQ.md) | A dimensioned quantity expressing the result of measuring. |
| [PQR: PhysicalQuantityRepresentation (V3 Data Type)](StructureDefinition-PQR.md) | An extension of the coded value data type representating a physical quantity using a unit from any code system. Used to show alternative representation for a physical quantity. |
| [QTY: Quantity (V3 Data Type)](StructureDefinition-QTY.md) | The quantity data type is an abstract generalization for all data types (1) whose value set has an order relation (less-or-equal) and (2) where difference is defined in all of the data type's totally ordered value subsets. The quantity type abstraction is needed in defining certain other types, such as the interval and the probability distribution. |
| [REAL: RealNumber (V3 Data Type)](StructureDefinition-REAL.md) | Fractional numbers. Typically used whenever quantities are measured, estimated, or computed from other real numbers. The typical representation is decimal, where the number of significant decimal digits is known as the precision. |
| [RTO_PQ_PQ: Ratio (V3 Data Type)](StructureDefinition-RTO-PQ-PQ.md) | A quantity constructed as the quotient of a numerator quantity divided by a denominator quantity. Common factors in the numerator and denominator are not automatically cancelled out. The data type supports titers (e.g., "1:128") and other quantities produced by laboratories that truly represent ratios. Ratios are not simply "structured numerics", particularly blood pressure measurements (e.g. "120/60") are not ratios. In many cases the should be used instead of the . |
| [SC: CharacterStringWithCode (V3 Data Type)](StructureDefinition-SC.md) | A character string that optionally may have a code attached. The text must always be present if a code is present. The code is often a local code. |
| [ST: CharacterString (V3 Data Type)](StructureDefinition-ST.md) | The character string data type stands for text data, primarily intended for machine processing (e.g., sorting, querying, indexing, etc.) Used for names, symbols, and formal expressions. |
| [SXCM_TS: GeneralTimingSpecification (V3 Data Type)](StructureDefinition-SXCM-TS.md) | A set of points in time, specifying the timing of events and actions and the cyclical validity-patterns that may exist for certain kinds of information, such as phone numbers (evening, daytime), addresses (so called "snowbirds," residing closer to the equator during winter and farther from the equator during summer) and office hours. |
| [SXPR_TS: Component part of GTS (V3 Data Type)](StructureDefinition-SXPR-TS.md) | A set-component that is itself made up of set-components that are evaluated as one value |
| [TEL: TelecommunicationAddress (V3 Data Type)](StructureDefinition-TEL.md) | A telephone number (voice or fax), e-mail address, or other locator for a resource mediated by telecommunication equipment. The address is specified as a Universal Resource Locator (URL) qualified by time specification and use codes that help in deciding which address to use for a given time and purpose. |
| [TN: TrivialName (V3 Data Type)](StructureDefinition-TN.md) | A restriction of entity name that is effectively a simple string used for a simple name for things and places. |
| [TS: PointInTime (V3 Data Type)](StructureDefinition-TS.md) | A quantity specifying a point on the axis of natural time. A point in time is most often represented as a calendar expression. |

### V3 Simple Data Types 

Simple / primitive types, which are single XML attributes

| | |
| :--- | :--- |
| [bin: Binary Data](StructureDefinition-bin.md) | Binary data is a raw block of bits. Binary data is a protected type that MUST not be used outside the data type specification. |
| [bl: Boolean](StructureDefinition-bl-simple.md) | The Boolean type stands for the values of two-valued logic. A Boolean value can be either true or false. |
| [bn: BooleanNonNull](StructureDefinition-bn.md) | The BooleanNonNull type is used where a Boolean cannot have a null value. A Boolean value can be either true or false. |
| [cs: Coded Simple Value](StructureDefinition-cs-simple.md) | Coded data in its simplest form, consists of a code. The code system and code system version is fixed by the context in which the value occurs. 'cs' is used for coded attributes that have a single HL7-defined value set. |
| [int: Integer Number](StructureDefinition-int-simple.md) | Integer numbers (-1,0,1,2, 100, 3398129, etc.) are precise numbers that are results of counting and enumerating. Integer numbers are discrete, the set of integers is infinite but countable. No arbitrary limit is imposed on the range of integer numbers. Two NULL flavors are defined for the positive and negative infinity. |
| [oid: ISO Object Identifier](StructureDefinition-oid.md) | A globally unique string representing an ISO Object Identifier (OID) in a form that consists only of numbers and dots (e.g., '2.16.840.1.113883.3.1'). |
| [probability: Probability](StructureDefinition-probability.md) | The probability assigned to the value, a decimal number between 0 (very uncertain) and 1 (certain). |
| [real: Real Number](StructureDefinition-real-simple.md) | Fractional numbers. Typically used whenever quantities are measured, estimated, or computed from other real numbers. The typical representation is decimal, where the number of significant decimal digits is known as the precision. Real numbers are needed beyond integers whenever quantities of the real world are measured, estimated, or computed from other real numbers. The term "Real number" in this specification is used to mean that fractional values are covered without necessarily implying the full set of the mathematical real numbers. |
| [ruid: HL7 Reserved Identifier Scheme](StructureDefinition-ruid.md) | HL7 Reserved Identifier Scheme (RUID)\nA globally unique string defined exclusively by HL7. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations.HL7 reserved identifiers are strings that consist only of (US-ASCII) letters, digits and hyphens, where the first character must be a letter. HL7 may assign these reserved identifiers as mnemonic identifiers for major concepts of interest to HL7. |
| [st: Character String](StructureDefinition-st-simple.md) | The character string data type stands for text data, primarily intended for machine processing (e.g. sorting, querying, indexing, etc.) Used for names, symbols, and formal expressions. |
| [ts: Point in Time](StructureDefinition-ts-simple.md) | A quantity specifying a point on the axis of natural time. A point in time is most often represented as a calendar expression. |
| [uid: Unique Identifier String](StructureDefinition-uid.md) | A unique identifier string is a character string which identifies an object in a globally unique and timeless manner. The allowable formats and values and procedures of this data type are strictly controlled by HL7. At this time, user-assigned identifiers may be certain character representations of ISO Object Identifiers (OID) and DCE Universally Unique Identifiers (UUID). HL7 also reserves the right to assign other forms of UIDs (RUID), such as mnemonic identifiers for code systems. |
| [url: Universal Resource Locator](StructureDefinition-url.md) | A telecommunications address specified according to Internet standard RFC 1738 [http://www.ietf.org/rfc/rfc1738.txt]. The URL specifies the protocol and the contact point defined by that protocol for the resource. Notable uses of the telecommunication address data type are for telephone and telefax numbers, e-mail addresses, Hypertext references, FTP references, etc. |
| [uuid: DCE Universal Unique Identifier](StructureDefinition-uuid.md) | A globally unique string representing a DCE Universal Unique Identifier (UUID) in the common UUID format that consists of 5 hyphen-separated groups of hexadecimal digits having 8, 4, 4, 4, and 12 places respectively.****NOTE:****The output of UUID related programs and functions may use all sorts of forms, upper case, lower case, and with or without the hyphens that group the digits. This variate output must be postprocessed to conform to the HL7 specification, i.e., the hyphens must be inserted for the 8-4-4-4-12 grouping. Historically, CDA also required that all hexadecimal digits must be converted to upper case, but due to real-world issues encountered when enforcing this rule, it has been relaxed to allow for upper or lower case letters. Additionally, FHIR requires that UUID's be communicated using only lower case letters, so for broader compatibility, implementers are encouraged to use lower case letters. |

### XML Data Types 

Other, non-CDA, data types used to support exchange of CDA documents

| | |
| :--- | :--- |
| [xs:ID](StructureDefinition-xs-ID.md) | ID represents the ID attribute type from [XML 1.0 (Second Edition)]. The "value space" of ID is the set of all strings that "match" the NCName production in [Namespaces in XML]. The "lexical space" of ID is the set of all strings that "match" the NCName production in [Namespaces in XML]. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CDAActClass](ValueSet-CDAActClass.md) | A code specifying the major type of Act that this Act-instance represents. |
| [CDAActClassObservation](ValueSet-CDAActClassObservation.md) | An act that is intended to result in new information about a subject. The main difference between Observations and other Acts is that Observations have a value attribute. |
| [CDAActMood](ValueSet-CDAActMood.md) | A code distinguishing whether an Act is conceived of as a factual statement or in some other manner as a command, possibility, goal, etc. |
| [CDAActMoodIntent](ValueSet-CDAActMoodIntent.md) | An intention or plan to perform a service. |
| [CDAActRelationshipType](ValueSet-CDAActRelationshipType.md) | A code specifying the meaning and purpose of every ActRelationship instance. Each of its values implies specific constraints to what kinds of Act objects can be related and in which way. |
| [CDAActSubstanceAdministrationCode](ValueSet-CDAActSubstanceAdministrationCode.md) | Describes the type of substance administration being performed. |
| [CDABinaryDataEncoding](ValueSet-BinaryDataEncoding.md) | Identifies the representation of binary data in a text field |
| [CDACompressionAlgorithm](ValueSet-CDACompressionAlgorithm.md) | Type of compression algorithm used - limited to 4 concepts from original CDA definition |
| [CDAContextControl](ValueSet-CDAContextControl.md) | A code that specifies how an ActRelationship or Participation contributes to the context of an Act, and whether it may be propagated to descendent Acts whose association allows such propagation. |
| [CDAEntityCode](ValueSet-CDAEntityCode.md) | A value representing the specific kind of Entity the instance represents. |
| [CDAEntityNamePartQualifier](ValueSet-CDAEntityNamePartQualifier.md) | Qualifies parts of names |
| [CDAEntityNameUse](ValueSet-CDAEntityNameUse.md) | A set of codes advising a system or user which name in a set of names to select for a given purpose - limited to values allowed in original CDA definition |
| [CDAInformationRecipientRole](ValueSet-CDAInformationRecipientRole.md) | Used to represent the role(s) of those who should receive a copy of a document - limited to values allowed in original CDA definition |
| [CDAMaterialEntityClassType](ValueSet-CDAMaterialEntityClassType.md) | Types of Material for EntityClass “MAT” |
| [CDANullFlavor](ValueSet-CDANullFlavor.md) | CDA NullFlavors - limited to values allowed in original CDA definition |
| [CDAObservationInterpretation](ValueSet-CDAObservationInterpretation.md) | One or more codes providing a rough qualitative interpretation of the observation - limited to values available in original CDA |
| [CDAParticipationType](ValueSet-CDAParticipationType.md) | A code specifying the meaning and purpose of every Participation instance. Each of its values implies specific constraints on the Roles undertaking the participation. Limited to values allowed in original CDA definition |
| [CDAPostalAddressUse](ValueSet-CDAPostalAddressUse.md) | A set of codes advising a system or user which address in a set of like addresses to select for a given purpose - limited to values allowed in original CDA definition |
| [CDARoleClass](ValueSet-CDARoleClass.md) | Represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role. |
| [CDARoleClassAssociative](ValueSet-CDARoleClassAssociative.md) | A general association between two entities that is neither partitive nor ontological. |
| [CDARoleClassMutualRelationship](ValueSet-CDARoleClassMutualRelationship.md) | A relationship that is based on mutual behavior of the two Entities as being related. The basis of such relationship may be agreements (e.g., spouses, contract parties) or they may be de facto behavior (e.g. friends) or may be an incidental involvement with each other (e.g. parties over a dispute, siblings, children). |
| [CDARoleClassRoot](ValueSet-CDARoleClassRoot.md) | Corresponds to the Role class |
| [CDARoleCode](ValueSet-CDARoleCode.md) | A set of codes further specifying the kind of Role; specific classification codes for further qualifying RoleClass codes. |
| [CDASetOperator](ValueSet-CDASetOperator.md) | Determins the intersectionality of multiple sets |
| [CDASignatureCode](ValueSet-CDASignatureCode.md) | A set of codes specifying whether and how the participant has attested his participation through a signature - limited to values allowed in original CDA definition.**Note:**CDA Release One represented either an intended (`X`) or actual (`S`) authenticator. CDA Release Two only represents an actual authenticator, so has deprecated the value of`X`. |
| [CDATimingEvent](ValueSet-CDATimingEvent.md) | A set of codes for common (periodical) activity of daily living - limited to values allowed in original CDA definition |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Binary Data Encoding Code System](CodeSystem-BinaryDataEncoding.md) | Identifies the representation of binary data in a text field |
| [IG Parameters CDA Validation](CodeSystem-IGParametersCDAValidation.md) | Code system for CDA validation parameters in the IG. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Example CDA document](Binary-clinicaldocument-example.md) | Example CDA document from original CDA release |

