# RelatedDocument (CDA Class) - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RelatedDocument (CDA Class)**

## Logical Model: RelatedDocument (CDA Class) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/stds/core/StructureDefinition/RelatedDocument | *Version*:2.0.2-sd |
| Active as of 2025-12-11 | *Computable Name*:RelatedDocument |

 
**Document Identification, Revisions, and Addenda** 
A clinical document can be replaced by a new document and/or appended with an addendum. 
A replacement document is a new version of the parent document. The parent document is considered superseded, but a system may retain it for historical or auditing purposes. The parent document being replaced is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal "RPLC" (for "replaces"). An example is a report found to contain an error that is subsequently replaced by the corrected report. 
An addendum is a separate document that references the parent document, and may extend or alter the observations in the prior document. The parent document remains a current component of the patient record, and the addendum and its parent are both read by report recipients. The parent report (represented by the ParentDocument class) being appended is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal "APND" (for "appends"). 
Every CDA document must have a unique ClinicalDocument.id, and thus the replacement or addendum documents each have ClinicalDocument.id that is different from that of the parent document. 
CDA documents may also contain a ClinicalDocument.setId and a ClinicalDocument.versionNumber, which together support a document identification and versioning scheme used in some document management systems. In this scheme, all documents in a chain of replacements have the same ClinicalDocument.setId and are distinguished by an incrementing ClinicalDocument.versionNumber. The initial version of a document gets, in addition to a new unique value for ClinicalDocument.id, a new value for ClinicalDocument.setId, and has the value of ClinicalDocument.versionNumber set to equal "1". A replacement document gets a new globally unique ClinicalDocument.id value, and uses the same value for ClinicalDocument.setId as the parent report being replaced, and increments the value of ClinicalDocument.versionNumber by 1. (Note that version number must be incremented by one when a report is replaced, but can also be incremented more often to meet local requirements.) 
**Document transformations** 
A CDA document can be a transformation from some other format, meaning that it has undergone a machine translation from some other format (such as DICOM SR). In this case, relatedDocument.typeCode should be set to "XFRM". 
A proper transformation must ensure that the human readable clinical content of the report is not impacted. Local business rules determine whether or not a transformed report replaces the source, but typically this would not be the case. If it is, an additional relationship of type "RPLC" is to be used. The "XFRM" relationship can also be used when translating a document in a local format into CDA for the purpose of exchange. In this case, the target of the "XFRM" relationship is the local document identifier. 

**Usages:**

* Use this Logical Model: [ClinicalDocument (CDA Class)](StructureDefinition-ClinicalDocument.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.uv.core|current/StructureDefinition/RelatedDocument)

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-RelatedDocument.csv), [Excel](StructureDefinition-RelatedDocument.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RelatedDocument",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "relatedDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/stds/core/StructureDefinition/RelatedDocument",
  "version" : "2.0.2-sd",
  "name" : "RelatedDocument",
  "title" : "RelatedDocument (CDA Class)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T16:59:04+00:00",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        },
        {
          "system" : "email",
          "value" : "structdog@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "**Document Identification, Revisions, and Addenda**\n\nA clinical document can be replaced by a new document and/or appended with an addendum.\n\nA replacement document is a new version of the parent document. The parent document is considered superseded, but a system may retain it for historical or auditing purposes. The parent document being replaced is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal \"RPLC\" (for \"replaces\"). An example is a report found to contain an error that is subsequently replaced by the corrected report.\n\nAn addendum is a separate document that references the parent document, and may extend or alter the observations in the prior document. The parent document remains a current component of the patient record, and the addendum and its parent are both read by report recipients. The parent report (represented by the ParentDocument class) being appended is referenced via act relationship relatedDocument, where relatedDocument.typeCode is set to equal \"APND\" (for \"appends\").\n\nEvery CDA document must have a unique ClinicalDocument.id, and thus the replacement or addendum documents each have ClinicalDocument.id that is different from that of the parent document.\n\nCDA documents may also contain a ClinicalDocument.setId and a ClinicalDocument.versionNumber, which together support a document identification and versioning scheme used in some document management systems. In this scheme, all documents in a chain of replacements have the same ClinicalDocument.setId and are distinguished by an incrementing ClinicalDocument.versionNumber. The initial version of a document gets, in addition to a new unique value for ClinicalDocument.id, a new value for ClinicalDocument.setId, and has the value of ClinicalDocument.versionNumber set to equal \"1\". A replacement document gets a new globally unique ClinicalDocument.id value, and uses the same value for ClinicalDocument.setId as the parent report being replaced, and increments the value of ClinicalDocument.versionNumber by 1. (Note that version number must be incremented by one when a report is replaced, but can also be incremented more often to meet local requirements.)\n\n**Document transformations**\n\nA CDA document can be a transformation from some other format, meaning that it has undergone a machine translation from some other format (such as DICOM SR). In this case, relatedDocument.typeCode should be set to \"XFRM\".\n\nA proper transformation must ensure that the human readable clinical content of the report is not impacted. Local business rules determine whether or not a transformed report replaces the source, but typically this would not be the case. If it is, an additional relationship of type \"RPLC\" is to be used. The \"XFRM\" relationship can also be used when translating a document in a local format into CDA for the purpose of exchange. In this case, the target of the \"XFRM\" relationship is the local document identifier.\n\n",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/RelatedDocument",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/InfrastructureRoot",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedDocument",
        "path" : "RelatedDocument",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "RelatedDocument.typeCode",
        "path" : "RelatedDocument.typeCode",
        "representation" : ["xmlAttr"],
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-xActRelationshipDocument"
        }
      },
      {
        "id" : "RelatedDocument.parentDocument",
        "path" : "RelatedDocument.parentDocument",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParentDocument"
          }
        ]
      }
    ]
  }
}

```
