# Terminology - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

This page lists all the ValueSets and CodeSystems used by CDA

### Value Sets

These value sets are used in this implementation guide:

Value Set Sources:

* [FHIR](http://hl7.org/fhir/R5/)
* [THO](http://terminology.hl7.org/)

| | | | |
| :--- | :--- | :--- | :--- |
| 1 | [ActClassClinicalDocument](http://terminology.hl7.org/ValueSet/v3-ActClassClinicalDocument) | [ParentDocument](StructureDefinition-ParentDocument.md) | THO |
| 2 | [ActClassDocument](http://terminology.hl7.org/ValueSet/v3-ActClassDocument) | [ExternalDocument](StructureDefinition-ExternalDocument.md) | THO |
| 3 | [ActClassProcedure](http://terminology.hl7.org/ValueSet/v3-ActClassProcedure) | [Procedure](StructureDefinition-Procedure.md),[ExternalProcedure](StructureDefinition-ExternalProcedure.md) | THO |
| 4 | [ActClassROI](http://terminology.hl7.org/ValueSet/v3-ActClassROI) | [RegionOfInterest](StructureDefinition-RegionOfInterest.md) | THO |
| 5 | [ActClassRecordOrganizer](http://terminology.hl7.org/ValueSet/v3-ActClassRecordOrganizer) | [Section](StructureDefinition-Section.md),[NonXMLBody](StructureDefinition-NonXMLBody.md),[StructuredBody](StructureDefinition-StructuredBody.md) | THO |
| 6 | [ActClassSupply](http://terminology.hl7.org/ValueSet/v3-ActClassSupply) | [Supply](StructureDefinition-Supply.md) | THO |
| 7 | [ActEncounterCode](http://terminology.hl7.org/ValueSet/v3-ActEncounterCode) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[Encounter](StructureDefinition-Encounter.md) | THO |
| 8 | [ActMoodPredicate](http://terminology.hl7.org/ValueSet/v3-ActMoodPredicate) | [Criterion](StructureDefinition-Criterion.md),[ObservationRange](StructureDefinition-ObservationRange.md) | THO |
| 9 | [ActPriority](http://terminology.hl7.org/ValueSet/v3-ActPriority) | [Procedure](StructureDefinition-Procedure.md),[Observation](StructureDefinition-Observation.md),[Encounter](StructureDefinition-Encounter.md),[Order](StructureDefinition-Order.md),[Act](StructureDefinition-Act.md),[Supply](StructureDefinition-Supply.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 10 | [ActRelationshipFulfills](http://terminology.hl7.org/ValueSet/v3-ActRelationshipFulfills) | [InFulfillmentOf](StructureDefinition-InFulfillmentOf.md),[InFulfillmentOf1](StructureDefinition-InFulfillmentOf1.md) | THO |
| 11 | [ActRelationshipHasComponent](http://terminology.hl7.org/ValueSet/v3-ActRelationshipHasComponent) | [Component](StructureDefinition-Component.md),[OrganizerComponent](StructureDefinition-OrganizerComponent.md),[ComponentOf](StructureDefinition-ComponentOf.md) | THO |
| 12 | [ActStatus](http://terminology.hl7.org/ValueSet/v3-ActStatus) | [Procedure](StructureDefinition-Procedure.md),[Observation](StructureDefinition-Observation.md),[Encounter](StructureDefinition-Encounter.md),[Consent](StructureDefinition-Consent.md),[Act](StructureDefinition-Act.md),[AlternateIdentification](StructureDefinition-AlternateIdentification.md),[Organizer](StructureDefinition-Organizer.md),[Supply](StructureDefinition-Supply.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 13 | [AdministrableDrugForm](http://terminology.hl7.org/ValueSet/v3-AdministrableDrugForm) | [SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 14 | [AdministrativeGender](http://terminology.hl7.org/ValueSet/v3-AdministrativeGender) | [Patient](StructureDefinition-Patient.md),[SubjectPerson](StructureDefinition-SubjectPerson.md) | THO |
| 15 | [All Languages](http://hl7.org/fhir/R5/valueset-all-languages.html) | [ObservationMedia](StructureDefinition-ObservationMedia.md),[Procedure](StructureDefinition-Procedure.md),[Observation](StructureDefinition-Observation.md),[LanguageCommunication](StructureDefinition-LanguageCommunication.md),[Act](StructureDefinition-Act.md),[Section](StructureDefinition-Section.md),[NonXMLBody](StructureDefinition-NonXMLBody.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md),[StructuredBody](StructureDefinition-StructuredBody.md) | FHIR |
| 16 | [CDAActClass](ValueSet-CDAActClass.md) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[Encounter](StructureDefinition-Encounter.md),[ExternalAct](StructureDefinition-ExternalAct.md),[Consent](StructureDefinition-Consent.md),[Order](StructureDefinition-Order.md),[ServiceEvent](StructureDefinition-ServiceEvent.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | CDA |
| 17 | [CDAActClassObservation](ValueSet-CDAActClassObservation.md) | [ObservationMedia](StructureDefinition-ObservationMedia.md),[Observation](StructureDefinition-Observation.md),[ExternalObservation](StructureDefinition-ExternalObservation.md),[Criterion](StructureDefinition-Criterion.md),[ObservationRange](StructureDefinition-ObservationRange.md) | CDA |
| 18 | [CDAActMood](ValueSet-CDAActMood.md) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[ExternalObservation](StructureDefinition-ExternalObservation.md),[Consent](StructureDefinition-Consent.md),[ParentDocument](StructureDefinition-ParentDocument.md),[NonXMLBody](StructureDefinition-NonXMLBody.md),[StructuredBody](StructureDefinition-StructuredBody.md),[ObservationMedia](StructureDefinition-ObservationMedia.md),[ExternalProcedure](StructureDefinition-ExternalProcedure.md),[ExternalAct](StructureDefinition-ExternalAct.md),[Section](StructureDefinition-Section.md),[RegionOfInterest](StructureDefinition-RegionOfInterest.md),[ServiceEvent](StructureDefinition-ServiceEvent.md),[ExternalDocument](StructureDefinition-ExternalDocument.md),[Organizer](StructureDefinition-Organizer.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md) | CDA |
| 19 | [CDAActMoodIntent](ValueSet-CDAActMoodIntent.md) | [Order](StructureDefinition-Order.md) | CDA |
| 20 | [CDAActRelationshipType](ValueSet-CDAActRelationshipType.md) | [Observation](StructureDefinition-Observation.md),[Precondition](StructureDefinition-Precondition.md),[DocumentationOf](StructureDefinition-DocumentationOf.md),[ObservationRange](StructureDefinition-ObservationRange.md),[Precondition2](StructureDefinition-Precondition2.md) | CDA |
| 21 | [CDAActSubstanceAdministrationCode](ValueSet-CDAActSubstanceAdministrationCode.md) | [SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | CDA |
| 22 | [CDABinaryDataEncoding](ValueSet-BinaryDataEncoding.md) | [ED](StructureDefinition-ED.md) | CDA |
| 23 | [CDACompressionAlgorithm](ValueSet-CDACompressionAlgorithm.md) | [ED](StructureDefinition-ED.md) | CDA |
| 24 | [CDAContextControl](ValueSet-CDAContextControl.md) | [Informant](StructureDefinition-Informant.md),[Subject](StructureDefinition-Subject.md),[Participant2](StructureDefinition-Participant2.md),[Participant1](StructureDefinition-Participant1.md),[Author](StructureDefinition-Author.md),[RecordTarget](StructureDefinition-RecordTarget.md),[LegalAuthenticator](StructureDefinition-LegalAuthenticator.md),[DataEnterer](StructureDefinition-DataEnterer.md) | CDA |
| 25 | [CDAEntityCode](ValueSet-CDAEntityCode.md) | [Device](StructureDefinition-Device.md),[Entity](StructureDefinition-Entity.md),[PlayingEntity](StructureDefinition-PlayingEntity.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md) | CDA |
| 26 | [CDAEntityNamePartQualifier](ValueSet-CDAEntityNamePartQualifier.md) | [ENXP](StructureDefinition-ENXP.md) | CDA |
| 27 | [CDAEntityNameUse](ValueSet-CDAEntityNameUse.md) | [EN](StructureDefinition-EN.md),[TN](StructureDefinition-TN.md),[PN](StructureDefinition-PN.md),[ON](StructureDefinition-ON.md) | CDA |
| 28 | [CDAInformationRecipientRole](ValueSet-CDAInformationRecipientRole.md) | [IntendedRecipient](StructureDefinition-IntendedRecipient.md) | CDA |
| 29 | [CDAMaterialEntityClassType](ValueSet-CDAMaterialEntityClassType.md) | [Material](StructureDefinition-Material.md),[CDAEntityCode](ValueSet-CDAEntityCode.md) | CDA |
| 30 | [CDANullFlavor](ValueSet-CDANullFlavor.md) | [AssignedEntity](StructureDefinition-AssignedEntity.md),[Device](StructureDefinition-Device.md),[ParentDocument](StructureDefinition-ParentDocument.md),[InformationRecipient](StructureDefinition-InformationRecipient.md),[Participant2](StructureDefinition-Participant2.md),[Participant1](StructureDefinition-Participant1.md),[SpecimenRole](StructureDefinition-SpecimenRole.md),[IVXB-TS](StructureDefinition-IVXB-TS.md),[PatientRole](StructureDefinition-PatientRole.md),[HealthCareFacility](StructureDefinition-HealthCareFacility.md),[StructuredBody](StructureDefinition-StructuredBody.md),[SXCM-TS](StructureDefinition-SXCM-TS.md),[LanguageCommunication](StructureDefinition-LanguageCommunication.md),[Patient](StructureDefinition-Patient.md),[INT-POS](StructureDefinition-INT-POS.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md),[ON](StructureDefinition-ON.md),[DocumentationOf](StructureDefinition-DocumentationOf.md),[Custodian](StructureDefinition-Custodian.md),[Authenticator](StructureDefinition-Authenticator.md),[Supply](StructureDefinition-Supply.md),[DataEnterer](StructureDefinition-DataEnterer.md),[Procedure](StructureDefinition-Procedure.md),[PreconditionBase](StructureDefinition-PreconditionBase.md),[ADXP](StructureDefinition-ADXP.md),[PN](StructureDefinition-PN.md),[PQ](StructureDefinition-PQ.md),[ENXP](StructureDefinition-ENXP.md),[Organizer](StructureDefinition-Organizer.md),[Specimen](StructureDefinition-Specimen.md),[Precondition](StructureDefinition-Precondition.md),[Consent](StructureDefinition-Consent.md),[PlayingEntity](StructureDefinition-PlayingEntity.md),[RelatedSubject](StructureDefinition-RelatedSubject.md),[IVL-TS](StructureDefinition-IVL-TS.md),[Authorization](StructureDefinition-Authorization.md),[Act](StructureDefinition-Act.md),[PQR](StructureDefinition-PQR.md),[II](StructureDefinition-II.md),[AD](StructureDefinition-AD.md),[OrganizerComponent](StructureDefinition-OrganizerComponent.md),[Informant](StructureDefinition-Informant.md),[BL](StructureDefinition-BL.md),[InFulfillmentOf](StructureDefinition-InFulfillmentOf.md),[InFulfillmentOf1](StructureDefinition-InFulfillmentOf1.md),[AssignedAuthor](StructureDefinition-AssignedAuthor.md),[SC](StructureDefinition-SC.md),[NonXMLBody](StructureDefinition-NonXMLBody.md),[LegalAuthenticator](StructureDefinition-LegalAuthenticator.md),[ComponentOf](StructureDefinition-ComponentOf.md),[ObservationMedia](StructureDefinition-ObservationMedia.md),[ExternalProcedure](StructureDefinition-ExternalProcedure.md),[ExternalAct](StructureDefinition-ExternalAct.md),[Material](StructureDefinition-Material.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md),[RelatedDocument](StructureDefinition-RelatedDocument.md),[EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[EntryRelationship](StructureDefinition-EntryRelationship.md),[ExternalObservation](StructureDefinition-ExternalObservation.md),[CO](StructureDefinition-CO.md),[EIVL-TS](StructureDefinition-EIVL-TS.md),[Author](StructureDefinition-Author.md),[CR](StructureDefinition-CR.md),[Person](StructureDefinition-Person.md),[CS](StructureDefinition-CS.md),[CustodianOrganization](StructureDefinition-CustodianOrganization.md),[CV](StructureDefinition-CV.md),[Organization](StructureDefinition-Organization.md),[IVXB-PQ](StructureDefinition-IVXB-PQ.md),[AssignedCustodian](StructureDefinition-AssignedCustodian.md),[ST](StructureDefinition-ST.md),[RegionOfInterest](StructureDefinition-RegionOfInterest.md),[CD](StructureDefinition-CD.md),[ServiceEvent](StructureDefinition-ServiceEvent.md),[CE](StructureDefinition-CE.md),[Entry](StructureDefinition-Entry.md),[SubjectPerson](StructureDefinition-SubjectPerson.md),[Reference](StructureDefinition-Reference.md),[Component](StructureDefinition-Component.md),[Subject](StructureDefinition-Subject.md),[ParticipantRole](StructureDefinition-ParticipantRole.md),[Encounter](StructureDefinition-Encounter.md),[QTY](StructureDefinition-QTY.md),[TN](StructureDefinition-TN.md),[Place](StructureDefinition-Place.md),[PIVL-TS](StructureDefinition-PIVL-TS.md),[Birthplace](StructureDefinition-Birthplace.md),[LabeledDrug](StructureDefinition-LabeledDrug.md),[TS](StructureDefinition-TS.md),[RecordTarget](StructureDefinition-RecordTarget.md),[Criterion](StructureDefinition-Criterion.md),[OrganizationPartOf](StructureDefinition-OrganizationPartOf.md),[EN](StructureDefinition-EN.md),[EncounterParticipant](StructureDefinition-EncounterParticipant.md),[SXPR-TS](StructureDefinition-SXPR-TS.md),[Order](StructureDefinition-Order.md),[IVL-PQ](StructureDefinition-IVL-PQ.md),[IVXB-INT](StructureDefinition-IVXB-INT.md),[TEL](StructureDefinition-TEL.md),[IntendedRecipient](StructureDefinition-IntendedRecipient.md),[IVL-INT](StructureDefinition-IVL-INT.md),[Section](StructureDefinition-Section.md),[Guardian](StructureDefinition-Guardian.md),[MO](StructureDefinition-MO.md),[ED](StructureDefinition-ED.md),[Performer1](StructureDefinition-Performer1.md),[Performer2](StructureDefinition-Performer2.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md),[ManufacturedProduct](StructureDefinition-ManufacturedProduct.md),[Entity](StructureDefinition-Entity.md),[RTO-PQ-PQ](StructureDefinition-RTO-PQ-PQ.md),[AssociatedEntity](StructureDefinition-AssociatedEntity.md),[ObservationRange](StructureDefinition-ObservationRange.md),[Precondition2](StructureDefinition-Precondition2.md),[Observation](StructureDefinition-Observation.md),[InfrastructureRoot](StructureDefinition-InfrastructureRoot.md),[ExternalDocument](StructureDefinition-ExternalDocument.md),[MaintainedEntity](StructureDefinition-MaintainedEntity.md),[INT](StructureDefinition-INT.md),[ANY](StructureDefinition-ANY.md),[RelatedEntity](StructureDefinition-RelatedEntity.md),[REAL](StructureDefinition-REAL.md) | CDA |
| 31 | [CDAObservationInterpretation](ValueSet-CDAObservationInterpretation.md) | [Observation](StructureDefinition-Observation.md),[ObservationRange](StructureDefinition-ObservationRange.md) | CDA |
| 32 | [CDAParticipationType](ValueSet-CDAParticipationType.md) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md),[Informant](StructureDefinition-Informant.md),[Specimen](StructureDefinition-Specimen.md),[Participant2](StructureDefinition-Participant2.md),[Participant1](StructureDefinition-Participant1.md),[Custodian](StructureDefinition-Custodian.md),[Author](StructureDefinition-Author.md),[Authenticator](StructureDefinition-Authenticator.md),[Authorization](StructureDefinition-Authorization.md),[LegalAuthenticator](StructureDefinition-LegalAuthenticator.md),[DataEnterer](StructureDefinition-DataEnterer.md),[RecordTarget](StructureDefinition-RecordTarget.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | CDA |
| 33 | [CDAPostalAddressUse](ValueSet-CDAPostalAddressUse.md) | [AD](StructureDefinition-AD.md) | CDA |
| 34 | [CDARoleClass](ValueSet-CDARoleClass.md) | [AlternateIdentification](StructureDefinition-AlternateIdentification.md) | CDA |
| 35 | [CDARoleClassAssociative](ValueSet-CDARoleClassAssociative.md) | [AssociatedEntity](StructureDefinition-AssociatedEntity.md) | CDA |
| 36 | [CDARoleClassMutualRelationship](ValueSet-CDARoleClassMutualRelationship.md) | [RelatedEntity](StructureDefinition-RelatedEntity.md) | CDA |
| 37 | [CDARoleClassRoot](ValueSet-CDARoleClassRoot.md) | [ParticipantRole](StructureDefinition-ParticipantRole.md) | CDA |
| 38 | [CDARoleCode](ValueSet-CDARoleCode.md) | [AssignedEntity](StructureDefinition-AssignedEntity.md),[ParticipantRole](StructureDefinition-ParticipantRole.md),[AssignedAuthor](StructureDefinition-AssignedAuthor.md),[Guardian](StructureDefinition-Guardian.md),[AssociatedEntity](StructureDefinition-AssociatedEntity.md),[OrganizationPartOf](StructureDefinition-OrganizationPartOf.md) | CDA |
| 39 | [CDASetOperator](ValueSet-CDASetOperator.md) | [SXCM-TS](StructureDefinition-SXCM-TS.md),[PIVL-TS](StructureDefinition-PIVL-TS.md),[SXPR-TS](StructureDefinition-SXPR-TS.md),[IVL-PQ](StructureDefinition-IVL-PQ.md),[IVL-INT](StructureDefinition-IVL-INT.md),[EIVL-TS](StructureDefinition-EIVL-TS.md),[IVL-TS](StructureDefinition-IVL-TS.md) | CDA |
| 40 | [CDASignatureCode](ValueSet-CDASignatureCode.md) | [Authenticator](StructureDefinition-Authenticator.md),[LegalAuthenticator](StructureDefinition-LegalAuthenticator.md) | CDA |
| 41 | [DocumentSectionType](http://terminology.hl7.org/ValueSet/v3-DocumentSectionType) | [Section](StructureDefinition-Section.md) | THO |
| 42 | [EntityClassDevice](http://terminology.hl7.org/ValueSet/v3-EntityClassDevice) | [Device](StructureDefinition-Device.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md) | THO |
| 43 | [EntityClassLivingSubject](http://terminology.hl7.org/ValueSet/v3-EntityClassLivingSubject) | [Patient](StructureDefinition-Patient.md),[Person](StructureDefinition-Person.md),[SubjectPerson](StructureDefinition-SubjectPerson.md) | THO |
| 44 | [EntityClassManufacturedMaterial](http://terminology.hl7.org/ValueSet/v3-EntityClassManufacturedMaterial) | [LabeledDrug](StructureDefinition-LabeledDrug.md),[Material](StructureDefinition-Material.md) | THO |
| 45 | [EntityClassOrganization](http://terminology.hl7.org/ValueSet/v3-EntityClassOrganization) | [CustodianOrganization](StructureDefinition-CustodianOrganization.md),[Organization](StructureDefinition-Organization.md) | THO |
| 46 | [EntityClassPlace](http://terminology.hl7.org/ValueSet/v3-EntityClassPlace) | [Place](StructureDefinition-Place.md) | THO |
| 47 | [EntityClassRoot](http://terminology.hl7.org/ValueSet/v3-EntityClassRoot) | [Entity](StructureDefinition-Entity.md),[PlayingEntity](StructureDefinition-PlayingEntity.md) | THO |
| 48 | [EntityDeterminer](http://terminology.hl7.org/ValueSet/v3-EntityDeterminer) | [Place](StructureDefinition-Place.md),[Patient](StructureDefinition-Patient.md),[Device](StructureDefinition-Device.md),[Entity](StructureDefinition-Entity.md),[PlayingEntity](StructureDefinition-PlayingEntity.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md),[Person](StructureDefinition-Person.md),[SubjectPerson](StructureDefinition-SubjectPerson.md),[CustodianOrganization](StructureDefinition-CustodianOrganization.md),[Organization](StructureDefinition-Organization.md) | THO |
| 49 | [EntityDeterminerDetermined](http://terminology.hl7.org/ValueSet/v3-EntityDeterminerDetermined) | [LabeledDrug](StructureDefinition-LabeledDrug.md),[Material](StructureDefinition-Material.md) | THO |
| 50 | [EntityNamePartType](http://terminology.hl7.org/ValueSet/v3-EntityNamePartType) | [ENXP](StructureDefinition-ENXP.md) | THO |
| 51 | [Ethnicity](http://terminology.hl7.org/ValueSet/v3-Ethnicity) | [Patient](StructureDefinition-Patient.md) | THO |
| 52 | [FHIR Document Type Codes](http://hl7.org/fhir/R5/valueset-doc-typecodes.html) | [ParentDocument](StructureDefinition-ParentDocument.md),[ExternalDocument](StructureDefinition-ExternalDocument.md),[ClinicalDocument](StructureDefinition-ClinicalDocument.md) | FHIR |
| 53 | [IntegrityCheckAlgorithm](http://terminology.hl7.org/ValueSet/v3-IntegrityCheckAlgorithm) | [ED](StructureDefinition-ED.md) | THO |
| 54 | [LanguageAbilityMode](http://terminology.hl7.org/ValueSet/v3-LanguageAbilityMode) | [LanguageCommunication](StructureDefinition-LanguageCommunication.md) | THO |
| 55 | [LanguageAbilityProficiency](http://terminology.hl7.org/ValueSet/v3-LanguageAbilityProficiency) | [LanguageCommunication](StructureDefinition-LanguageCommunication.md) | THO |
| 56 | [Manufacturer Model Name Example](http://terminology.hl7.org/ValueSet/v3-ManufacturerModelNameExample) | [Device](StructureDefinition-Device.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md) | THO |
| 57 | [MaritalStatus](http://terminology.hl7.org/ValueSet/v3-MaritalStatus) | [Patient](StructureDefinition-Patient.md) | THO |
| 58 | [MediaType](http://terminology.hl7.org/ValueSet/v3-MediaType) | [ED](StructureDefinition-ED.md) | THO |
| 59 | [ObservationMethod](http://terminology.hl7.org/ValueSet/v3-ObservationMethod) | [Observation](StructureDefinition-Observation.md) | THO |
| 60 | [ObservationType](http://terminology.hl7.org/ValueSet/v3-ObservationType) | [Observation](StructureDefinition-Observation.md) | THO |
| 61 | [OrganizationIndustryClassNAICS](http://terminology.hl7.org/ValueSet/v3-OrganizationIndustryClassNAICS) | [Organization](StructureDefinition-Organization.md) | THO |
| 62 | [ParticipationPhysicalPerformer](http://terminology.hl7.org/ValueSet/v3-ParticipationPhysicalPerformer) | [Performer2](StructureDefinition-Performer2.md) | THO |
| 63 | [ParticipationTargetDirect](http://terminology.hl7.org/ValueSet/v3-ParticipationTargetDirect) | [Supply](StructureDefinition-Supply.md) | THO |
| 64 | [ParticipationTargetLocation](http://terminology.hl7.org/ValueSet/v3-ParticipationTargetLocation) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md) | THO |
| 65 | [ParticipationTargetSubject](http://terminology.hl7.org/ValueSet/v3-ParticipationTargetSubject) | [Subject](StructureDefinition-Subject.md) | THO |
| 66 | [PersonalRelationshipRoleType](http://terminology.hl7.org/ValueSet/v3-PersonalRelationshipRoleType) | [RelatedSubject](StructureDefinition-RelatedSubject.md),[RelatedEntity](StructureDefinition-RelatedEntity.md) | THO |
| 67 | [ROIOverlayShape](http://terminology.hl7.org/ValueSet/v3-ROIOverlayShape) | [RegionOfInterest](StructureDefinition-RegionOfInterest.md) | THO |
| 68 | [Race](http://terminology.hl7.org/ValueSet/v3-Race) | [Patient](StructureDefinition-Patient.md) | THO |
| 69 | [RelationshipConjunction](http://terminology.hl7.org/ValueSet/v3-RelationshipConjunction) | [ObservationRange](StructureDefinition-ObservationRange.md),[Precondition2](StructureDefinition-Precondition2.md) | THO |
| 70 | [ReligiousAffiliation](http://terminology.hl7.org/ValueSet/v3-ReligiousAffiliation) | [Patient](StructureDefinition-Patient.md) | THO |
| 71 | [RoleClassAgent](http://terminology.hl7.org/ValueSet/v3-RoleClassAgent) | [Guardian](StructureDefinition-Guardian.md) | THO |
| 72 | [RoleClassAssignedEntity](http://terminology.hl7.org/ValueSet/v3-RoleClassAssignedEntity) | [AssignedEntity](StructureDefinition-AssignedEntity.md),[AssignedCustodian](StructureDefinition-AssignedCustodian.md),[AssignedAuthor](StructureDefinition-AssignedAuthor.md) | THO |
| 73 | [RoleClassManufacturedProduct](http://terminology.hl7.org/ValueSet/v3-RoleClassManufacturedProduct) | [ManufacturedProduct](StructureDefinition-ManufacturedProduct.md) | THO |
| 74 | [RoleClassPartitive](http://terminology.hl7.org/ValueSet/v3-RoleClassPartitive) | [OrganizationPartOf](StructureDefinition-OrganizationPartOf.md) | THO |
| 75 | [RoleClassPassive](http://terminology.hl7.org/ValueSet/v3-RoleClassPassive) | [Birthplace](StructureDefinition-Birthplace.md),[MaintainedEntity](StructureDefinition-MaintainedEntity.md) | THO |
| 76 | [RoleClassRelationshipFormal](http://terminology.hl7.org/ValueSet/v3-RoleClassRelationshipFormal) | [PatientRole](StructureDefinition-PatientRole.md) | THO |
| 77 | [RoleClassServiceDeliveryLocation](http://terminology.hl7.org/ValueSet/v3-RoleClassServiceDeliveryLocation) | [HealthCareFacility](StructureDefinition-HealthCareFacility.md) | THO |
| 78 | [RoleClassSpecimen](http://terminology.hl7.org/ValueSet/v3-RoleClassSpecimen) | [SpecimenRole](StructureDefinition-SpecimenRole.md) | THO |
| 79 | [RoleLinkType](http://terminology.hl7.org/ValueSet/v3-RoleLinkType) | [IdentifiedBy](StructureDefinition-IdentifiedBy.md) | THO |
| 80 | [RouteOfAdministration](http://terminology.hl7.org/ValueSet/v3-RouteOfAdministration) | [SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 81 | [ServiceDeliveryLocationRoleType](http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType) | [HealthCareFacility](StructureDefinition-HealthCareFacility.md) | THO |
| 82 | [Software Name Example](http://terminology.hl7.org/ValueSet/v3-SoftwareNameExample) | [Device](StructureDefinition-Device.md),[AuthoringDevice](StructureDefinition-AuthoringDevice.md) | THO |
| 83 | [TargetAwareness](http://terminology.hl7.org/ValueSet/v3-TargetAwareness) | [Subject](StructureDefinition-Subject.md) | THO |
| 84 | [TelecommunicationAddressUse](http://terminology.hl7.org/ValueSet/v3-TelecommunicationAddressUse) | [TEL](StructureDefinition-TEL.md) | THO |
| 85 | [USEncounterDischargeDisposition](http://terminology.hl7.org/ValueSet/v3-USEncounterDischargeDisposition) | [EncompassingEncounter](StructureDefinition-EncompassingEncounter.md) | THO |
| 86 | [v3 Code System ActCode](http://terminology.hl7.org/ValueSet/v3-ActCode) | [ExternalObservation](StructureDefinition-ExternalObservation.md),[ExternalProcedure](StructureDefinition-ExternalProcedure.md),[ExternalAct](StructureDefinition-ExternalAct.md),[Consent](StructureDefinition-Consent.md),[Order](StructureDefinition-Order.md),[Act](StructureDefinition-Act.md),[Organizer](StructureDefinition-Organizer.md),[Criterion](StructureDefinition-Criterion.md),[Supply](StructureDefinition-Supply.md),[ObservationRange](StructureDefinition-ObservationRange.md) | THO |
| 87 | [v3 Value Set ActSite](http://terminology.hl7.org/ValueSet/v3-ActSite) | [SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 88 | [x_ActClassDocumentEntryAct](http://terminology.hl7.org/ValueSet/v3-xActClassDocumentEntryAct) | [Act](StructureDefinition-Act.md) | THO |
| 89 | [x_ActClassDocumentEntryOrganizer](http://terminology.hl7.org/ValueSet/v3-xActClassDocumentEntryOrganizer) | [Organizer](StructureDefinition-Organizer.md) | THO |
| 90 | [x_ActMoodDocumentObservation](http://terminology.hl7.org/ValueSet/v3-xActMoodDocumentObservation) | [Observation](StructureDefinition-Observation.md) | THO |
| 91 | [x_ActRelationshipDocument](http://terminology.hl7.org/ValueSet/v3-xActRelationshipDocument) | [RelatedDocument](StructureDefinition-RelatedDocument.md) | THO |
| 92 | [x_ActRelationshipEntry](http://terminology.hl7.org/ValueSet/v3-xActRelationshipEntry) | [Entry](StructureDefinition-Entry.md) | THO |
| 93 | [x_ActRelationshipEntryRelationship](http://terminology.hl7.org/ValueSet/v3-xActRelationshipEntryRelationship) | [EntryRelationship](StructureDefinition-EntryRelationship.md) | THO |
| 94 | [x_ActRelationshipExternalReference](http://terminology.hl7.org/ValueSet/v3-xActRelationshipExternalReference) | [Reference](StructureDefinition-Reference.md) | THO |
| 95 | [x_DocumentActMood](http://terminology.hl7.org/ValueSet/v3-xDocumentActMood) | [Act](StructureDefinition-Act.md) | THO |
| 96 | [x_DocumentEncounterMood](http://terminology.hl7.org/ValueSet/v3-xDocumentEncounterMood) | [Encounter](StructureDefinition-Encounter.md) | THO |
| 97 | [x_DocumentProcedureMood](http://terminology.hl7.org/ValueSet/v3-xDocumentProcedureMood) | [Procedure](StructureDefinition-Procedure.md) | THO |
| 98 | [x_DocumentSubstanceMood](http://terminology.hl7.org/ValueSet/v3-xDocumentSubstanceMood) | [Supply](StructureDefinition-Supply.md),[SubstanceAdministration](StructureDefinition-SubstanceAdministration.md) | THO |
| 99 | [x_EncounterParticipant](http://terminology.hl7.org/ValueSet/v3-xEncounterParticipant) | [EncounterParticipant](StructureDefinition-EncounterParticipant.md) | THO |
| 100 | [x_InformationRecipient](http://terminology.hl7.org/ValueSet/v3-xInformationRecipient) | [InformationRecipient](StructureDefinition-InformationRecipient.md) | THO |
| 101 | [x_ServiceEventPerformer](http://terminology.hl7.org/ValueSet/v3-xServiceEventPerformer) | [Performer1](StructureDefinition-Performer1.md) | THO |

### Code Systems

These code systems are used in this implementation guide:

Code System Sources:

* [FHIR](http://hl7.org/fhir/R5/)
* [THO](http://terminology.hl7.org/)
* [SNOMED](http://snomed.info/sct)
* [LOINC](http://loinc.org)
* [UCUM](http://unitsofmeasure.org)
* Code systems published by other standards organizations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 | [ActClass](http://terminology.hl7.org/CodeSystem/v3-ActClass) | `http://terminology.hl7.org/CodeSystem/v3-ActClass` | ValueSet/v3-ActClassProcedureValueSet/v3-xActClassDocumentEntryOrganizerValueSet/v3-ActClassClinicalDocumentValueSet/v3-ActClassROIValueSet/CDAActClassObservationValueSet/v3-ActClassRecordOrganizerValueSet/CDAActClassValueSet/v3-ActClassDocumentValueSet/v3-xActClassDocumentEntryActValueSet/v3-ActClassSupply | THO |
| 2 | [ActCode](http://terminology.hl7.org/CodeSystem/v3-ActCode) | `http://terminology.hl7.org/CodeSystem/v3-ActCode` | ValueSet/CDAActSubstanceAdministrationCodeValueSet/v3-ObservationTypeValueSet/v3-ActCodeValueSet/v3-ActEncounterCodeValueSet/v3-ROIOverlayShape | THO |
| 3 | [ActMood](http://terminology.hl7.org/CodeSystem/v3-ActMood) | `http://terminology.hl7.org/CodeSystem/v3-ActMood` | ValueSet/v3-xDocumentSubstanceMoodValueSet/v3-ActMoodPredicateValueSet/v3-xActMoodDocumentObservationValueSet/v3-xDocumentProcedureMoodValueSet/CDAActMoodIntentValueSet/CDAActMoodValueSet/v3-xDocumentActMoodValueSet/v3-xDocumentEncounterMood | THO |
| 4 | [ActPriority](http://terminology.hl7.org/CodeSystem/v3-ActPriority) | `http://terminology.hl7.org/CodeSystem/v3-ActPriority` | ValueSet/v3-ActPriority | THO |
| 5 | [ActRelationshipType](http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType) | `http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType` | ValueSet/CDAActRelationshipTypeValueSet/v3-xActRelationshipEntryValueSet/v3-xActRelationshipExternalReferenceValueSet/v3-ActRelationshipFulfillsValueSet/v3-xActRelationshipDocumentValueSet/v3-xActRelationshipEntryRelationshipValueSet/v3-ActRelationshipHasComponent | THO |
| 6 | [ActSite](http://terminology.hl7.org/CodeSystem/v3-ActSite) | `http://terminology.hl7.org/CodeSystem/v3-ActSite` | ValueSet/v3-ActSite | THO |
| 7 | [ActStatus](http://terminology.hl7.org/CodeSystem/v3-ActStatus) | `http://terminology.hl7.org/CodeSystem/v3-ActStatus` | ValueSet/v3-ActStatus | THO |
| 8 | [AddressUse](http://terminology.hl7.org/CodeSystem/v3-AddressUse) | `http://terminology.hl7.org/CodeSystem/v3-AddressUse` | ValueSet/CDAPostalAddressUseValueSet/v3-TelecommunicationAddressUse | THO |
| 9 | [AdministrativeGender](http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender) | `http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender` | ValueSet/v3-AdministrativeGender | THO |
| 10 | [Binary Data Encoding Code System](CodeSystem-BinaryDataEncoding.md) | `http://hl7.org/cda/stds/core/CodeSystem/BinaryDataEncoding` | ValueSet/BinaryDataEncoding | CDA |
| 11 | [CompressionAlgorithm](http://terminology.hl7.org/CodeSystem/v3-CompressionAlgorithm) | `http://terminology.hl7.org/CodeSystem/v3-CompressionAlgorithm` | ValueSet/CDACompressionAlgorithm | THO |
| 12 | [ContextControl](http://terminology.hl7.org/CodeSystem/v3-ContextControl) | `http://terminology.hl7.org/CodeSystem/v3-ContextControl` | ValueSet/CDAContextControl | THO |
| 13 | [EntityClass](http://terminology.hl7.org/CodeSystem/v3-EntityClass) | `http://terminology.hl7.org/CodeSystem/v3-EntityClass` | ValueSet/v3-EntityClassLivingSubjectValueSet/v3-EntityClassRootValueSet/v3-EntityClassManufacturedMaterialValueSet/v3-EntityClassPlaceValueSet/v3-EntityClassDeviceValueSet/v3-EntityClassOrganization | THO |
| 14 | [EntityCode](http://terminology.hl7.org/CodeSystem/v3-EntityCode) | `http://terminology.hl7.org/CodeSystem/v3-EntityCode` | ValueSet/CDAMaterialEntityClassTypeValueSet/CDAEntityCode | THO |
| 15 | [EntityDeterminer](http://terminology.hl7.org/CodeSystem/v3-EntityDeterminer) | `http://terminology.hl7.org/CodeSystem/v3-EntityDeterminer` | ValueSet/v3-EntityDeterminerValueSet/v3-EntityDeterminerDetermined | THO |
| 16 | [EntityNamePartQualifier](http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier) | `http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier` | ValueSet/CDAEntityNamePartQualifier | THO |
| 17 | [EntityNamePartType](http://terminology.hl7.org/CodeSystem/v3-EntityNamePartType) | `http://terminology.hl7.org/CodeSystem/v3-EntityNamePartType` | ValueSet/v3-EntityNamePartType | THO |
| 18 | [EntityNameUse](http://terminology.hl7.org/CodeSystem/v3-EntityNameUse) | `http://terminology.hl7.org/CodeSystem/v3-EntityNameUse` | ValueSet/CDAEntityNameUseValueSet/CDAPostalAddressUse | THO |
| 19 | [Ethnicity](http://terminology.hl7.org/CodeSystem/v3-Ethnicity) | `http://terminology.hl7.org/CodeSystem/v3-Ethnicity` | ValueSet/v3-Ethnicity | THO |
| 20 | [IntegrityCheckAlgorithm](http://terminology.hl7.org/CodeSystem/v3-IntegrityCheckAlgorithm) | `http://terminology.hl7.org/CodeSystem/v3-IntegrityCheckAlgorithm` | ValueSet/v3-IntegrityCheckAlgorithm | THO |
| 21 | [LanguageAbilityMode](http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityMode) | `http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityMode` | ValueSet/v3-LanguageAbilityMode | THO |
| 22 | [LanguageAbilityProficiency](http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency) | `http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency` | ValueSet/v3-LanguageAbilityProficiency | THO |
| 23 | [Logical Observation Identifiers](http://loinc.org) | `http://loinc.org` | LOINC provides a set of universal names and ID codes for identifying laboratory and clinical test results.12 LOINC facilitates the exchange and pooling of resultssuch as blood hemoglobinserum potassiumor vital signsfor clinical careoutcomes managementand research. LOINC's universal identifiers (names and codes) can be used in the context of order and observation exchanges between information systems that use syntax standards such as HL73CEN TC251ISO TC215ASTM4and DICOM. Specificallythe identifier can be used as the coded value for an observation in any other standard that uses the observation/observation value paradigmwhether messagesdocumentsapplication programming interface (API)etc. For exampleLOINC codes are used widely in the OBX segment Observation Identifier field (OBX-3) of an ORU HL7 (HL7 version 2.x or ASTM 1238-9410) message that may be sent between a Clinical Laboratory Information Management Systems (LIMS) and Electronic Health Record Systems (EHR).56 In this wayLOINC codes provide universal identifiers that allow the exchange of clinical data between heterogeneous computing environments. | LOINC |
| 24 | [ManufacturerModelNameExample](http://terminology.hl7.org/CodeSystem/v3-ManufacturerModelNameExample) | `http://terminology.hl7.org/CodeSystem/v3-ManufacturerModelNameExample` | ValueSet/v3-ManufacturerModelNameExample | THO |
| 25 | [MaritalStatus](http://terminology.hl7.org/CodeSystem/v3-MaritalStatus) | `http://terminology.hl7.org/CodeSystem/v3-MaritalStatus` | ValueSet/v3-MaritalStatus | THO |
| 26 | [Media Type](http://terminology.hl7.org/CodeSystem/v3-mediaType) | `http://terminology.hl7.org/CodeSystem/v3-mediaType` | ValueSet/v3-MediaType | THO |
| 27 | [National Uniform Billing Council](http://terminology.hl7.org/CodeSystem/nubc-UB92) | `http://terminology.hl7.org/CodeSystem/nubc-UB92` | National Uniform Billing CouncilUB 92 | THO |
| 28 | [North American Industry Classification System](http://terminology.hl7.org/CodeSystem/naics) | `http://terminology.hl7.org/CodeSystem/naics` | ValueSet/v3-OrganizationIndustryClassNAICS | THO |
| 29 | [NullFlavor](http://terminology.hl7.org/CodeSystem/v3-NullFlavor) | `http://terminology.hl7.org/CodeSystem/v3-NullFlavor` | ValueSet/CDANullFlavor | THO |
| 30 | [ObservationInterpretation](http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation) | `http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation` | ValueSet/CDAObservationInterpretation | THO |
| 31 | [ObservationMethod](http://terminology.hl7.org/CodeSystem/v3-ObservationMethod) | `http://terminology.hl7.org/CodeSystem/v3-ObservationMethod` | ValueSet/v3-ObservationMethod | THO |
| 32 | [Orderable Drug Form](http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm) | `http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm` | ValueSet/v3-AdministrableDrugForm | THO |
| 33 | [ParticipationSignature](http://terminology.hl7.org/CodeSystem/v3-ParticipationSignature) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationSignature` | ValueSet/CDASignatureCode | THO |
| 34 | [ParticipationType](http://terminology.hl7.org/CodeSystem/v3-ParticipationType) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationType` | ValueSet/v3-ParticipationTargetLocationValueSet/v3-xInformationRecipientValueSet/CDAParticipationTypeValueSet/v3-ParticipationPhysicalPerformerValueSet/v3-xServiceEventPerformerValueSet/v3-ParticipationTargetSubjectValueSet/v3-ParticipationTargetDirectValueSet/v3-xEncounterParticipant | THO |
| 35 | [Race](http://terminology.hl7.org/CodeSystem/v3-Race) | `http://terminology.hl7.org/CodeSystem/v3-Race` | ValueSet/v3-Race | THO |
| 36 | [RelationshipConjunction](http://terminology.hl7.org/CodeSystem/v3-RelationshipConjunction) | `http://terminology.hl7.org/CodeSystem/v3-RelationshipConjunction` | ValueSet/v3-RelationshipConjunction | THO |
| 37 | [Religious Affiliation](http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation) | `http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation` | ValueSet/v3-ReligiousAffiliation | THO |
| 38 | [RoleClass](http://terminology.hl7.org/CodeSystem/v3-RoleClass) | `http://terminology.hl7.org/CodeSystem/v3-RoleClass` | ValueSet/CDARoleClassAssociativeValueSet/v3-RoleClassPassiveValueSet/CDARoleClassRootValueSet/v3-RoleClassManufacturedProductValueSet/CDAInformationRecipientRoleValueSet/v3-RoleClassAssignedEntityValueSet/v3-RoleClassPartitiveValueSet/v3-RoleClassAgentValueSet/v3-RoleClassRelationshipFormalValueSet/CDARoleClassMutualRelationshipValueSet/v3-RoleClassServiceDeliveryLocationValueSet/v3-RoleClassSpecimenValueSet/CDARoleClass | THO |
| 39 | [RoleCode](http://terminology.hl7.org/CodeSystem/v3-RoleCode) | `http://terminology.hl7.org/CodeSystem/v3-RoleCode` | ValueSet/v3-PersonalRelationshipRoleTypeValueSet/CDARoleCodeValueSet/v3-ServiceDeliveryLocationRoleType | THO |
| 40 | [RoleLinkType](http://terminology.hl7.org/CodeSystem/v3-RoleLinkType) | `http://terminology.hl7.org/CodeSystem/v3-RoleLinkType` | ValueSet/v3-RoleLinkType | THO |
| 41 | [RouteOfAdministration](http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration) | `http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration` | ValueSet/v3-RouteOfAdministration | THO |
| 42 | [SetOperator](http://terminology.hl7.org/CodeSystem/v3-SetOperator) | `http://terminology.hl7.org/CodeSystem/v3-SetOperator` | ValueSet/CDASetOperator | THO |
| 43 | [SoftwareNameExample](http://terminology.hl7.org/CodeSystem/v3-SoftwareNameExample) | `http://terminology.hl7.org/CodeSystem/v3-SoftwareNameExample` | ValueSet/v3-SoftwareNameExample | THO |
| 44 | [SpecimenType](http://terminology.hl7.org/CodeSystem/v3-SpecimenType) | `http://terminology.hl7.org/CodeSystem/v3-SpecimenType` | ValueSet/CDAMaterialEntityClassType | THO |
| 45 | Tags for the Identification of Languages | `urn:ietf:bcp:47` | ValueSet/all-languages | Other |
| 46 | [TargetAwareness](http://terminology.hl7.org/CodeSystem/v3-TargetAwareness) | `http://terminology.hl7.org/CodeSystem/v3-TargetAwareness` | ValueSet/v3-TargetAwareness | THO |

