# Section (CDA Class) - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Section (CDA Class)**

## Logical Model: Section (CDA Class) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/stds/core/StructureDefinition/Section | *Version*:2.0.2-sd |
| Active as of 2025-12-11 | *Computable Name*:Section |

 
Document sections can nest, can override context propagated from the header (See[CDA Context](overview.md#cda-context)), and can contain narrative and CDA entries. 
An XML attribute "ID" of type XML ID, is added to Section within the CDA Schema. This attribute serves as the target of a linkHtml reference (see[linkHtml](narrative.md#linkhtml)). All values of attributes of type XML ID must be unique within the document (per the W3C XML specification). 
The narrative of each Section, together with the multimedia content referenced in the narrative, comprises the complete authenticated content of the Section. This multimedia content consists of[ObservationMedia](StructureDefinition-ObservationMedia.md)and[RegionOfInterest](StructureDefinition-RegionOfInterest.md)entries referenced by renderMultimedia tags in the Section.text. This is the only case where the entries contain authenticated content that must be rendered with the narrative. 
**'COMP' vs 'DRIV' Entries** 
In terms of the relationship between a section and its entries, CDA defines a default general case, and a more specific case that can be used when applicable. 
The entry relationship is defaulted to "COMP" (component), for the general case where the only assertion is that the related entries are contained within the source section and no other semantics are implied. In this case, the narrative is the original authenticated content. The CDA entries are created by various techniques (e.g., natural language processing, a human coder, a structured data entry tool that outputs both entries and a text report). The method of entry creation may be indicated by the entry participants (e.g., by identifying the algorithm or person that generated them). Relationships between various entries (such as two Observations or an[Observation](StructureDefinition-Observation.md)and an[ObservationMedia](StructureDefinition-ObservationMedia.md)) are encoded using the relationship types defined in[EntryRelationship](StructureDefinition-EntryRelationship.md). 
A section may also have no narrative content in the case where the entries represent information that is not part of the clinical content of the document. A report may embed information referencing evidence data, reagents, calibration or other information that may be used for later processing but is not part of the clinical content. Such entries are also linked to the Section with ActRelationships possessing typeCode="COMP". 
The entry relationship "DRIV" (is derived from) can be used in the special case where the narrative is fully derived from CDA Entries. When a report consisting entirely of structured entries is transformed into CDA, the encoding application must ensure that the authenticated content (narrative plus multimedia) is a faithful and complete rendering of the clinical content of the structured source data. This ensures that the narrative plus multimedia represents, as in all CDA documents, the complete authenticated content of the Section. In this case, narrative plus multimedia does not contain any clinical content that is not present in the Entries. An example of this case is a DICOM Structured Reporting document of obstetrical measurements made by ultrasound, rendered into a tabular report by a program converting it to CDA narrative block. If the typeCode of the ActRelationship linking these Entries to the Section was "DRIV", it would indicate to a receiving application: 1) the source of the narrative block is the Entries; 2) the contents of the two are equivalent. 
The entries sourced from a Section may have a mix of ActRelationship typeCodes. In such a case, the union of the targets with a "DRIV" relationship are those used to generate the narrative block, and are those that, taken in total, are equivalent to the narrative block. Additional entries with "COMP" relationships are contained within the same section, with no implied semantics. 

**Usages:**

* Use this Logical Model: [Section (CDA Class)](StructureDefinition-Section.md) and [StructuredBody (CDA Class)](StructureDefinition-StructuredBody.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.uv.core|current/StructureDefinition/Section)

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-Section.csv), [Excel](StructureDefinition-Section.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Section",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "version" : "2.0.2-sd",
  "name" : "Section",
  "title" : "Section (CDA Class)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T16:59:04+00:00",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        },
        {
          "system" : "email",
          "value" : "structdog@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Document sections can nest, can override context propagated from the header (See [CDA Context](overview.html#cda-context)), and can contain narrative and CDA entries.\n\nAn XML attribute \"ID\" of type XML ID, is added to Section within the CDA Schema. This attribute serves as the target of a linkHtml reference (see [linkHtml](narrative.html#linkhtml)). All values of attributes of type XML ID must be unique within the document (per the W3C XML specification).\n\n\n\nThe narrative of each Section, together with the multimedia content referenced in the narrative, comprises the complete authenticated content of the Section. This multimedia content consists of [ObservationMedia](StructureDefinition-ObservationMedia.html) and [RegionOfInterest](StructureDefinition-RegionOfInterest.html) entries referenced by renderMultimedia tags in the Section.text. This is the only case where the entries contain authenticated content that must be rendered with the narrative.\n\n\n\n**'COMP' vs 'DRIV' Entries**\n\nIn terms of the relationship between a section and its entries, CDA defines a default general case, and a more specific case that can be used when applicable.\n\nThe entry relationship is defaulted to \"COMP\" (component), for the general case where the only assertion is that the related entries are contained within the source section and no other semantics are implied. In this case, the narrative is the original authenticated content. The CDA entries are created by various techniques (e.g., natural language processing, a human coder, a structured data entry tool that outputs both entries and a text report). The method of entry creation may be indicated by the entry participants (e.g., by identifying the algorithm or person that generated them). Relationships between various entries (such as two Observations or an [Observation](StructureDefinition-Observation.html) and an [ObservationMedia](StructureDefinition-ObservationMedia.html)) are encoded using the relationship types defined in [EntryRelationship](StructureDefinition-EntryRelationship.html).\n\nA section may also have no narrative content in the case where the entries represent information that is not part of the clinical content of the document. A report may embed information referencing evidence data, reagents, calibration or other information that may be used for later processing but is not part of the clinical content. Such entries are also linked to the Section with ActRelationships possessing typeCode=\"COMP\".\n\nThe entry relationship \"DRIV\" (is derived from) can be used in the special case where the narrative is fully derived from CDA Entries. When a report consisting entirely of structured entries is transformed into CDA, the encoding application must ensure that the authenticated content (narrative plus multimedia) is a faithful and complete rendering of the clinical content of the structured source data. This ensures that the narrative plus multimedia represents, as in all CDA documents, the complete authenticated content of the Section. In this case, narrative plus multimedia does not contain any clinical content that is not present in the Entries. An example of this case is a DICOM Structured Reporting document of obstetrical measurements made by ultrasound, rendered into a tabular report by a program converting it to CDA narrative block. If the typeCode of the ActRelationship linking these Entries to the Section was \"DRIV\", it would indicate to a receiving application: 1) the source of the narrative block is the Entries; 2) the contents of the two are equivalent.\n\nThe entries sourced from a Section may have a mix of ActRelationship typeCodes. In such a case, the union of the targets with a \"DRIV\" relationship are those used to generate the narrative block, and are those that, taken in total, are equivalent to the narrative block. Additional entries with \"COMP\" relationships are contained within the same section, with no implied semantics.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/InfrastructureRoot",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.ID",
        "path" : "Section.ID",
        "representation" : ["xmlAttr"],
        "short" : "Can serve as a target of a linkHtml reference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "id",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/xs-ID"]
          }
        ]
      },
      {
        "id" : "Section.classCode",
        "path" : "Section.classCode",
        "representation" : ["xmlAttr"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "fixedCode" : "DOCSECT",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActClassRecordOrganizer"
        }
      },
      {
        "id" : "Section.moodCode",
        "path" : "Section.moodCode",
        "representation" : ["xmlAttr"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "fixedCode" : "EVN",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDAActMood"
        }
      },
      {
        "id" : "Section.id",
        "path" : "Section.id",
        "short" : "Unique instance identifier of a particular document section",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/II"
          }
        ]
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Kind of section",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CE"
          }
        ]
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "short" : "Label of a section",
        "requirements" : "If valued, it is to be rendered as part of the narrative content of the clinical document body.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ST"
          }
        ]
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "representation" : ["cdaText"],
        "short" : "Narrative to be rendered",
        "comment" : "Also referred to as the CDA Narrative Block",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "xhtml"
          }
        ]
      },
      {
        "id" : "Section.confidentialityCode",
        "path" : "Section.confidentialityCode",
        "short" : "Controls the disclosure of information in this section",
        "requirements" : "A value for Section.confidentialityCode overrides the value propagated from StructuredBody.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CE"
          }
        ]
      },
      {
        "id" : "Section.languageCode",
        "path" : "Section.languageCode",
        "short" : "Human language of character data",
        "requirements" : "A value for Section.languageCode overrides the value propagated from StructuredBody.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CS"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/all-languages"
        }
      },
      {
        "id" : "Section.subject",
        "path" : "Section.subject",
        "short" : "Primary target of the entries recorded in a section",
        "comment" : "Most of the time the subject is the same as the recordTarget, but need not be, for instance when the subject is a fetus observed in an obstetrical ultrasound.",
        "requirements" : "The subject participant can be ascribed to a CDA section or a CDA entry. It propagates to nested components, unless overridden. The subject of a document is presumed to be the patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Subject"
          }
        ]
      },
      {
        "id" : "Section.author",
        "path" : "Section.author",
        "requirements" : "The author participant can be ascribed to a CDA section, where it overrides the value(s) propagated from the CDA header.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author"
          }
        ]
      },
      {
        "id" : "Section.informant",
        "path" : "Section.informant",
        "requirements" : "The informant participant can be ascribed to a CDA section where it overrides the value(s) propagated from the CDA header.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Informant"
          }
        ]
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Entry"
          }
        ]
      },
      {
        "id" : "Section.component",
        "path" : "Section.component",
        "short" : "Used to nest a Section within a Section",
        "requirements" : "Context propagates to nested sections",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/InfrastructureRoot"
          }
        ]
      },
      {
        "id" : "Section.component.typeCode",
        "path" : "Section.component.typeCode",
        "representation" : ["xmlAttr"],
        "definition" : "Drawn from concept domain DocumentSectionType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "fixedCode" : "COMP"
      },
      {
        "id" : "Section.component.contextConductionInd",
        "path" : "Section.component.contextConductionInd",
        "representation" : ["xmlAttr"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/bl-simple"]
          }
        ],
        "fixedBoolean" : true
      },
      {
        "id" : "Section.component.section",
        "path" : "Section.component.section",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section"
          }
        ]
      }
    ]
  }
}

```
