# ClinicalDocument (CDA Class) - Clinical Document Architecture v2.0.2-sd

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ClinicalDocument (CDA Class)**

## Logical Model: ClinicalDocument (CDA Class) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument | *Version*:2.0.2-sd |
| Active as of 2025-12-11 | *Computable Name*:ClinicalDocument |

 
This is a generated StructureDefinition that describes CDA - that is, CDA as it actually is for R2. The intent of this StructureDefinition is to enable CDA to be a FHIR resource. That enables the FHIR infrastructure - API, conformance, query - to be used directly against CDA 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.uv.core|current/StructureDefinition/ClinicalDocument)

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ClinicalDocument.csv), [Excel](StructureDefinition-ClinicalDocument.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ClinicalDocument",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "version" : "2.0.2-sd",
  "name" : "ClinicalDocument",
  "title" : "ClinicalDocument (CDA Class)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T16:59:04+00:00",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        },
        {
          "system" : "email",
          "value" : "structdog@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This is a generated StructureDefinition that describes CDA - that is, CDA as it actually is for R2. The intent of this StructureDefinition is to enable CDA to be a FHIR resource. That enables the FHIR infrastructure - API, conformance, query - to be used directly against CDA",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ANY",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.classCode",
        "path" : "ClinicalDocument.classCode",
        "representation" : ["xmlAttr"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "fixedCode" : "DOCCLIN",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDAActClass"
        }
      },
      {
        "id" : "ClinicalDocument.moodCode",
        "path" : "ClinicalDocument.moodCode",
        "representation" : ["xmlAttr"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/cs-simple"]
          }
        ],
        "fixedCode" : "EVN",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDAActMood"
        }
      },
      {
        "id" : "ClinicalDocument.realmCode",
        "path" : "ClinicalDocument.realmCode",
        "definition" : "When valued in an instance, this attribute signals the imposition of realm-specific constraints. The value of this attribute identifies the realm in question",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CS"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.typeId",
        "path" : "ClinicalDocument.typeId",
        "definition" : "ClinicalDocument.typeId is a technology-neutral explicit reference to this CDA, Release Two specification, and must be valued as follows: ClinicalDocument.typeId.root = \"2.16.840.1.113883.1.3\" (which is the OID for HL7 Registered models); ClinicalDocument.typeId.extension = \"POCD_HD000040\" (which is the unique identifier for the CDA, Release Two Hierarchical Description).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/II"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.typeId.root",
        "path" : "ClinicalDocument.typeId.root",
        "representation" : ["xmlAttr"],
        "definition" : "Identifies the type as an HL7 Registered model",
        "min" : 1,
        "max" : "1",
        "fixedString" : "2.16.840.1.113883.1.3"
      },
      {
        "id" : "ClinicalDocument.typeId.extension",
        "path" : "ClinicalDocument.typeId.extension",
        "representation" : ["xmlAttr"],
        "definition" : "A character string as a unique identifier within the scope of the identifier root.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string",
            "profile" : ["http://hl7.org/cda/stds/core/StructureDefinition/st-simple"]
          }
        ],
        "fixedString" : "POCD_HD000040"
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "definition" : "When valued in an instance, this attribute signals the imposition of a set of template-defined constraints. The value of this attribute provides a unique identifier for the templates in question",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/II"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.id",
        "path" : "ClinicalDocument.id",
        "definition" : "Represents the unique instance identifier of a clinical document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/II"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "category"
          }
        ],
        "path" : "ClinicalDocument.sdtcCategory",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "Kind of document",
        "definition" : "The code specifying the particular kind of document (e.g. History and Physical, Discharge Summary, Progress Note).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CE"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/doc-typecodes"
        }
      },
      {
        "id" : "ClinicalDocument.title",
        "path" : "ClinicalDocument.title",
        "comment" : "It's commonly the case that clinical documents do not have a title, and are collectively referred to by the display name of ClinicalDocument.code (e.g. a 'consultation' or 'progress note'). Where these display names are rendered to the clinician, or where the document has a unique title, the ClinicalDocument.title component should be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ST"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.sdtcStatusCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "statusCode"
          }
        ],
        "path" : "ClinicalDocument.sdtcStatusCode",
        "definition" : "The statusCode extension attribute allows the implementer to identify a ClinicalDocument that is in other than the completed state. It was created to support the Structured Form Definition IG to identify that the document itself is an unfinished product currently being completed for a patient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CS"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "ClinicalDocument.effectiveTime",
        "path" : "ClinicalDocument.effectiveTime",
        "short" : "Document creation time",
        "definition" : "Signifies the document creation time, when the document first came into being.",
        "comment" : "Where the CDA document is a transform from an original document in some other format, the ClinicalDocument.effectiveTime is the time the original document is created. The time when the transform occurred is not currently represented in CDA.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.confidentialityCode",
        "path" : "ClinicalDocument.confidentialityCode",
        "short" : "Controls the disclosure of information in this document",
        "comment" : "Confidentiality is a required contextual component of CDA, where the value expressed in the header holds true for the entire document, unless overridden by a nested value.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CE"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.languageCode",
        "path" : "ClinicalDocument.languageCode",
        "short" : "Human language of character data",
        "definition" : "Specifies the human language of character data (whether they be in contents or attribute values).",
        "comment" : "Language is a contextual component of CDA, where the value expressed in the header holds true for the entire document, unless overridden by a nested value.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CS"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/all-languages"
        }
      },
      {
        "id" : "ClinicalDocument.setId",
        "path" : "ClinicalDocument.setId",
        "short" : "An identifier that is common across all document revisions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/II"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.versionNumber",
        "path" : "ClinicalDocument.versionNumber",
        "short" : "An integer value used to version successive replacement documents",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/INT"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.copyTime",
        "path" : "ClinicalDocument.copyTime",
        "short" : "Deprecated - use is discouraged",
        "definition" : "Represents the time a document is released (i.e. copied or sent to a display device) from a document management system that maintains revision control over the document. Once valued, it cannot be changed. The intent is to give the viewer of the document some notion as to how long the document has been out of the safe context of its document management system.",
        "requirements" : "Included for backwards compatibility with CDA, Release One. ClinicalDocument.copyTime has been deprecated because it is not part of the document at the time it is authenticated, but instead represents metadata about the document, applied at some variable time after authentication. Further use is discouraged.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget",
        "path" : "ClinicalDocument.recordTarget",
        "short" : "Medical record that this document belongs to",
        "comment" : "A clinical document typically has exactly one recordTarget participant. In the uncommon case where a clinical document (such as a group encounter note) is placed into more than one patient chart, more than one recordTarget participants can be stated.",
        "requirements" : "The recordTarget(s) of a document are stated in the header and propagate to nested content, where they cannot be overridden.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/RecordTarget"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author",
        "path" : "ClinicalDocument.author",
        "short" : "Humans and/or machines that authored the document",
        "comment" : "In some cases, the role or function of the author is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is 'Medical Student Progress Note'. The role of the author can also be recorded in the Author.functionCode or AssignedAuthor.code attribute. If either of these attributes is included, they should be equivalent to or further specialize the role inherent in the ClinicalDocument.code (such as where the ClinicalDocument.code is simply 'Physician Progress Note' and the value of Author.functionCode is 'rounding physician'), and shall not conflict with the role inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.dataEnterer",
        "path" : "ClinicalDocument.dataEnterer",
        "short" : "Participant who has transformed a dictated note into text",
        "alias" : ["Transcriptionist"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/DataEnterer"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informant",
        "path" : "ClinicalDocument.informant",
        "short" : "Person that provides relevant information",
        "definition" : "An informant (or source of information) is a person that provides relevant information, such as the parent of a comatose patient who describes the patient's behavior prior to the onset of coma.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Informant"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.custodian",
        "path" : "ClinicalDocument.custodian",
        "short" : "Organization that is in charge of maintaining the document",
        "definition" : "Represents the organization that is in charge of maintaining the document. The custodian is the steward that is entrusted with the care of the document. Every CDA document has exactly one custodian.",
        "requirements" : "The custodian participation satisfies the CDA definition of Stewardship. Because CDA is an exchange standard and may not represent the original form of the authenticated document, the custodian represents the steward of the original source document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Custodian"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "short" : "A recipient who should receive a copy of the document",
        "comment" : "The information recipient is an entity to whom a copy of a document is directed, at the time of document authorship. It is not the same as the cumulative set of persons to whom the document has subsequently been disclosed, over the life-time of the patient. Such a disclosure list would not be contained within the document, and it outside the scope of CDA.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/InformationRecipient"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator",
        "path" : "ClinicalDocument.legalAuthenticator",
        "short" : "Participant who has legally authenticated the document",
        "comment" : "The CDA is a standard that specifies the structure of exchanged clinical documents. In the case where a local document is transformed into a CDA document for exchange, authentication occurs on the local document, and that fact is reflected in the exchanged CDA document. A CDA document can reflect the unauthenticated, authenticated, or legally authenticated state. The unauthenticated state exists when no authentication information has been recorded (i.e., it is the absence of being either authenticated or legally authenticated).",
        "requirements" : "While electronic signatures are not captured in a CDA document, both authentication and legal authentication require that a document has been signed manually or electronically by the responsible individual. A legalAuthenticator has a required legalAuthenticator.time indicating the time of authentication, and a required legalAuthenticator.signatureCode, indicating that a signature has been obtained and is on file.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/LegalAuthenticator"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator",
        "path" : "ClinicalDocument.authenticator",
        "short" : "Participant who has attested to the accuracy of the document, but who does not have privileges to legally authenticate the document",
        "definition" : "Represents a participant who has attested to the accuracy of the document, but who does not have privileges to legally authenticate the document. An example would be a resident physician who sees a patient and dictates a note, then later signs it.",
        "comment" : "A clinical document can have zero to many authenticators. While electronic signatures are not captured in a CDA document, both authentication and legal authentication require that a document has been signed manually or electronically by the responsible individual. An authenticator has a required authenticator.time indicating the time of authentication, and a required authenticator.signatureCode, indicating that a signature has been obtained and is on file.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Authenticator"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "Other participants not explicitly mentioned by other classes",
        "definition" : "Used to represent other participants not explicitly mentioned by other classes, that were somehow involved in the documented acts.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "short" : "Orders that are fulfilled by this document",
        "comment" : "For instance, a provider orders an X-Ray. The X-Ray is performed. A radiologist reads the X-Ray and generates a report. The X-Ray order identifier is transmitted in the Order class, the performed X-Ray procedure is transmitted in the ServiceEvent class, and the ClinicalDocument.code would be valued with 'Diagnostic Imaging Report'.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/InFulfillmentOf"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "short" : "The main Act being documented",
        "comment" : "In some cases, the ServiceEvent is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is 'History and Physical Report' and the procedure being documented is a 'History and Physical' act. A ServiceEvent can further specialize the act inherent in the ClinicalDocument.code, such as where the ClinicalDocument.code is simply 'Procedure Report' and the procedure was a 'colonoscopy'. If ServiceEvent is included, it must be equivalent to or further specialize the value inherent in the ClinicalDocument.code, and shall not conflict with the value inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/DocumentationOf"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.relatedDocument",
        "path" : "ClinicalDocument.relatedDocument",
        "short" : "Source of a document revision, addenda, or transformation",
        "requirements" : "A conformant CDA document can have a single relatedDocument with typeCode 'APND'; a single relatedDocument with typeCode 'RPLC'; a single relatedDocument with typeCode 'XFRM'; a combination of two relatedDocuments with typeCodes 'XFRM' and 'RPLC'; or a combination of two relatedDocuments with typeCodes 'XFRM' and 'APND'. No other combinations are allowed.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/RelatedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authorization",
        "path" : "ClinicalDocument.authorization",
        "short" : "Consents associated with this document",
        "comment" : "The type of consent (e.g. a consent to perform the related ServiceEvent, a consent for the information contained in the document to be released to a third party) is conveyed in Consent.code. Consents referenced in the CDA Header have been finalized (Consent.statusCode must equal 'completed') and should be on file.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Authorization"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "Setting of the clinical encounter during which the documented act(s) or ServiceEvent occurred.",
        "definition" : "This optional class represents the setting of the clinical encounter during which the documented act(s) or ServiceEvent occurred. Documents are not necessarily generated during an encounter, such as when a clinician, in response to an abnormal lab result, attempts to contact the patient but can't, and writes a Progress Note.",
        "comment" : "In some cases, the setting of the encounter is inherent in the ClinicalDocument.code, such as where ClinicalDocument.code is 'Diabetes Clinic Progress Note'. The setting of an encounter can also be transmitted in the HealthCareFacility.code attribute. If HealthCareFacility.code is sent, it should be equivalent to or further specialize the value inherent in the ClinicalDocument.code (such as where the ClinicalDocument.code is simply 'Clinic Progress Note' and the value of HealthCareFacility.code is 'cardiology clinic'), and shall not conflict with the value inherent in the ClinicalDocument.code, as such a conflict would constitute an ambiguous situation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ComponentOf"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "short" : "Body of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Component"
          }
        ]
      }
    ]
  }
}

```
