# Terminology - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

This page lists all the ValueSets, CodeSystems, and ConceptMaps defined as part of the Consolidated CDA Implementation Guide.

Value sets that include inactive or deprecated codes must be used with caution. Inactive and deprecated codes should not be used for data creation. Non-active codes are of particular use when the value set is used for historical queries. Validation likely should accept non-active codes. Also implementers should be aware that some code systems do not provide access to non-active codes for current expansions and if non-active codes are needed they may be available in prior expansions available via terminology services.

### Value Sets

These value sets are used in this implementation guide:

Value Set Sources:

* [VSAC](http://cts.nlm.nih.gov/fhir/)
* [FHIR](http://hl7.org/fhir/R5/)
* [US CORE](http://hl7.org/fhir/us/core/terminology.html)
* [CDA](http://hl7.org/cda/stds/core/)
* [PHINVADS ODH](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.327)
* [LOINC](http://loinc.org)
* [THO](http://terminology.hl7.org/)

| | | |
| :--- | :--- | :--- |
| [ADConditionsAndPrognosisScenarios](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1115.23/expansion) | [TreatmentInterventionPreference](StructureDefinition-TreatmentInterventionPreference.md) | VSAC |
| [ADLResultType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.47/expansion) | [SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md) | VSAC |
| [Ability](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.46/expansion) | [SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md) | VSAC |
| [ActCode](http://terminology.hl7.org/ValueSet/v3-ActCode) | [ResultOrganizer](StructureDefinition-ResultOrganizer.md) | THO |
| [ActEncounterCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.5/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [ActPriority](http://terminology.hl7.org/ValueSet/v3-ActPriority) | [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ReferralAct](StructureDefinition-ReferralAct.md) | THO |
| [ActStatus](http://terminology.hl7.org/ValueSet/v3-ActStatus) | [CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md),[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[DrugMonitoringAct](StructureDefinition-DrugMonitoringAct.md),[GoalObservation](StructureDefinition-GoalObservation.md),[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[ReferralAct](StructureDefinition-ReferralAct.md) | THO |
| [AdministrationUnitDoseForm](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.30/expansion) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md) | VSAC |
| [AdvanceHealthcareDirectiveCategoriesLOINC](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.69.4/expansion) | [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md),[AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md) | VSAC |
| [AdvanceHealthcareDirectiveDocumentTypesGrouper](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1115.41/expansion) | [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md) | VSAC |
| [AgePQ_UCUM](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.21/expansion) | [AgeObservation](StructureDefinition-AgeObservation.md),[AgeRangeObservation](StructureDefinition-AgeRangeObservation.md) | VSAC |
| [AllLanguages](http://hl7.org/fhir/R5/valueset-all-languages.html) | [USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) | FHIR |
| [AllergyAndIntoleranceType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.3221.6.2/expansion) | [SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md) | VSAC |
| [AllergyClinicalStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.29/expansion) | [AllergyStatusObservation](StructureDefinition-AllergyStatusObservation.md) | VSAC |
| [AnswerSetWithYesNoAndUnknowns](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.16/expansion) | [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md) | VSAC |
| [BirthSex](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.24/expansion) | [BirthSexObservation](StructureDefinition-BirthSexObservation.md) | VSAC |
| [BodySiteValueSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.3221.8.9/expansion) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[SpecimenCollectionProcedure](StructureDefinition-SpecimenCollectionProcedure.md) | VSAC |
| [CDAObservationInterpretation](http://hl7.org/cda/stds/core/ValueSet-CDAObservationInterpretation.html) | [ResultObservation](StructureDefinition-ResultObservation.md) | CDA |
| [CDARoleClassAssociative](http://hl7.org/cda/stds/core/ValueSet-CDARoleClassAssociative.html) | [DischargeSummary](StructureDefinition-DischargeSummary.md) | CDA |
| [CDARoleCode](http://hl7.org/cda/stds/core/ValueSet-CDARoleCode.html) | [ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md) | CDA |
| [CMSPlaceOfServiceCodes](http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes) | [ServiceDeliveryLocation](StructureDefinition-ServiceDeliveryLocation.md) | THO |
| [CVXVaccinesAdministeredVaccineSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.6/expansion) | [ImmunizationMedicationInformation](StructureDefinition-ImmunizationMedicationInformation.md) | VSAC |
| [CareModel](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.61/expansion) | [ReferralAct](StructureDefinition-ReferralAct.md) | VSAC |
| [CarePlanCategory](http://hl7.org/fhir/R5/valueset-care-plan-category.html) | [CarePlanAct](StructureDefinition-CarePlanAct.md) | FHIR |
| [CarePlanDocumentType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.10/expansion) | [CarePlan](StructureDefinition-CarePlan.md) | VSAC |
| [CarePlanMoodCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.37/expansion) | [CarePlanAct](StructureDefinition-CarePlanAct.md) | VSAC |
| [CareTeamCategory](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.3.155/expansion) | [CareTeamTypeObservation](StructureDefinition-CareTeamTypeObservation.md) | VSAC |
| [CareTeamMemberFunction](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.30/expansion) | [CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md),[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[OperativeNote](StructureDefinition-OperativeNote.md),[USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [ClinicalSubstance](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.2/expansion) | [MedicationInformation](StructureDefinition-MedicationInformation.md) | VSAC |
| [ClinicalTests](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.19/expansion) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md) | VSAC |
| [CommonLOINCLabCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.17/expansion) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md) | VSAC |
| [CommonSubstancesForAllergyAndIntoleranceDocumentationIncludingRefutations](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1186.8/expansion) | [AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md) | VSAC |
| [CompletedOrNullifiedActStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.6/expansion) | [SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md) | VSAC |
| [ConsultDocumentType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.31/expansion) | [ConsultationNote](StructureDefinition-ConsultationNote.md) | VSAC |
| [Country2](http://terminology.hl7.org/ValueSet/v3-Country2) | [USRealmAddress](StructureDefinition-USRealmAddress.md),[USRealmHeader](StructureDefinition-USRealmHeader.md) | THO |
| [CoverageRoleTypeValueSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.18877/expansion) | [PolicyActivity](StructureDefinition-PolicyActivity.md) | VSAC |
| [CriticalityObservation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20549/expansion) | [CriticalityObservation](StructureDefinition-CriticalityObservation.md) | VSAC |
| [DetailedEthnicityIncludingAbsenceReasons](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.40.2.48.1/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [DetailedRaceIncludingAbsenceReasons](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.25/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [DeviceLatexSafety](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.47/expansion) | [LatexSafetyObservation](StructureDefinition-LatexSafetyObservation.md) | VSAC |
| [DeviceMagneticResonanceMRSafety](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.46/expansion) | [MRISafetyObservation](StructureDefinition-MRISafetyObservation.md) | VSAC |
| [DeviceTypes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.36/expansion) | [ProductInstance](StructureDefinition-ProductInstance.md) | VSAC |
| [DiagnosticServiceSectionCodes](http://hl7.org/fhir/R5/valueset-diagnostic-service-sections.html) | [ResultOrganizer](StructureDefinition-ResultOrganizer.md) | FHIR |
| [DischargeSummaryDocumentTypeCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.4.1/expansion) | [DischargeSummary](StructureDefinition-DischargeSummary.md) | VSAC |
| [EncounterType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.23/expansion) | [EncounterActivity](StructureDefinition-EncounterActivity.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md) | VSAC |
| [EntityPersonNamePartQualifier](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.26/expansion) | [USRealmPatientNamePTNUSFIELDED](StructureDefinition-USRealmPatientNamePTNUSFIELDED.md) | VSAC |
| [EthnicityCategories](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.40.2.48.3/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [FamilyMemberValue](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.19579/expansion) | [FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md) | VSAC |
| [FederalAdministrativeSex](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.121/expansion) | [FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[SexObservation](StructureDefinition-SexObservation.md) | VSAC |
| [FinanciallyResponsiblePartyTypeValueSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.10416/expansion) | [PolicyActivity](StructureDefinition-PolicyActivity.md) | VSAC |
| [GenderIdentity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.32/expansion) | [GenderIdentityObservation](StructureDefinition-GenderIdentityObservation.md) | VSAC |
| [GoalAchievement](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.55/expansion) | [ProgressTowardGoalObservation](StructureDefinition-ProgressTowardGoalObservation.md) | VSAC |
| [HL7BasicConfidentialityKind](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.16926/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [HPDocumentType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.22/expansion) | [HistoryandPhysical](StructureDefinition-HistoryandPhysical.md) | VSAC |
| [HealthStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.12/expansion) | [HealthStatusObservation](StructureDefinition-HealthStatusObservation.md) | VSAC |
| [HealthcareAgentOrProxyChoices](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1046.35/expansion) | [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md) | VSAC |
| [HealthcareProviderTaxonomy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.1066/expansion) | [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md),[AuthorParticipation](StructureDefinition-AuthorParticipation.md),[CarePlan](StructureDefinition-CarePlan.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[OperativeNote](StructureDefinition-OperativeNote.md),[ProcedureNote](StructureDefinition-ProcedureNote.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[ReferralAct](StructureDefinition-ReferralAct.md),[TransferSummary](StructureDefinition-TransferSummary.md),[USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [HealthcareServiceLocationTypeCombined](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.31/expansion) | [ServiceDeliveryLocation](StructureDefinition-ServiceDeliveryLocation.md) | VSAC |
| [INDRoleclassCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.33/expansion) | [CarePlan](StructureDefinition-CarePlan.md),[DischargeSummary](StructureDefinition-DischargeSummary.md),[ReferralNote](StructureDefinition-ReferralNote.md),[TransferSummary](StructureDefinition-TransferSummary.md) | VSAC |
| [ImplantableDeviceStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.48/expansion) | [ImplantableDeviceStatusObservation](StructureDefinition-ImplantableDeviceStatusObservation.md) | VSAC |
| [InformationSourceForMedicationAdherence](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.11/expansion) | [MedicationAdherence](StructureDefinition-MedicationAdherence.md) | VSAC |
| [LOINCAnswersLL5052-7]() | [DisabilityStatusObservation](StructureDefinition-DisabilityStatusObservation.md) |  |
| [LanguageAbilityMode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.12249/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [LanguageAbilityProficiency](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.12199/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [Languages](http://terminology.hl7.org/ValueSet/Languages) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | THO |
| [MaritalStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.12212/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [MedicationAdherence](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.8/expansion) | [MedicationAdherence](StructureDefinition-MedicationAdherence.md) | VSAC |
| [MedicationClinicalDrug](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.4/expansion) | [MedicationInformation](StructureDefinition-MedicationInformation.md) | VSAC |
| [MedicationDispenseStatusCodes](http://hl7.org/fhir/R5/valueset-medicationdispense-status.html) | [MedicationDispense](StructureDefinition-MedicationDispense.md) | FHIR |
| [MedicationRoute](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.12/expansion) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md) | VSAC |
| [MedicationStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.11/expansion) | [MedicationActivity](StructureDefinition-MedicationActivity.md) | VSAC |
| [MentalAndFunctionalStatusResponse](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.44/expansion) | [SensoryStatus](StructureDefinition-SensoryStatus.md) | VSAC |
| [MentalStatusObservation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.1/expansion) | [MentalStatusObservation](StructureDefinition-MentalStatusObservation.md) | VSAC |
| [MoodCodeEvnInt](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.18/expansion) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[MedicationFreeTextSig](StructureDefinition-MedicationFreeTextSig.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md) | VSAC |
| [NoImmunizationReason](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.19717/expansion) | [ImmunizationNotGivenReason](StructureDefinition-ImmunizationNotGivenReason.md) | VSAC |
| [NutritionRecommendationGrouping](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1095.65/expansion) | [NutritionRecommendation](StructureDefinition-NutritionRecommendation.md) | VSAC |
| [NutritionalStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.2.7/expansion) | [NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md) | VSAC |
| [ObservationType](http://terminology.hl7.org/ValueSet/v3-ObservationType) | [ResultObservation](StructureDefinition-ResultObservation.md) | THO |
| [PHVS_Industry_NAICS_Detail _ODH](http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7900) | [BasicIndustryObservation](StructureDefinition-BasicIndustryObservation.md) | PHINVADS |
| [PHVS_Occupation_ONETSOC_Detail_ODH](http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7901) | [BasicOccupationObservation](StructureDefinition-BasicOccupationObservation.md) | PHINVADS |
| [ParticipationFunction](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.10267/expansion) | [USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) | VSAC |
| [PatientEducation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.34/expansion) | [InstructionActivity](StructureDefinition-InstructionActivity.md),[InstructionObservation](StructureDefinition-InstructionObservation.md) | VSAC |
| [PatientReferralActMoodCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.66/expansion) | [ReferralAct](StructureDefinition-ReferralAct.md) | VSAC |
| [PayerType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion) | [PlannedCoverage](StructureDefinition-PlannedCoverage.md),[PolicyActivity](StructureDefinition-PolicyActivity.md) | VSAC |
| [PersonalAndLegalRelationshipRoleType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.12.1/expansion) | [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md),[AuthorParticipation](StructureDefinition-AuthorParticipation.md),[CarePlan](StructureDefinition-CarePlan.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[RelatedPersonRelationshipAndNameParticipant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[USRealmHeader](StructureDefinition-USRealmHeader.md),[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) | VSAC |
| [PersonalPronouns](http://terminology.hl7.org/ValueSet/pronouns) | [IndividualPronounObservation](StructureDefinition-IndividualPronounObservation.md) | THO |
| [PhysicalExamType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.65/expansion) | [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md) | VSAC |
| [PlannedInterventionMoodCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.54/expansion) | [PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md) | VSAC |
| [PlannedMoodCodeActEncounterProcedure](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.23/expansion) | [NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md) | VSAC |
| [PlannedMoodCodeSubstanceAdministrationSupply](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.24/expansion) | [PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedSupply](StructureDefinition-PlannedSupply.md) | VSAC |
| [PracticeSettingCodeValueSet](http://hl7.org/fhir/R5/valueset-c80-practice-codes.html) | [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md),[AuthorParticipation](StructureDefinition-AuthorParticipation.md),[CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md),[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[NoteActivity](StructureDefinition-NoteActivity.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[RelatedPersonRelationshipAndNameParticipant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[USRealmHeader](StructureDefinition-USRealmHeader.md),[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) | FHIR |
| [PregnancyIntention](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1166.22/expansion) | [PregnancyIntentionInNextYear](StructureDefinition-PregnancyIntentionInNextYear.md) | VSAC |
| [PregnancyStatusObservation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.12/expansion) | [PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md) | VSAC |
| [PressureUlcerStage](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.35/expansion) | [NumberofPressureUlcersObservation](StructureDefinition-NumberofPressureUlcersObservation.md) | VSAC |
| [PriorityLevel](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.60/expansion) | [PriorityPreference](StructureDefinition-PriorityPreference.md) | VSAC |
| [ProblemActStatusCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.19/expansion) | [AllergyConcernAct](StructureDefinition-AllergyConcernAct.md),[HealthConcernAct](StructureDefinition-HealthConcernAct.md),[ProblemConcernAct](StructureDefinition-ProblemConcernAct.md),[RiskConcernAct](StructureDefinition-RiskConcernAct.md) | VSAC |
| [ProblemStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.68/expansion) | [ProblemStatus](StructureDefinition-ProblemStatus.md) | VSAC |
| [ProblemType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.1/expansion) | [FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md),[Indication](StructureDefinition-Indication.md),[ProblemObservation](StructureDefinition-ProblemObservation.md) | VSAC |
| [Procedure](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.28/expansion) | [OperativeNote](StructureDefinition-OperativeNote.md),[ProcedureNote](StructureDefinition-ProcedureNote.md) | VSAC |
| [ProcedureActStatusCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.22/expansion) | [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) | VSAC |
| [ProcedureNoteDocumentTypeCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.6.1/expansion) | [ProcedureNote](StructureDefinition-ProcedureNote.md) | VSAC |
| [ProgressNoteDocumentTypeCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.8.1/expansion) | [ProgressNote](StructureDefinition-ProgressNote.md) | VSAC |
| [RaceCategories](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.2.575/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [RaceValueSet](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.14914/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [RadiologyProceduresLOINC](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.18/expansion) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md) | VSAC |
| [ReferralDocumentType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.2.3/expansion) | [ReferralNote](StructureDefinition-ReferralNote.md) | VSAC |
| [ReferralTypes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.56/expansion) | [ReferralAct](StructureDefinition-ReferralAct.md) | VSAC |
| [ReligiousAffiliation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.19185/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [ResidenceAndAccommodationType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.49/expansion) | [CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md) | VSAC |
| [ResultStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.39/expansion) | [MedicalEquipmentOrganizer](StructureDefinition-MedicalEquipmentOrganizer.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md) | VSAC |
| [SPLDrugRouteOfAdministrationTerminology](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.3221.8.7/expansion) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md) | VSAC |
| [ScreeningAndAssessmentSurveyCodes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.13/expansion) | [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md) | VSAC |
| [SensoryStatusProblemType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.50/expansion) | [SensoryStatus](StructureDefinition-SensoryStatus.md) | VSAC |
| [Severity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.3221.6.8/expansion) | [SeverityObservation](StructureDefinition-SeverityObservation.md) | VSAC |
| [SexParameterForClinicalUse](http://terminology.hl7.org/ValueSet/sex-parameter-for-clinical-use) | [SexParameterForClinicalUseObservation](StructureDefinition-SexParameterForClinicalUseObservation.md) | THO |
| [SexualOrientationIncludingNullsAndDataAbsentReason](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.11/expansion) | [SexualOrientationObservation](StructureDefinition-SexualOrientationObservation.md) | VSAC |
| [SmokingStatus](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.38/expansion) | [SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md) | VSAC |
| [SmokingStatusComprehensive](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.3/expansion) | [SmokingStatus](StructureDefinition-SmokingStatus.md) | VSAC |
| [SmokingStatusType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.6/expansion) | [SmokingStatus](StructureDefinition-SmokingStatus.md) | VSAC |
| [SocialDeterminantsOfHealthConditions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion) | [ProblemObservation](StructureDefinition-ProblemObservation.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md) | VSAC |
| [SocialDeterminantsOfHealthGoals](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.71/expansion) | [GoalObservation](StructureDefinition-GoalObservation.md) | VSAC |
| [SocialDeterminantsOfHealthProcedures](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.789/expansion) | [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) | VSAC |
| [SocialDeterminantsOfHealthScreeningAssessmentsAndQuestions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.206/expansion) | [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md) | VSAC |
| [SocialDeterminantsOfHealthServiceRequests](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.790/expansion) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md) | VSAC |
| [SocialHistoryType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.28/expansion) | [SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md) | VSAC |
| [SpecimenType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.54/expansion) | [ResultOrganizer](StructureDefinition-ResultOrganizer.md) | VSAC |
| [SubstanceReactantForIntolerance](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.1/expansion) | [SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md) | VSAC |
| [SupportedFileFormats](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.7.1/expansion) | [NoteActivity](StructureDefinition-NoteActivity.md),[UnstructuredDocument](StructureDefinition-UnstructuredDocument.md) | VSAC |
| [SurgicalOperationNoteDocumentTypeCode](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.1.1/expansion) | [OperativeNote](StructureDefinition-OperativeNote.md) | VSAC |
| [TargetSiteQualifiers](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.37/expansion) | [LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md) | VSAC |
| [TelecomUseUSRealmHeader](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.20/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |
| [TobaccoUse](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.41/expansion) | [TobaccoUse](StructureDefinition-TobaccoUse.md) | VSAC |
| [TransferDocumentType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.2.4/expansion) | [TransferSummary](StructureDefinition-TransferSummary.md) | VSAC |
| [TribalEntityUS](http://terminology.hl7.org/ValueSet/v3-TribalEntityUS) | [TribalAffiliationObservation](StructureDefinition-TribalAffiliationObservation.md) | THO |
| [USCoreClinicalNoteType](http://hl7.org/fhir/us/core/ValueSet-us-core-clinical-note-type.html) | [NoteActivity](StructureDefinition-NoteActivity.md),[NotesSection](StructureDefinition-NotesSection.md) | US CORE |
| [USCoreClinicalResultObservationCategory](http://hl7.org/fhir/us/core/ValueSet-us-core-clinical-result-observation-category.html) | [ResultObservation](StructureDefinition-ResultObservation.md) | US CORE |
| [USCoreConditionCodes](http://hl7.org/fhir/us/core/ValueSet-us-core-condition-code.html) | [FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md),[Indication](StructureDefinition-Indication.md),[PreconditionforSubstanceAdministration](StructureDefinition-PreconditionforSubstanceAdministration.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md) | US CORE |
| [USCoreDocumentReferenceType](http://hl7.org/fhir/us/core/ValueSet-us-core-documentreference-type.html) | [NoteActivity](StructureDefinition-NoteActivity.md),[NotesSection](StructureDefinition-NotesSection.md) | US CORE |
| [USCoreProcedureCodes](http://hl7.org/fhir/us/core/ValueSet-us-core-procedure-code.html) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) | US CORE |
| [USCoreServiceRequestCategoryCodes](http://hl7.org/fhir/us/core/ValueSet-us-core-servicerequest-category.html) | [PlannedProcedure](StructureDefinition-PlannedProcedure.md) | US CORE |
| [USCoreSpecimenCondition](http://hl7.org/fhir/us/core/ValueSet-us-core-specimen-condition.html) | [SpecimenConditionObservation](StructureDefinition-SpecimenConditionObservation.md) | US CORE |
| [USEncounterDischargeDisposition](http://terminology.hl7.org/ValueSet/v3-USEncounterDischargeDisposition) | [DischargeSummary](StructureDefinition-DischargeSummary.md),[EncounterActivity](StructureDefinition-EncounterActivity.md) | THO |
| [UnitsOfMeasureCaseSensitive](http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive) | [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[ResultObservation](StructureDefinition-ResultObservation.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[VitalSignObservation](StructureDefinition-VitalSignObservation.md) | THO |
| [UspsTwoLetterAlphabeticCodes](http://terminology.hl7.org/ValueSet/USPS-State) | [USRealmAddress](StructureDefinition-USRealmAddress.md) | THO |
| [VitalSignResultType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion) | [VitalSignObservation](StructureDefinition-VitalSignObservation.md) | VSAC |
| [WoundCharacteristic](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.58/expansion) | [WoundCharacteristic](StructureDefinition-WoundCharacteristic.md) | VSAC |
| [WoundMeasurements](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.2.5/expansion) | [WoundMeasurementObservation](StructureDefinition-WoundMeasurementObservation.md) | VSAC |
| [WoundType](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.20.2.6/expansion) | [LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md) | VSAC |
| [X_ActRelationshipDocument](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.11610/expansion) | [CarePlan](StructureDefinition-CarePlan.md) | VSAC |
| [X_ServiceEventPerformer](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.1.11.19601/expansion) | [USRealmHeader](StructureDefinition-USRealmHeader.md) | VSAC |

### Code Systems

These code systems are used in this implementation guide:

Code System Sources:

* [FHIR](http://hl7.org/fhir/R5/)
* [US CORE](http://hl7.org/fhir/us/core/terminology.html)
* [PHINVADS ODH](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.327)
* [THO](http://terminology.hl7.org/)
* [SNOMED](http://snomed.info/sct)
* [LOINC](http://loinc.org)
* [UCUM](http://unitsofmeasure.org)
* [CDC](https://www.cdc.gov/index.htm)
* Code systems published by other standards organizations

| | | | |
| :--- | :--- | :--- | :--- |
| [AHA_NUBC_PatientDischargeStatus](https://www.nubc.org/CodeSystem/PatDischargeStatus) | `https://www.nubc.org/CodeSystem/PatDischargeStatus` | USEncounterDischargeDisposition | Other |
| [ActCode](http://terminology.hl7.org/CodeSystem/v3-ActCode) | `http://terminology.hl7.org/CodeSystem/v3-ActCode` | ActEncounterCodesObservationTypeActCode | THO |
| [ActMood](http://terminology.hl7.org/CodeSystem/v3-ActMood) | `http://terminology.hl7.org/CodeSystem/v3-ActMood` | CarePlanMoodCodesPlannedInterventionMoodCodePatientReferralActMoodCodePlannedMoodCodeActEncounterProcedurePlannedMoodCodeSubstanceAdministrationSupplyMoodCodeEvnInt | THO |
| [ActPriority](http://terminology.hl7.org/CodeSystem/v3-ActPriority) | `http://terminology.hl7.org/CodeSystem/v3-ActPriority` | ActPriority | THO |
| [ActReason](http://terminology.hl7.org/CodeSystem/v3-ActReason) | `http://terminology.hl7.org/CodeSystem/v3-ActReason` | NoImmunizationReason | THO |
| [ActRelationshipType](http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType) | `http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType` | X_ActRelationshipDocument | THO |
| [ActStatus](http://terminology.hl7.org/CodeSystem/v3-ActStatus) | `http://terminology.hl7.org/CodeSystem/v3-ActStatus` | MedicationStatusProcedureActStatusCodeCompletedOrNullifiedActStatusActStatusProblemActStatusCodeResultStatus | THO |
| [AddressUse](http://terminology.hl7.org/CodeSystem/v3-AddressUse) | `http://terminology.hl7.org/CodeSystem/v3-AddressUse` | TelecomUseUSRealmHeader | THO |
| [CDCREC](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238) | `urn:oid:2.16.840.1.113883.6.238` | RaceValueSet | PHINVADS |
| [CDT](http://www.ada.org/cdt) | `http://www.ada.org/cdt` | USCoreProcedureCodes | Other |
| [CMSPlaceofServiceCodes](https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set) | `https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set` | CMSPlaceOfServiceCodes | Other |
| [CPT](http://www.ama-assn.org/go/cpt) | `http://www.ama-assn.org/go/cpt` | USCoreProcedureCodes | Other |
| [CVX](https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx) | `http://hl7.org/fhir/sid/cvx` | CVXVaccinesAdministeredVaccineSet | CDC |
| [Confidentiality](http://terminology.hl7.org/CodeSystem/v3-Confidentiality) | `http://terminology.hl7.org/CodeSystem/v3-Confidentiality` | HL7BasicConfidentialityKind | THO |
| [DataAbsentReason](http://terminology.hl7.org/CodeSystem/data-absent-reason) | `http://terminology.hl7.org/CodeSystem/data-absent-reason` | SexParameterForClinicalUse | THO |
| [DiagnosticServiceSectionId](http://terminology.hl7.org/CodeSystem/v2-0074) | `http://terminology.hl7.org/CodeSystem/v2-0074` | DiagnosticServiceSectionCodes | THO |
| [EntityNamePartQualifier](http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier) | `http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier` | EntityPersonNamePartQualifier | THO |
| [HCPCSLevelII](https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets) | `https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets` | USCoreProcedureCodes | Other |
| [ISO3166Part1](https://www.iso.org/iso-3166-country-codes.html) | `urn:iso:std:iso:3166` | Country2 | ISO |
| [Icd10CM](https://www.cdc.gov/nchs/icd/icd-10-cm) | `http://hl7.org/fhir/sid/icd-10-cm` | USCoreConditionCodes | CDC |
| [Icd10PCS](http://www.cms.gov/Medicare/Coding/ICD10) | `http://www.cms.gov/Medicare/Coding/ICD10` | USCoreProcedureCodes | Other |
| [Icd9cm](http://terminology.hl7.org/CodeSystem/icd9cm) | `http://terminology.hl7.org/CodeSystem/icd9cm` | USCoreConditionCodes | THO |
| [Ietf3066](https://www.loc.gov/standards/iso639-2/php/code_list.php) | `urn:ietf:bcp:47` | AllLanguagesLanguages | IETF |
| [LOINC](http://loinc.org) | `http://loinc.org` | SurgicalOperationNoteDocumentTypeCodeHPDocumentTypeProcedureNoteDocumentTypeCodesCareTeamCategoryDischargeSummaryDocumentTypeCodeADLResultTypeVitalSignResultTypeCarePlanDocumentTypeADConditionsAndPrognosisScenariosHealthcareAgentOrProxyChoicesPhysicalExamTypeAdvanceHealthcareDirectiveCategoriesLOINCConsultDocumentTypeReferralDocumentTypeUSCoreProcedureCodesTransferDocumentTypeProgressNoteDocumentTypeCodeWoundMeasurements | LOINC |
| [LanguageAbilityMode](http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityMode) | `http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityMode` | LanguageAbilityMode | THO |
| [LanguageAbilityProficiency](http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency) | `http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency` | LanguageAbilityProficiency | THO |
| [MaritalStatus](http://terminology.hl7.org/CodeSystem/v3-MaritalStatus) | `http://terminology.hl7.org/CodeSystem/v3-MaritalStatus` | MaritalStatus | THO |
| [MediaType](http://terminology.hl7.org/CodeSystem/v3-mediaType) | `http://terminology.hl7.org/CodeSystem/v3-mediaType` | SupportedFileFormats | THO |
| [MedicationDispenseStatusCodes](http://hl7.org/fhir/R5/codesystem-medicationdispense-status.html) | `http://hl7.org/fhir/CodeSystem/medicationdispense-status` | MedicationDispenseStatusCodes | FHIR |
| [NUCC_Provider_Taxonomy](http://nucc.org/provider-taxonomy) | `http://nucc.org/provider-taxonomy` | HealthcareProviderTaxonomy | Other |
| [NciThesaurus](http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl) | `http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl` | AdministrationUnitDoseFormSPLDrugRouteOfAdministrationTerminologyDeviceLatexSafetyImplantableDeviceStatusDeviceMagneticResonanceMRSafety | Other |
| [NullFlavor](http://terminology.hl7.org/CodeSystem/v3-NullFlavor) | `http://terminology.hl7.org/CodeSystem/v3-NullFlavor` | USCoreDocumentReferenceType | THO |
| [ObservationCategoryCodes](http://terminology.hl7.org/CodeSystem/observation-category) | `http://terminology.hl7.org/CodeSystem/observation-category` | USCoreClinicalResultObservationCategory | THO |
| [ObservationInterpretation](http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation) | `http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation` | CDAObservationInterpretation | THO |
| [ObservationValue](http://terminology.hl7.org/CodeSystem/v3-ObservationValue) | `http://terminology.hl7.org/CodeSystem/v3-ObservationValue` | CriticalityObservation | THO |
| [PHOccupationalDataForHealthODH](http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH) | `http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH` | PHVS_Industry_NAICS_Detail _ODHPHVS_Occupation_ONETSOC_Detail_ODH | THO |
| [ParticipationFunction](http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction` | ParticipationFunction | THO |
| [ParticipationType](http://terminology.hl7.org/CodeSystem/v3-ParticipationType) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationType` | X_ServiceEventPerformer | THO |
| [ReligiousAffiliation](http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation) | `http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation` | ReligiousAffiliation | THO |
| [RoleClass](http://terminology.hl7.org/CodeSystem/v3-RoleClass) | `http://terminology.hl7.org/CodeSystem/v3-RoleClass` | CDARoleClassAssociativeINDRoleclassCodesFinanciallyResponsiblePartyTypeValueSet | THO |
| [RoleCode](http://terminology.hl7.org/CodeSystem/v3-RoleCode) | `http://terminology.hl7.org/CodeSystem/v3-RoleCode` | CoverageRoleTypeValueSetCDARoleCodePersonalAndLegalRelationshipRoleTypeFamilyMemberValue | THO |
| [SOP](https://nahdo.org/sopt) | `https://nahdo.org/sopt` | PayerType | Other |
| [SexParameterForClinicalUseCS](http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use) | `http://terminology.hl7.org/CodeSystem/sex-parameter-for-clinical-use` | SexParameterForClinicalUse | THO |
| [TribalEntityUS](http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS) | `http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS` | TribalEntityUS | THO |
| [UCUM](http://unitsofmeasure.org) | `http://unitsofmeasure.org` | AgePQ_UCUMUnitsOfMeasureCaseSensitive | UCUM |
| [USCoreCategory](http://hl7.org/fhir/us/core/CodeSystem-us-core-category.html) | `http://hl7.org/fhir/us/core/CodeSystem/us-core-category` | USCoreServiceRequestCategoryCodes | US CORE |
| [USPSStateCodes](https://www.usps.com/) | `https://www.usps.com/` | UspsTwoLetterAlphabeticCodes | Other |
| [icd9CMProcedureCodes](https://archive.cdc.gov/#/details?url=https://www.cdc.gov/nchs/icd/icd9cm.htm) | `http://hl7.org/fhir/sid/icd-9-cm` | USCoreConditionCodes | CDC |

