# Downloads - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

**Full Implementation Guide**

The entire implementation guide (including the HTML files, definitions, validation information, etc.) may be downloaded [here](full-ig.zip).

In addition, there are format specific definitions files.

* [XML](definitions.xml.zip)
* [JSON](definitions.json.zip)
* [TTL](definitions.ttl.zip)

**Examples:** All the examples that are used in this Implementation Guide are available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTl](examples.ttl.zip)

### Cross Version Analysis

### Dependency Table







### Global Profiles Table

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r5/ValueSet/nucc-provider-taxonomy): [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md), [AuthorParticipation](StructureDefinition-AuthorParticipation.md)...Show 8 more,[CarePlan](StructureDefinition-CarePlan.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[OperativeNote](StructureDefinition-OperativeNote.md),[ProcedureNote](StructureDefinition-ProcedureNote.md),[ReferralAct](StructureDefinition-ReferralAct.md),[TransferSummary](StructureDefinition-TransferSummary.md)and[USRealmHeader](StructureDefinition-USRealmHeader.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [ActivitiesSection](StructureDefinition-ActivitiesSection.md), [AdmissionDiagnosisSection](StructureDefinition-AdmissionDiagnosisSection.md)...Show 227 more,[AdmissionMedication](StructureDefinition-AdmissionMedication.md),[AdmissionMedicationsSectionEntriesOptional](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.md),[AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md),[AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md),[AdvanceDirectiveOrganizer](StructureDefinition-AdvanceDirectiveOrganizer.md),[AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md),[AgeObservation](StructureDefinition-AgeObservation.md),[AgeRangeObservation](StructureDefinition-AgeRangeObservation.md),[AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md),[AllergyConcernAct](StructureDefinition-AllergyConcernAct.md),[AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md),[AllergyStatusObservation](StructureDefinition-AllergyStatusObservation.md),[AnesthesiaSection](StructureDefinition-AnesthesiaSection.md),[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[AssessmentScaleSupportingObservation](StructureDefinition-AssessmentScaleSupportingObservation.md),[AssessmentSection](StructureDefinition-AssessmentSection.md),[AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md),[AuthorParticipation](StructureDefinition-AuthorParticipation.md),[AuthorizationActivity](StructureDefinition-AuthorizationActivity.md),[AverageBloodPressureOrganizer](StructureDefinition-AverageBloodPressureOrganizer.md),[BasicIndustryObservation](StructureDefinition-BasicIndustryObservation.md),[BasicOccupationObservation](StructureDefinition-BasicOccupationObservation.md),[BirthSexObservation](StructureDefinition-BirthSexObservation.md),[BrandNameObservation](StructureDefinition-BrandNameObservation.md),[CCDA](index.md),[CareExperiencePreference](StructureDefinition-CareExperiencePreference.md),[CarePlan](StructureDefinition-CarePlan.md),[CarePlanAct](StructureDefinition-CarePlanAct.md),[CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md),[CareTeamMemberScheduleObservation](StructureDefinition-CareTeamMemberScheduleObservation.md),[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[CareTeamTypeObservation](StructureDefinition-CareTeamTypeObservation.md),[CareTeamsSection](StructureDefinition-CareTeamsSection.md),[CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.md),[CatalogNumberObservation](StructureDefinition-CatalogNumberObservation.md),[CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md),[ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.md),[ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.md),[CommentActivity](StructureDefinition-CommentActivity.md),[CompanyNameObservation](StructureDefinition-CompanyNameObservation.md),[ComplicationsSection](StructureDefinition-ComplicationsSection.md),[ConsultationNote](StructureDefinition-ConsultationNote.md),[ContinuityofCareDocumentCCD](StructureDefinition-ContinuityofCareDocumentCCD.md),[CourseofCareSection](StructureDefinition-CourseofCareSection.md),[CoverageActivity](StructureDefinition-CoverageActivity.md),[CriticalityObservation](StructureDefinition-CriticalityObservation.md),[CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.md),[DateOfDiagnosisAct](StructureDefinition-DateOfDiagnosisAct.md),[DeceasedObservation](StructureDefinition-DeceasedObservation.md),[DeviceIdentifierObservation](StructureDefinition-DeviceIdentifierObservation.md),[DisabilityStatusObservation](StructureDefinition-DisabilityStatusObservation.md),[DischargeDiagnosisSection](StructureDefinition-DischargeDiagnosisSection.md),[DischargeMedication](StructureDefinition-DischargeMedication.md),[DischargeMedicationsSection](StructureDefinition-DischargeMedicationsSection.md),[DischargeSummary](StructureDefinition-DischargeSummary.md),[DistinctIdentificationCodeObservation](StructureDefinition-DistinctIdentificationCodeObservation.md),[DrugMonitoringAct](StructureDefinition-DrugMonitoringAct.md),[DrugVehicle](StructureDefinition-DrugVehicle.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.md),[EncountersSection](StructureDefinition-EncountersSection.md),[EntryReference](StructureDefinition-EntryReference.md),[EstimatedDateofDelivery](StructureDefinition-EstimatedDateofDelivery.md),[ExpirationDateObservation](StructureDefinition-ExpirationDateObservation.md),[ExternalDocumentReference](StructureDefinition-ExternalDocumentReference.md),[FamilyHistoryDeathObservation](StructureDefinition-FamilyHistoryDeathObservation.md),[FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md),[FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[FamilyHistorySection](StructureDefinition-FamilyHistorySection.md),[FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.md),[FunctionalStatusOrganizer](StructureDefinition-FunctionalStatusOrganizer.md),[FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md),[GenderIdentityObservation](StructureDefinition-GenderIdentityObservation.md),[GeneralStatusSection](StructureDefinition-GeneralStatusSection.md),[GoalObservation](StructureDefinition-GoalObservation.md),[GoalsSection](StructureDefinition-GoalsSection.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[HealthConcernAct](StructureDefinition-HealthConcernAct.md),[HealthConcernsSection](StructureDefinition-HealthConcernsSection.md),[HealthStatusObservation](StructureDefinition-HealthStatusObservation.md),[HighestPressureUlcerStage](StructureDefinition-HighestPressureUlcerStage.md),[HistoryandPhysical](StructureDefinition-HistoryandPhysical.md),[HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md),[HospitalAdmissionDiagnosis](StructureDefinition-HospitalAdmissionDiagnosis.md),[HospitalConsultationsSection](StructureDefinition-HospitalConsultationsSection.md),[HospitalCourseSection](StructureDefinition-HospitalCourseSection.md),[HospitalDischargeDiagnosis](StructureDefinition-HospitalDischargeDiagnosis.md),[HospitalDischargeInstructionsSection](StructureDefinition-HospitalDischargeInstructionsSection.md),[HospitalDischargePhysicalSection](StructureDefinition-HospitalDischargePhysicalSection.md),[HospitalDischargeStudiesSummarySection](StructureDefinition-HospitalDischargeStudiesSummarySection.md),[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[ImmunizationMedicationInformation](StructureDefinition-ImmunizationMedicationInformation.md),[ImmunizationNotGivenReason](StructureDefinition-ImmunizationNotGivenReason.md),[ImmunizationsSection](StructureDefinition-ImmunizationsSection.md),[ImplantableDeviceStatusObservation](StructureDefinition-ImplantableDeviceStatusObservation.md),[Indication](StructureDefinition-Indication.md),[IndividualPronounObservation](StructureDefinition-IndividualPronounObservation.md),[InstructionActivity](StructureDefinition-InstructionActivity.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[InstructionsSection](StructureDefinition-InstructionsSection.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md),[InterventionAct](StructureDefinition-InterventionAct.md),[LatexSafetyObservation](StructureDefinition-LatexSafetyObservation.md),[LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md),[LotOrBatchNumberObservation](StructureDefinition-LotOrBatchNumberObservation.md),[MRISafetyObservation](StructureDefinition-MRISafetyObservation.md),[ManufacturingDateObservation](StructureDefinition-ManufacturingDateObservation.md),[MedicalEquipmentOrganizer](StructureDefinition-MedicalEquipmentOrganizer.md),[MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.md),[MedicalGeneralHistorySection](StructureDefinition-MedicalGeneralHistorySection.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[MedicationDispense](StructureDefinition-MedicationDispense.md),[MedicationFreeTextSig](StructureDefinition-MedicationFreeTextSig.md),[MedicationInformation](StructureDefinition-MedicationInformation.md),[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md),[MedicationsAdministeredSection](StructureDefinition-MedicationsAdministeredSection.md),[MedicationsSection](StructureDefinition-MedicationsSection.md),[MentalStatusObservation](StructureDefinition-MentalStatusObservation.md),[MentalStatusOrganizer](StructureDefinition-MentalStatusOrganizer.md),[MentalStatusSection](StructureDefinition-MentalStatusSection.md),[ModelNumberObservation](StructureDefinition-ModelNumberObservation.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[NoteActivity](StructureDefinition-NoteActivity.md),[NotesSection](StructureDefinition-NotesSection.md),[NumberofPressureUlcersObservation](StructureDefinition-NumberofPressureUlcersObservation.md),[NutritionAssessment](StructureDefinition-NutritionAssessment.md),[NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[NutritionSection](StructureDefinition-NutritionSection.md),[NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md),[ObjectiveSection](StructureDefinition-ObjectiveSection.md),[OperativeNote](StructureDefinition-OperativeNote.md),[OperativeNoteFluidsSection](StructureDefinition-OperativeNoteFluidsSection.md),[OperativeNoteSurgicalProcedureSection](StructureDefinition-OperativeNoteSurgicalProcedureSection.md),[OutcomeObservation](StructureDefinition-OutcomeObservation.md),[OutcomesSection](StructureDefinition-OutcomesSection.md),[PastMedicalHistory](StructureDefinition-PastMedicalHistory.md),[PayersSection](StructureDefinition-PayersSection.md),[PhysicalExamSection](StructureDefinition-PhysicalExamSection.md),[PlannedCoverage](StructureDefinition-PlannedCoverage.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[PlannedProcedureSection](StructureDefinition-PlannedProcedureSection.md),[PlannedSupply](StructureDefinition-PlannedSupply.md),[PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md),[PolicyActivity](StructureDefinition-PolicyActivity.md),[PostoperativeDiagnosisSection](StructureDefinition-PostoperativeDiagnosisSection.md),[PostprocedureDiagnosis](StructureDefinition-PostprocedureDiagnosis.md),[PostprocedureDiagnosisSection](StructureDefinition-PostprocedureDiagnosisSection.md),[PreconditionforSubstanceAdministration](StructureDefinition-PreconditionforSubstanceAdministration.md),[PregnancyIntentionInNextYear](StructureDefinition-PregnancyIntentionInNextYear.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.md),[PreoperativeDiagnosisSection](StructureDefinition-PreoperativeDiagnosisSection.md),[PriorityPreference](StructureDefinition-PriorityPreference.md),[ProblemConcernAct](StructureDefinition-ProblemConcernAct.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ProblemSection](StructureDefinition-ProblemSection.md),[ProblemStatus](StructureDefinition-ProblemStatus.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ProcedureDescriptionSection](StructureDefinition-ProcedureDescriptionSection.md),[ProcedureDispositionSection](StructureDefinition-ProcedureDispositionSection.md),[ProcedureEstimatedBloodLossSection](StructureDefinition-ProcedureEstimatedBloodLossSection.md),[ProcedureFindingsSection](StructureDefinition-ProcedureFindingsSection.md),[ProcedureImplantsSection](StructureDefinition-ProcedureImplantsSection.md),[ProcedureIndicationsSection](StructureDefinition-ProcedureIndicationsSection.md),[ProcedureNote](StructureDefinition-ProcedureNote.md),[ProcedureSpecimensTakenSection](StructureDefinition-ProcedureSpecimensTakenSection.md),[ProceduresSection](StructureDefinition-ProceduresSection.md),[ProductInstance](StructureDefinition-ProductInstance.md),[PrognosisObservation](StructureDefinition-PrognosisObservation.md),[ProgressNote](StructureDefinition-ProgressNote.md),[ProgressTowardGoalObservation](StructureDefinition-ProgressTowardGoalObservation.md),[ProvenanceAssemblerParticipation](StructureDefinition-ProvenanceAssemblerParticipation.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[Reason](StructureDefinition-Reason.md),[ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.md),[ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.md),[ReferralAct](StructureDefinition-ReferralAct.md),[ReferralNote](StructureDefinition-ReferralNote.md),[RelatedPersonRelationshipAndNameParticipant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md),[ResultsSection](StructureDefinition-ResultsSection.md),[ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md),[RiskConcernAct](StructureDefinition-RiskConcernAct.md),[SectionTimeRangeObservation](StructureDefinition-SectionTimeRangeObservation.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md),[SensoryStatus](StructureDefinition-SensoryStatus.md),[SerialNumberObservation](StructureDefinition-SerialNumberObservation.md),[ServiceDeliveryLocation](StructureDefinition-ServiceDeliveryLocation.md),[SeverityObservation](StructureDefinition-SeverityObservation.md),[SexObservation](StructureDefinition-SexObservation.md),[SexParameterForClinicalUseObservation](StructureDefinition-SexParameterForClinicalUseObservation.md),[SexualOrientationObservation](StructureDefinition-SexualOrientationObservation.md),[SmokingStatus](StructureDefinition-SmokingStatus.md),[SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[SocialHistorySection](StructureDefinition-SocialHistorySection.md),[SpecimenCollectionProcedure](StructureDefinition-SpecimenCollectionProcedure.md),[SpecimenConditionObservation](StructureDefinition-SpecimenConditionObservation.md),[SubjectiveSection](StructureDefinition-SubjectiveSection.md),[SubstanceAdministeredAct](StructureDefinition-SubstanceAdministeredAct.md),[SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md),[SurgicalDrainsSection](StructureDefinition-SurgicalDrainsSection.md),[TobaccoUse](StructureDefinition-TobaccoUse.md),[TransferSummary](StructureDefinition-TransferSummary.md),[TreatmentInterventionPreference](StructureDefinition-TreatmentInterventionPreference.md),[TribalAffiliationObservation](StructureDefinition-TribalAffiliationObservation.md),[UDIOrganizer](StructureDefinition-UDIOrganizer.md),[USRealmAddress](StructureDefinition-USRealmAddress.md),[USRealmDateTime](StructureDefinition-USRealmDateTime.md),[USRealmDateTimeInterval](StructureDefinition-USRealmDateTimeInterval.md),[USRealmHeader](StructureDefinition-USRealmHeader.md),[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md),[USRealmPatientNamePTNUSFIELDED](StructureDefinition-USRealmPatientNamePTNUSFIELDED.md),[USRealmPersonNamePNUSFIELDED](StructureDefinition-USRealmPersonNamePNUSFIELDED.md),[UnstructuredDocument](StructureDefinition-UnstructuredDocument.md),[VitalSignObservation](StructureDefinition-VitalSignObservation.md),[VitalSignsOrganizer](StructureDefinition-VitalSignsOrganizer.md),[VitalSignsSection](StructureDefinition-VitalSignsSection.md),[WoundCharacteristic](StructureDefinition-WoundCharacteristic.md)and[WoundMeasurementObservation](StructureDefinition-WoundMeasurementObservation.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Patient Discharge Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCPatientDischargeStatus.html): [DischargeSummary](StructureDefinition-DischargeSummary.md) and [EncounterActivity](StructureDefinition-EncounterActivity.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/6.5.0/CodeSystem-CVX.html): [ImmunizationMedicationInformation](StructureDefinition-ImmunizationMedicationInformation.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.For information and exceptions regarding use of CDC material please see [https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html).

* [CDC Race and Ethnicity](http://terminology.hl7.org/6.5.0/CodeSystem-CDCREC.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-v3-ucum.html): [AgeObservation](StructureDefinition-AgeObservation.md), [AgeRangeObservation](StructureDefinition-AgeRangeObservation.md)...Show 7 more,[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[ResultObservation](StructureDefinition-ResultObservation.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md)and[VitalSignObservation](StructureDefinition-VitalSignObservation.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md), [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md)...Show 26 more,[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[CarePlan](StructureDefinition-CarePlan.md),[CareTeamTypeObservation](StructureDefinition-CareTeamTypeObservation.md),[ConsultationNote](StructureDefinition-ConsultationNote.md),[DischargeSummary](StructureDefinition-DischargeSummary.md),[FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md),[HistoryandPhysical](StructureDefinition-HistoryandPhysical.md),[Indication](StructureDefinition-Indication.md),[IndividualPronounObservation](StructureDefinition-IndividualPronounObservation.md),[NoteActivity](StructureDefinition-NoteActivity.md),[NotesSection](StructureDefinition-NotesSection.md),[OperativeNote](StructureDefinition-OperativeNote.md),[PhysicalExamSection](StructureDefinition-PhysicalExamSection.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ProcedureNote](StructureDefinition-ProcedureNote.md),[ProgressNote](StructureDefinition-ProgressNote.md),[ReferralNote](StructureDefinition-ReferralNote.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md),[SmokingStatus](StructureDefinition-SmokingStatus.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[TransferSummary](StructureDefinition-TransferSummary.md),[TreatmentInterventionPreference](StructureDefinition-TreatmentInterventionPreference.md),[VitalSignObservation](StructureDefinition-VitalSignObservation.md)and[WoundMeasurementObservation](StructureDefinition-WoundMeasurementObservation.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md), [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md)...Show 61 more,[AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md),[AllergyStatusObservation](StructureDefinition-AllergyStatusObservation.md),[AuthorParticipation](StructureDefinition-AuthorParticipation.md),[CarePlanAct](StructureDefinition-CarePlanAct.md),[CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md),[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md),[FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[GenderIdentityObservation](StructureDefinition-GenderIdentityObservation.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[HealthStatusObservation](StructureDefinition-HealthStatusObservation.md),[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[Indication](StructureDefinition-Indication.md),[InstructionActivity](StructureDefinition-InstructionActivity.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md),[LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[MedicationInformation](StructureDefinition-MedicationInformation.md),[MentalStatusObservation](StructureDefinition-MentalStatusObservation.md),[NoteActivity](StructureDefinition-NoteActivity.md),[NumberofPressureUlcersObservation](StructureDefinition-NumberofPressureUlcersObservation.md),[NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md),[OperativeNote](StructureDefinition-OperativeNote.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[PreconditionforSubstanceAdministration](StructureDefinition-PreconditionforSubstanceAdministration.md),[PregnancyIntentionInNextYear](StructureDefinition-PregnancyIntentionInNextYear.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[PriorityPreference](StructureDefinition-PriorityPreference.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ProblemStatus](StructureDefinition-ProblemStatus.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ProductInstance](StructureDefinition-ProductInstance.md),[ProgressTowardGoalObservation](StructureDefinition-ProgressTowardGoalObservation.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[ReferralAct](StructureDefinition-ReferralAct.md),[RelatedPersonRelationshipAndNameParticipant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md),[SensoryStatus](StructureDefinition-SensoryStatus.md),[ServiceDeliveryLocation](StructureDefinition-ServiceDeliveryLocation.md),[SeverityObservation](StructureDefinition-SeverityObservation.md),[SexObservation](StructureDefinition-SexObservation.md),[SexualOrientationObservation](StructureDefinition-SexualOrientationObservation.md),[SmokingStatus](StructureDefinition-SmokingStatus.md),[SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[SpecimenCollectionProcedure](StructureDefinition-SpecimenCollectionProcedure.md),[SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md),[TobaccoUse](StructureDefinition-TobaccoUse.md),[USRealmHeader](StructureDefinition-USRealmHeader.md),[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md)and[WoundCharacteristic](StructureDefinition-WoundCharacteristic.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [DataAbsentReason](http://terminology.hl7.org/7.0.1/CodeSystem-data-absent-reason.html): [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md), [BirthSexObservation](StructureDefinition-BirthSexObservation.md)...Show 6 more,[GenderIdentityObservation](StructureDefinition-GenderIdentityObservation.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md),[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[SexParameterForClinicalUseObservation](StructureDefinition-SexParameterForClinicalUseObservation.md),[SexualOrientationObservation](StructureDefinition-SexualOrientationObservation.md)and[USRealmHeader](StructureDefinition-USRealmHeader.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [ResultObservation](StructureDefinition-ResultObservation.md)
* [Sex Parameter For Clinical Use](http://terminology.hl7.org/7.0.1/CodeSystem-sex-parameter-for-clinical-use.html): [SexParameterForClinicalUseObservation](StructureDefinition-SexParameterForClinicalUseObservation.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0074.html): [ResultOrganizer](StructureDefinition-ResultOrganizer.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [ResultObservation](StructureDefinition-ResultObservation.md), [ResultOrganizer](StructureDefinition-ResultOrganizer.md) and [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [ActMood](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActMood.html): [CarePlanAct](StructureDefinition-CarePlanAct.md), [ImmunizationActivity](StructureDefinition-ImmunizationActivity.md)...Show 11 more,[MedicationActivity](StructureDefinition-MedicationActivity.md),[MedicationFreeTextSig](StructureDefinition-MedicationFreeTextSig.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[PlannedSupply](StructureDefinition-PlannedSupply.md)and[ReferralAct](StructureDefinition-ReferralAct.md)
* [ActPriority](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActPriority.html): [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) and [ReferralAct](StructureDefinition-ReferralAct.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [ImmunizationNotGivenReason](StructureDefinition-ImmunizationNotGivenReason.md)
* [ActRelationshipType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActRelationshipType.html): [CarePlan](StructureDefinition-CarePlan.md)
* [ActStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActStatus.html): [AllergyConcernAct](StructureDefinition-AllergyConcernAct.md), [CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md)...Show 16 more,[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md),[DrugMonitoringAct](StructureDefinition-DrugMonitoringAct.md),[GoalObservation](StructureDefinition-GoalObservation.md),[HealthConcernAct](StructureDefinition-HealthConcernAct.md),[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[MedicalEquipmentOrganizer](StructureDefinition-MedicalEquipmentOrganizer.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[ProblemConcernAct](StructureDefinition-ProblemConcernAct.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md),[ReferralAct](StructureDefinition-ReferralAct.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md),[RiskConcernAct](StructureDefinition-RiskConcernAct.md)and[SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md)
* [AddressUse](http://terminology.hl7.org/7.0.1/CodeSystem-v3-AddressUse.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [AdministrativeGender](http://terminology.hl7.org/7.0.1/CodeSystem-v3-AdministrativeGender.html): [BirthSexObservation](StructureDefinition-BirthSexObservation.md)
* [Confidentiality](http://terminology.hl7.org/7.0.1/CodeSystem-v3-Confidentiality.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [EntityNamePartQualifier](http://tx.fhir.org/r5/ValueSet/v3-EntityNamePartQualifier): [USRealmPatientNamePTNUSFIELDED](StructureDefinition-USRealmPatientNamePTNUSFIELDED.md)
* [LanguageAbilityMode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-LanguageAbilityMode.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [LanguageAbilityProficiency](http://terminology.hl7.org/7.0.1/CodeSystem-v3-LanguageAbilityProficiency.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [MaritalStatus](http://tx.fhir.org/r5/ValueSet/v3-MaritalStatus): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [BirthSexObservation](StructureDefinition-BirthSexObservation.md), [GenderIdentityObservation](StructureDefinition-GenderIdentityObservation.md)...Show 5 more,[NoteActivity](StructureDefinition-NoteActivity.md),[NotesSection](StructureDefinition-NotesSection.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[SexualOrientationObservation](StructureDefinition-SexualOrientationObservation.md)and[USRealmHeader](StructureDefinition-USRealmHeader.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [ResultObservation](StructureDefinition-ResultObservation.md)
* [ObservationValue](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationValue.html): [CriticalityObservation](StructureDefinition-CriticalityObservation.md)
* [ParticipationFunction](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationFunction.html): [CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md), [CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md)...Show 4 more,[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[OperativeNote](StructureDefinition-OperativeNote.md),[USRealmHeader](StructureDefinition-USRealmHeader.md)and[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [Religious Affiliation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ReligiousAffiliation.html): [USRealmHeader](StructureDefinition-USRealmHeader.md)
* [RoleClass](http://tx.fhir.org/r5/ValueSet/v3-RoleClass): [CarePlan](StructureDefinition-CarePlan.md), [DischargeSummary](StructureDefinition-DischargeSummary.md), [PolicyActivity](StructureDefinition-PolicyActivity.md), [ReferralNote](StructureDefinition-ReferralNote.md) and [TransferSummary](StructureDefinition-TransferSummary.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md), [CarePlan](StructureDefinition-CarePlan.md)...Show 7 more,[FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[PolicyActivity](StructureDefinition-PolicyActivity.md),[ProvenanceAuthorParticipation](StructureDefinition-ProvenanceAuthorParticipation.md),[RelatedPersonRelationshipAndNameParticipant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[USRealmHeader](StructureDefinition-USRealmHeader.md)and[USRealmHeaderforPatientGeneratedDocument](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md)
* [TribalEntityUS](http://terminology.hl7.org/7.0.1/CodeSystem-v3-TribalEntityUS.html): [TribalAffiliationObservation](StructureDefinition-TribalAffiliationObservation.md)
* [Media Type](http://terminology.hl7.org/7.0.1/CodeSystem-v3-mediaType.html): [NoteActivity](StructureDefinition-NoteActivity.md) and [UnstructuredDocument](StructureDefinition-UnstructuredDocument.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core Category](http://hl7.org/fhir/us/core/2026Jan/CodeSystem-us-core-category.html): [PlannedProcedure](StructureDefinition-PlannedProcedure.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md), [MedicationInformation](StructureDefinition-MedicationInformation.md) and [SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md)


### Expansion Parameters

* Parameter: system-version
  * Value: SNOMED CT[US]

