# Vital Sign Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vital Sign Observation**

## Logical Model: Vital Sign Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:VitalSignObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.27:2014-06-09 | |

 
This template represents measurement of common vital signs. Vital signs are represented with additional vocabulary constraints for type of vital sign and unit of measure. 
The following is a list of recommended units for common types of vital sign measurements: 

| | |
| :--- | :--- |
| PulseOx | % |
| Height/Head Circumf | cm |
| Weight | kg |
| Temp | Cel |
| BP | mm[Hg] |
| Pulse/Resp Rate | /min |
| BMI | kg/m2 |
| BSA | m2 |
| inhaled oxygen concentration | % |
| Occipital Front Head Circumference Percentile (Birth -36 months) | % |

 

**Usages:**

* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Risk Concern Act](StructureDefinition-RiskConcernAct.md) and [Vital Signs Organizer](StructureDefinition-VitalSignsOrganizer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/VitalSignObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-VitalSignObservation.csv), [Excel](StructureDefinition-VitalSignObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "VitalSignObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.27:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "VitalSignObservation",
  "title" : "Vital Sign Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents measurement of common vital signs. Vital signs are represented with additional vocabulary constraints for type of vital sign and unit of measure.\n\nThe following is a list of recommended units for common types of vital sign measurements:\n\n| Name | Unit |\n| -------- | ------- |\n| PulseOx | % |\n| Height/Head Circumf | cm |\n| Weight | kg |\n| Temp | Cel |\n| BP | mm[Hg] |\n| Pulse/Resp Rate | /min |\n| BMI | kg/m2 |\n| BSA | m2 |\n| inhaled oxygen concentration | % |\n| Occipital Front Head Circumference Percentile (Birth -36 months) | % |\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-percent",
            "severity" : "warning",
            "human" : "Percentage codes (PulseOx, O2 Concentration, Percentiles) should be represented with %",
            "expression" : "(code.code in ('2708-6' | '3150-0' | '59408-5' | '8289-1' | '59575-1' | '59576-9')) implies value.unit = '%'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-cm",
            "severity" : "warning",
            "human" : "Height & Head Circumference should be represented in cm",
            "expression" : "(code.code in ('8287-5' | '8302-2' | '8306-3' | '9843-4')) implies value.unit = 'cm'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-kg",
            "severity" : "warning",
            "human" : "Weight should be represented in kg",
            "expression" : "(code.code = '29463-7') implies value.unit = 'kg'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-cel",
            "severity" : "warning",
            "human" : "Temperature should be represented in Celcius (Cel)",
            "expression" : "(code.code = '8310-5') implies value.unit = 'Cel'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-bp",
            "severity" : "warning",
            "human" : "Blood pressure should be represented in mm[Hg]",
            "expression" : "(code.code in ('8480-6' | '8462-4' | '8478-0' | '96608-5' | '96609-3')) implies value.unit = 'mm[Hg]'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-rates",
            "severity" : "warning",
            "human" : "Rates should be represented in /min",
            "expression" : "(code.code in ('8867-4' | '9279-1')) implies value.unit = '/min'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-bmi",
            "severity" : "warning",
            "human" : "BMI should be represented in kg/m2",
            "expression" : "(code.code = '39156-5') implies value.unit = 'kg/m2'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "key" : "should-bsa",
            "severity" : "warning",
            "human" : "BSA should be represented in m2",
            "expression" : "(code.code = '3140-1') implies value.unit = 'm2'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:vital-sign-obs",
        "path" : "Observation.templateId",
        "sliceName" : "vital-sign-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:vital-sign-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.27"
      },
      {
        "id" : "Observation.templateId:vital-sign-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-7297).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1098-7298).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-7300).",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "SHOULD contain code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-7301).",
        "condition" : ["should-code"]
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHOULD contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Vital Sign Result Type urn:oid:2.16.840.1.113883.3.88.12.80.62 DYNAMIC (CONF:1098-32934).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.62"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-7303).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1098-19119).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-7304).",
        "min" : 1
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"PQ\" (CONF:1098-7305).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PQ"
          }
        ]
      },
      {
        "id" : "Observation.value.unit",
        "path" : "Observation.value.unit",
        "short" : "NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "comment" : "This value SHALL contain exactly one [1..1] @unit, which SHALL be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC (CONF:1098-31579).  Use a default of 1 for @unit when @nullFlavor is present.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "Observation.interpretationCode",
        "path" : "Observation.interpretationCode",
        "comment" : "MAY contain zero or one [0..1] interpretationCode (CONF:1098-7307).",
        "max" : "1"
      },
      {
        "id" : "Observation.methodCode",
        "path" : "Observation.methodCode",
        "comment" : "MAY contain zero or one [0..1] methodCode (CONF:1098-7308).",
        "max" : "1"
      },
      {
        "id" : "Observation.targetSiteCode",
        "path" : "Observation.targetSiteCode",
        "comment" : "MAY contain zero or one [0..1] targetSiteCode (CONF:1098-7309).",
        "max" : "1"
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-7310).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      }
    ]
  }
}

```
