# Unstructured Document - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Unstructured Document**

## Logical Model: Unstructured Document 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:UnstructuredDocument |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.10:2024-05-01 | |

 
An Unstructured Document (UD) document type can (1) include unstructured content, such as a graphic, directly in a text element with a mediaType attribute, or (2) reference a single document file, such as a word-processing document using a text/reference element. 
For guidance on how to handle multiple files, on the selection of media types for this IG, and on the identification of external files, see the examples that follow the constraints below. 
IHEs XDS-SD (Cross-Transaction Specifications and Content Specifications, Scanned Documents Module) profile addresses a similar, more restricted use case, specifically for scanned documents or documents electronically created from existing text sources, and limits content to PDF-A or text. This Unstructured Documents template is applicable not only for scanned documents in non-PDF formats, but also for clinical documents produced through word processing applications, etc. 
For conformance with both specifications, implementers need to ensure that their documents at a minimum conform with the SHALL constraints from either specification. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/UnstructuredDocument)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-UnstructuredDocument.csv), [Excel](StructureDefinition-UnstructuredDocument.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "UnstructuredDocument",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.10:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "UnstructuredDocument",
  "title" : "Unstructured Document",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "An Unstructured Document (UD) document type can (1) include unstructured content, such as a graphic, directly in a text element with a mediaType attribute, or (2) reference a single document file, such as a word-processing document using a text/reference element.\n\nFor guidance on how to handle multiple files, on the selection of media types for this IG, and on the identification of external files, see the examples that follow the constraints below.\n\nIHEs XDS-SD (Cross-Transaction Specifications and Content Specifications, Scanned Documents Module) profile addresses a similar, more restricted use case, specifically for scanned documents or documents electronically created from existing text sources, and limits content to PDF-A or text. This Unstructured Documents template is applicable not only for scanned documents in non-PDF formats, but also for clinical documents produced through word processing applications, etc. \n\nFor conformance with both specifications, implementers need to ensure that their documents at a minimum conform with the SHALL constraints from either specification.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument"
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:unstructured-doc",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "unstructured-doc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:unstructured-doc.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.10"
      },
      {
        "id" : "ClinicalDocument.templateId:unstructured-doc.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.recordTarget",
        "path" : "ClinicalDocument.recordTarget",
        "comment" : "SHALL contain at least one [1..*] recordTarget (CONF:1198-31089)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole",
        "path" : "ClinicalDocument.recordTarget.patientRole",
        "comment" : "Such recordTargets SHALL contain exactly one [1..1] patientRole (CONF:1198-31090)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.id",
        "comment" : "This patientRole SHALL contain at least one [1..*] id (CONF:1198-31091)."
      },
      {
        "id" : "ClinicalDocument.custodian",
        "path" : "ClinicalDocument.custodian",
        "comment" : "SHALL contain exactly one [1..1] custodian (CONF:1198-31096)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian",
        "path" : "ClinicalDocument.custodian.assignedCustodian",
        "comment" : "This custodian SHALL contain exactly one [1..1] assignedCustodian (CONF:1198-31097)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "comment" : "This assignedCustodian SHALL contain exactly one [1..1] representedCustodianOrganization (CONF:1198-31098)."
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-31085)."
      },
      {
        "id" : "ClinicalDocument.component.nonXMLBody",
        "path" : "ClinicalDocument.component.nonXMLBody",
        "short" : "An Unstructured Document must include a nonXMLBody component with a single text element. The text element can reference an external file using a reference element, or include unstructured content directly with a mediaType attribute. The nonXMLBody/text element also has a \"compression\" attribute that can be used to indicate that the unstructured content was compressed before being Base64Encoded. At a minimum, a compression value of \"DF\" for the deflate compression algorithm (RFC 1951 [URL:http://www.ietf.org/rfc/rfc1951.txt]) must be supported although it is not required that content be compressed.",
        "comment" : "This component SHALL contain exactly one [1..1] nonXMLBody (CONF:1198-31086).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.component.nonXMLBody.text",
        "path" : "ClinicalDocument.component.nonXMLBody.text",
        "comment" : "This nonXMLBody SHALL contain exactly one [1..1] text (CONF:1198-31087).",
        "constraint" : [
          {
            "key" : "1198-7624",
            "severity" : "error",
            "human" : "If the text element does not contain a reference element with a value attribute, then it **SHALL** contain exactly one [1..1] @representation=\"B64\" and exactly one [1..1] @mediaType (CONF:1198-7624).",
            "expression" : "reference.value.empty() implies (representation = 'B64' and mediaType.exists())",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.nonXMLBody.text.mediaType",
        "path" : "ClinicalDocument.component.nonXMLBody.text.mediaType",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.7.1"
        }
      }
    ]
  }
}

```
