# US Realm Patient Name (PTN.US.FIELDED) - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Patient Name (PTN.US.FIELDED)**

## Logical Model: US Realm Patient Name (PTN.US.FIELDED) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmPatientNamePTNUSFIELDED |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.1 | |

 
The US Realm Patient Name datatype flavor is a set of reusable constraints that can be used for the patient or any other person. It requires a first (given) and last (family) name. If a patient or person has only one name part (e.g., patient with first name only) place the name part in the field required by the organization. Use the appropriate nullFlavor, "Not Applicable" (NA), in the other field. 
For information on mixed content see the Extensible Markup Language reference (http://www.w3c.org/TR/2008/REC-xml-20081126/). 

**Usages:**

* Use this Logical Model Profile: [US Realm Header](StructureDefinition-USRealmHeader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmPatientNamePTNUSFIELDED)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmPatientNamePTNUSFIELDED.csv), [Excel](StructureDefinition-USRealmPatientNamePTNUSFIELDED.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmPatientNamePTNUSFIELDED",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "name"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.1"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmPatientNamePTNUSFIELDED",
  "title" : "US Realm Patient Name (PTN.US.FIELDED)",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The US Realm Patient Name datatype flavor is a set of reusable constraints that can be used for the patient or any other person. It requires a first (given) and last (family) name. If a patient or person has only one name part (e.g., patient with first name only) place the name part in the field required by the organization. Use the appropriate nullFlavor, \"Not Applicable\" (NA), in the other field.\n\nFor information on mixed content see the Extensible Markup Language reference (http://www.w3c.org/TR/2008/REC-xml-20081126/).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PN",
        "path" : "PN",
        "constraint" : [
          {
            "key" : "shall-family",
            "severity" : "error",
            "human" : "SHALL contain exactly one [1..1] family (CONF:81-7159).",
            "expression" : "nullFlavor.exists() or item.family.count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED"
          },
          {
            "key" : "shall-given",
            "severity" : "error",
            "human" : "SHALL contain at least one [1..*] given (CONF:81-7157).",
            "expression" : "nullFlavor.exists() or item.given.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED"
          },
          {
            "key" : "shall-max-suffix",
            "severity" : "error",
            "human" : "There may be at most one suffix",
            "expression" : "(item.suffix.empty() or item.suffix.count() = 1)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED"
          },
          {
            "key" : "81-7278",
            "severity" : "error",
            "human" : "**SHALL NOT** have mixed content except for white space (CONF:81-7278).",
            "expression" : "item.xmlText.empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED"
          }
        ]
      },
      {
        "id" : "PN.use",
        "path" : "PN.use",
        "short" : "If name/@nullFlavor is present, the remaining conformance statements *SHALL NOT* be enforced",
        "comment" : "MAY contain zero or one [0..1] @use, which SHALL be selected from ValueSet EntityNameUse urn:oid:2.16.840.1.113883.1.11.15913 STATIC 2005-05-01 (CONF:81-7154).",
        "max" : "1"
      },
      {
        "id" : "PN.item.family",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "PN.item.family",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Last Name"
      },
      {
        "id" : "PN.item.family.qualifier",
        "path" : "PN.item.family.qualifier",
        "comment" : "This family MAY contain zero or one [0..1] @qualifier, which SHALL be selected from ValueSet EntityPersonNamePartQualifier urn:oid:2.16.840.1.113883.11.20.9.26 STATIC 2011-09-30 (CONF:81-7160).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.26"
        }
      },
      {
        "id" : "PN.item.given",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "PN.item.given",
        "short" : "𝗨𝗦𝗖𝗗𝗜: First Name / Middle Name",
        "comment" : "SHALL contain at least one [1..*] given (CONF:81-7157)."
      },
      {
        "id" : "PN.item.given.qualifier",
        "path" : "PN.item.given.qualifier",
        "comment" : "Such givens MAY contain zero or one [0..1] @qualifier, which SHALL be selected from ValueSet EntityPersonNamePartQualifier urn:oid:2.16.840.1.113883.11.20.9.26 STATIC 2011-09-30 (CONF:81-7158).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.26"
        }
      },
      {
        "id" : "PN.item.prefix",
        "path" : "PN.item.prefix",
        "comment" : "MAY contain zero or more [0..*] prefix (CONF:81-7155)."
      },
      {
        "id" : "PN.item.prefix.qualifier",
        "path" : "PN.item.prefix.qualifier",
        "comment" : "The prefix, if present, MAY contain zero or one [0..1] @qualifier, which SHALL be selected from ValueSet EntityPersonNamePartQualifier urn:oid:2.16.840.1.113883.11.20.9.26 STATIC 2011-09-30 (CONF:81-7156).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.26"
        }
      },
      {
        "id" : "PN.item.suffix",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "PN.item.suffix",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Suffix",
        "comment" : "MAY contain zero or one [0..1] suffix (CONF:81-7161)."
      },
      {
        "id" : "PN.item.suffix.qualifier",
        "path" : "PN.item.suffix.qualifier",
        "comment" : "The suffix, if present, MAY contain zero or one [0..1] @qualifier, which SHALL be selected from ValueSet EntityPersonNamePartQualifier urn:oid:2.16.840.1.113883.11.20.9.26 STATIC 2011-09-30 (CONF:81-7162).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.26"
        }
      },
      {
        "id" : "PN.validTime",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "PN.validTime",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Previous Name - Available for use to identify the time period when name was/is in use."
      }
    ]
  }
}

```
