# US Realm Header for Patient Generated Document - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Header for Patient Generated Document**

## Logical Model: US Realm Header for Patient Generated Document 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:USRealmHeaderforPatientGeneratedDocument |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.29.1:2024-05-01 | |

 
This template focuses on the patient or related person in the roles of author and other participants and is designed to be used in conjunction with the US Realm Header. It includes additional conformances which further constrain the US Realm Header. The Patient Generated Document Header template is not a separate document type. The document body may contain any structured or unstructured content from C-CDA. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmHeaderforPatientGeneratedDocument)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.csv), [Excel](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmHeaderforPatientGeneratedDocument",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.29.1:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmHeaderforPatientGeneratedDocument",
  "title" : "US Realm Header for Patient Generated Document",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template focuses on the patient or related person in the roles of author and other participants and is designed to be used in conjunction with the US Realm Header. It includes additional conformances which further constrain the US Realm Header. \nThe Patient Generated Document Header template is not a separate document type. The document body may contain any structured or unstructured content from C-CDA.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument"
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:us-patient-gen-doc",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "us-patient-gen-doc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-patient-gen-doc.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.29.1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-patient-gen-doc.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.recordTarget",
        "path" : "ClinicalDocument.recordTarget",
        "short" : "The recordTarget records the patient whose health information is described by the clinical document; each recordTarget must contain at least one patientRole element. \n\nIf the document receiver is interested in setting up a translator for the encounter with the patient, the receiver of the document will have to infer the need for a translator, based upon the language skills identified for the patient, the patient's language of preference and the predominant language used by the organization receiving the CDA.\n\nHL7 Vocabulary simply describes guardian as a relationship to a ward.  This need not be a formal legal relationship. When a guardian relationship exists for the patient, it can be represented, regardless of who is present at the time the document is generated. This need not be a formal legal relationship. A child's parent can be represented in the guardian role.  In this case, the guardian/code element would encode the personal relationship of \"mother\" for the child's mom or \"father\" for the child's dad. An elderly person's child can be represented in the guardian role. In this case, the guardian/code element would encode the personal relationship of \"daughter\" or \"son\", or if a legal relationship existed, the relationship of \"legal guardian\" could be encoded.",
        "comment" : "SHALL contain exactly one [1..1] recordTarget (CONF:1198-28460).",
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole",
        "path" : "ClinicalDocument.recordTarget.patientRole",
        "comment" : "This recordTarget SHALL contain exactly one [1..1] patientRole (CONF:1198-28461)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.id",
        "comment" : "This patientRole SHALL contain at least one [1..*] id (CONF:1198-28462)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient",
        "comment" : "This patientRole SHALL contain exactly one [1..1] patient (CONF:1198-28465).",
        "constraint" : [
          {
            "key" : "should-languageCommunication",
            "severity" : "warning",
            "human" : "SHOULD contain languageCommunication",
            "expression" : "languageCommunication.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "comment" : "This patient MAY contain zero or more [0..*] guardian (CONF:1198-28469).",
        "constraint" : [
          {
            "key" : "should-id",
            "severity" : "warning",
            "human" : "SHOULD contain id",
            "expression" : "id.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          },
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.id",
        "comment" : "The guardian, if present, SHOULD contain zero or more [0..*] id (CONF:1198-28470)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "comment" : "The guardian, if present, SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28473)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "comment" : "This patient SHOULD contain zero or more [0..*] languageCommunication which SHALL be selected from ValueSet AllLanguages https://www.hl7.org/fhir/valueset-all-languages.html (OID 2.16.840.1.113883.4.642.3.21) DYNAMIC (CONF:XXX)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/all-languages"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.preferenceInd",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.preferenceInd",
        "short" : "Indicates a preference for information about care delivery and treatments be communicated (or translated if needed) into this language.\n\nIf more than one languageCommunication is present, only one languageCommunication element SHALL have a preferenceInd with a value of 1.",
        "comment" : "The languageCommunication, if present, MAY contain zero or one [0..1] preferenceInd (CONF:1198-28475)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "label" : "If present, this organization represents the provider organization where the person is claiming to be a patient.",
        "short" : "If present, this organization represents the provider organization where the person is claiming to be a patient.",
        "comment" : "This patientRole MAY contain zero or one [0..1] providerOrganization (CONF:1198-28476)."
      },
      {
        "id" : "ClinicalDocument.author",
        "path" : "ClinicalDocument.author",
        "short" : "The author element represents the creator of the clinical document.  The author may be a device, or a person. The person is the patient or the patient's advocate.",
        "comment" : "SHALL contain at least one [1..*] author (CONF:1198-28477)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor",
        "path" : "ClinicalDocument.author.assignedAuthor",
        "comment" : "Such authors SHALL contain exactly one [1..1] assignedAuthor (CONF:1198-28478).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id",
        "path" : "ClinicalDocument.author.assignedAuthor.id",
        "comment" : "This assignedAuthor SHALL contain at least one [1..*] id (CONF:1198-28479)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code",
        "short" : "When the author is a person who is not acting in the role of a clinician, this code encodes the personal or legal relationship between author and the patient.",
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] code (CONF:1198-28481)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.dataEnterer",
        "path" : "ClinicalDocument.dataEnterer",
        "short" : "The dataEnterer element represents the person who transferred the content, written or dictated by someone else, into the clinical document. The guiding rule of thumb is that an author provides the content found within the header or body of the document, subject to their own interpretation, and the dataEnterer adds that information to the electronic system. In other words, a dataEnterer transfers information from one source to another (e.g., transcription from paper form to electronic system). If the dataEnterer is missing, this role is assumed to be played by the author.",
        "comment" : "MAY contain zero or one [0..1] dataEnterer (CONF:1198-28678)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity",
        "comment" : "The dataEnterer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-28679)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28680).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.informant:non-provider",
        "path" : "ClinicalDocument.informant",
        "sliceName" : "non-provider"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.relatedEntity",
        "path" : "ClinicalDocument.informant.relatedEntity",
        "comment" : "SHALL contain exactly one [1..1] relatedEntity (CONF:1198-28682)."
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.relatedEntity.code",
        "path" : "ClinicalDocument.informant.relatedEntity.code",
        "comment" : "This relatedEntity MAY contain zero or one [0..1] code (CONF:1198-28683).",
        "constraint" : [
          {
            "key" : "should-us-code-attr",
            "severity" : "warning",
            "human" : "SHOULD contain @code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.relatedEntity.code.code",
        "path" : "ClinicalDocument.informant.relatedEntity.code.code",
        "comment" : "The code, if present, SHOULD contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28684).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.custodian",
        "path" : "ClinicalDocument.custodian",
        "short" : "The custodian element represents the organization or person that is in charge of maintaining the document. The custodian is the steward that is entrusted with the care of the document. Every CDA document has exactly one custodian. The custodian participation satisfies the CDA definition of Stewardship. Because CDA is an exchange standard and may not represent the original form of the authenticated document (e.g., CDA could include scanned copy of original), the custodian represents the steward of the original source document. The custodian may be the document originator, a health information exchange, or other responsible party. Also, the custodian may be the patient or an organization acting on behalf of the patient, such as a PHR organization.",
        "comment" : "SHALL contain exactly one [1..1] custodian (CONF:1198-28685)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian",
        "path" : "ClinicalDocument.custodian.assignedCustodian",
        "comment" : "This custodian SHALL contain exactly one [1..1] assignedCustodian (CONF:1198-28686)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "short" : "The representedCustodianOrganization may be the person when the document is not maintained by an organization.",
        "comment" : "This assignedCustodian SHALL contain exactly one [1..1] representedCustodianOrganization (CONF:1198-28687)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "short" : "The combined @root and @extension attributes record the custodian organization's identity in a secure, trusted, and unique way.",
        "comment" : "This representedCustodianOrganization SHALL contain at least one [1..*] id (CONF:1198-28688)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "short" : "The informationRecipient element records the intended recipient of the information at the time the document is created. For example, in cases where the intended recipient of the document is the patient's health chart, set the receivedOrganization to be the scoping organization for that chart.",
        "comment" : "MAY contain zero or more [0..*] informationRecipient (CONF:1198-28690)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "The informationRecipient, if present, SHALL contain exactly one [1..1] intendedRecipient (CONF:1198-28691).",
        "constraint" : [
          {
            "key" : "should-id",
            "severity" : "warning",
            "human" : "SHOULD contain id",
            "expression" : "id.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "short" : "The combined @root and @extension  attributes to record the information recipient's identity in a secure, trusted, and unique way.",
        "comment" : "This intendedRecipient SHOULD contain zero or more [0..*] id (CONF:1198-28692).",
        "constraint" : [
          {
            "key" : "should-root",
            "severity" : "warning",
            "human" : "SHOULD contain @root",
            "expression" : "root.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.id.root",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.id.root",
        "short" : "For a provider, the id/@root =\"2.16.840.1.113883.4.6\" indicates the National Provider Identifier where id/@extension is the NPI number for the provider.\n\nThe ids MAY reference the id of a person or organization entity specified elsewhere in the document.",
        "comment" : "The id, if present, SHOULD contain zero or one [0..1] @root (CONF:1198-28693)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator",
        "path" : "ClinicalDocument.legalAuthenticator",
        "short" : "In a patient authored document, the legalAuthenticator identifies the single person legally responsible for the document and must be present if the document has been legally authenticated. (Note that per the following section, there may also be one or more document authenticators.) \n\nBased on local practice, patient authored documents may be provided without legal authentication. This implies that a patient authored document that does not contain this element has not been legally authenticated.\n\nThe act of legal authentication requires a certain privilege be granted to the legal authenticator depending upon local policy. All patient documents have the potential for legal authentication, given the appropriate legal authority.\n\nLocal policies MAY choose to delegate the function of legal authentication to a device or system that generates the document. In these cases, the legal authenticator is the person accepting responsibility for the document, not the generating device or system.\n\nNote that the legal authenticator, if present, must be a person.",
        "comment" : "MAY contain zero or one [0..1] legalAuthenticator (CONF:1198-28694)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-28695)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "short" : "The combined @root and @extension  attributes to record the information recipient's identity in a secure, trusted, and unique way.",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:1198-28696)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.code",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code (CONF:1198-28697)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.code.code",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.code.code",
        "comment" : "The code, if present, MAY contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28698).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.authenticator",
        "path" : "ClinicalDocument.authenticator",
        "comment" : "MAY contain zero or more [0..*] authenticator (CONF:1198-28699)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity",
        "path" : "ClinicalDocument.authenticator.assignedEntity",
        "comment" : "The authenticator, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-28700).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.id",
        "path" : "ClinicalDocument.authenticator.assignedEntity.id",
        "short" : "The combined @root and @extension  attributes to record the authenticator's identity in a secure, trusted, and unique way.",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:1198-28701)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28702).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "The participant element identifies other supporting participants, including parents, relatives, caregivers, insurance policyholders, guarantors, and other participants related in some way to the patient. \n\nA supporting person or organization is an individual or an organization with a relationship to the patient. A supporting person who is playing multiple roles would be recorded in multiple participants (e.g., emergency contact and next-of-kin)",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1198-28703)."
      },
      {
        "id" : "ClinicalDocument.participant.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "short" : "Unless otherwise specified by the document specific header constraints, when participant/@typeCode is IND, associatedEntity/@classCode SHALL be selected from ValueSet 2.16.840.1.113883.11.20.9.33 INDRoleclassCodes STATIC 2011-09-30",
        "comment" : "The participant, if present, SHALL contain exactly one [1..1] @typeCode (CONF:1198-28704)."
      },
      {
        "id" : "ClinicalDocument.participant.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "The participant, if present, SHALL contain exactly one [1..1] associatedEntity (CONF:1198-28705).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant.associatedEntity.code",
        "path" : "ClinicalDocument.participant.associatedEntity.code",
        "comment" : "This associatedEntity SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28706).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.participant.associatedEntity.sdtcSpecialty",
        "path" : "ClinicalDocument.participant.associatedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "comment" : "MAY contain zero or more [0..*] inFulfillmentOf (CONF:1198-28707)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order",
        "path" : "ClinicalDocument.inFulfillmentOf.order",
        "comment" : "The inFulfillmentOf, if present, SHALL contain exactly one [1..1] order (CONF:1198-28708)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order.id",
        "path" : "ClinicalDocument.inFulfillmentOf.order.id",
        "short" : "A scheduled appointment or service event in a practice management system may be represented using this id element.",
        "comment" : "This order SHALL contain at least one [1..*] id (CONF:1198-28709)."
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "comment" : "MAY contain zero or more [0..*] documentationOf (CONF:1198-28710)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "comment" : "The documentationOf, if present, SHALL contain exactly one [1..1] serviceEvent (CONF:1198-28711).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          },
          {
            "key" : "should-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "short" : "The code should be selected from a value set established by the document-level template for a specific type of Patient Generated Document.",
        "comment" : "This serviceEvent SHOULD contain zero or one [0..1] code (CONF:1198-28712)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "short" : "SHOULD contain performer",
        "comment" : "This serviceEvent SHOULD contain zero or more [0..*] performer (CONF:1198-28713).",
        "condition" : ["should-performer"]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "short" : "When indicating the performer was the primary care physician, implementers should indicate \"PCP\" as the functionCode"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-28715)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "short" : "The combined @root and @extension  attributes record the performer's identity in a secure, trusted, and unique way.",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:1198-28716)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "short" : "If the assignedEntity is an individual, the code SHOULD be selected from value set PersonalandLegalRelationshipRoleType value set",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-28718).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      }
    ]
  }
}

```
