# US Realm Date and Time - Interval - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Date and Time - Interval**

## Logical Model: US Realm Date and Time - Interval 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmDateTimeInterval |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.3 | |

 
The US Realm Clinical Document Date and Time datatype flavor records date and time information. If time is provided, it must include a time zone offset. 
This data type uses the same rules as US Realm Date and Time (Point in Time), but is used with elements having a datatype of IVL_TS. 

**Usages:**

* Use this Logical Model Profile: [Note Activity](StructureDefinition-NoteActivity.md) and [US Realm Header](StructureDefinition-USRealmHeader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmDateTimeInterval)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmDateTimeInterval.csv), [Excel](StructureDefinition-USRealmDateTimeInterval.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmDateTimeInterval",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.3"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmDateTimeInterval",
  "title" : "US Realm Date and Time - Interval",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The US Realm Clinical Document Date and Time datatype flavor records date and time information. If time is provided, it must include a time zone offset.\n\nThis data type uses the same rules as US Realm Date and Time (Point in Time), but is used with elements having a datatype of IVL_TS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL_TS",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "IVL_TS",
        "path" : "IVL_TS",
        "constraint" : [
          {
            "key" : "ivl-value-shall",
            "severity" : "error",
            "human" : "If a time interval contains @value, then it shall be precise to at least the day.",
            "expression" : "value.exists() implies value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          },
          {
            "key" : "ivl-value-should",
            "severity" : "warning",
            "human" : "If a time interval contains @value, then it SHOULD contain a time component.",
            "expression" : "value.exists() implies value.toString().length() > 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          }
        ]
      },
      {
        "id" : "IVL_TS.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format",
            "valueString" : "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules",
            "valueString" : "year-valid:tz-for-time"
          }
        ],
        "path" : "IVL_TS.value",
        "short" : "Either @value or low/high should be present, but not both"
      },
      {
        "id" : "IVL_TS.low",
        "path" : "IVL_TS.low",
        "short" : "**MAY** be precise to at least the second",
        "constraint" : [
          {
            "key" : "ts-shall-day",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          },
          {
            "key" : "ts-should-minute",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the minute",
            "expression" : "nullFlavor.exists() or value.toString().length() > 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          }
        ]
      },
      {
        "id" : "IVL_TS.low.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format",
            "valueString" : "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules",
            "valueString" : "year-valid:tz-for-time"
          }
        ],
        "path" : "IVL_TS.low.value"
      },
      {
        "id" : "IVL_TS.high",
        "path" : "IVL_TS.high",
        "short" : "**MAY** be precise to at least the second",
        "constraint" : [
          {
            "key" : "ts-shall-day",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          },
          {
            "key" : "ts-should-minute",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the minute",
            "expression" : "nullFlavor.exists() or value.toString().length() > 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          }
        ]
      },
      {
        "id" : "IVL_TS.high.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format",
            "valueString" : "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules",
            "valueString" : "year-valid:tz-for-time"
          }
        ],
        "path" : "IVL_TS.high.value"
      }
    ]
  }
}

```
