# US Realm Address - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Address**

## Logical Model: US Realm Address 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmAddress |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.2 | |

 
Reusable address template, for use in US Realm documents. 
When this template is used for recording patient addresses, certifying systems**SHALL**and non-certifying systems**SHOULD**enable the user who enters the**patient**address to follow the Project US@ Technical Specification for Patient Addresses Final Version 1.0 as the standard style guide for Street Address Line and City for new and updated records. 
For certifying systems, this requirement does not apply to historical records/documents that are exposed through C-CDA documents. 

**Usages:**

* Use this Logical Model Profile: [Advance Directive Observation](StructureDefinition-AdvanceDirectiveObservation.md), [Author Participation](StructureDefinition-AuthorParticipation.md), [Care Plan](StructureDefinition-CarePlan.md), [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md)...Show 13 more,[Care Team Organizer](StructureDefinition-CareTeamOrganizer.md),[Consultation Note](StructureDefinition-ConsultationNote.md),[Handoff Communication Participants](StructureDefinition-HandoffCommunicationParticipants.md),[Medication Dispense](StructureDefinition-MedicationDispense.md),[Policy Activity](StructureDefinition-PolicyActivity.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md),[Provenance - Assembler Participation](StructureDefinition-ProvenanceAssemblerParticipation.md),[Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md),[Referral Note](StructureDefinition-ReferralNote.md),[Related Person Relationship and Name Participant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md),[Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md),[Transfer Summary](StructureDefinition-TransferSummary.md)and[US Realm Header](StructureDefinition-USRealmHeader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmAddress)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmAddress.csv), [Excel](StructureDefinition-USRealmAddress.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmAddress",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.2"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmAddress",
  "title" : "US Realm Address",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "Reusable address template, for use in US Realm documents. \n\nWhen this template is used for recording patient addresses, certifying systems **SHALL** and non-certifying systems **SHOULD** enable the user who enters the **patient** address to  follow the Project US@ Technical Specification for Patient Addresses Final Version 1.0 as the standard style guide for Street Address Line and  City for new and updated records.\n\nFor certifying systems, this requirement does not apply to historical records/documents that are exposed through C-CDA documents.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AD",
        "path" : "AD",
        "constraint" : [
          {
            "key" : "shall-city",
            "severity" : "error",
            "human" : "SHALL contain exactly one [1..1] city (CONF:81-7292).",
            "expression" : "nullFlavor.exists() or item.city.count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "shall-streetAddressLine",
            "severity" : "error",
            "human" : "SHALL contain at least one and not more than 4 streetAddressLine (CONF:81-7291).",
            "expression" : "nullFlavor.exists() or (item.streetAddressLine.count() >= 1 and item.streetAddressLine.count() <= 4)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "expression" : "nullFlavor.exists() or item.country.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "81-7296",
            "severity" : "error",
            "human" : "**SHALL NOT** have mixed content except for white space (CONF:81-7296)",
            "expression" : "item.xmlText.empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "81-10024",
            "severity" : "error",
            "human" : "If the country is US, the state element is required and SHALL be selected from ValueSet StateValueSet but SHOULD have @nullFlavor if the state is unknown. If country is not specified, it's assumed to be US. If country is something other than US, the state MAY be present but MAY be bound to different vocabularies (CONF:81-10024).",
            "expression" : "nullFlavor.exists() or (item.country.exists() and item.country.xmlText != 'US' and item.country.xmlText != 'USA') or item.state.exists(nullFlavor.exists() or xmlText.memberOf('http://terminology.hl7.org/ValueSet/USPS-State'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "81-10025",
            "severity" : "error",
            "human" : "If the country is US, the postalCode element is required but SHOULD have @nullFlavor if the postalCode is unknown. If country is not specified, it's assumed to be US. If country is something other than US, the postalCode MAY be present but MAY be bound to different vocabularies (CONF:81-10025).",
            "expression" : "nullFlavor.exists() or (item.country.exists() and item.country.xmlText != 'US' and item.country.xmlText != 'USA') or item.postalCode.exists(nullFlavor.exists() or xmlText.matches('[0-9]{5}(-[0-9]{4})?'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "key" : "shall-max-ad-parts",
            "severity" : "error",
            "human" : "SHALL have at most one of each: state, city, postalCode, and country",
            "expression" : "(item.state.empty() or item.state.count() = 1) and (item.city.empty() or item.city.count() = 1) and (item.postalCode.empty() or item.postalCode.count() = 1) and (item.country.empty() or item.country.count() = 1)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          }
        ]
      },
      {
        "id" : "AD.nullFlavor",
        "path" : "AD.nullFlavor",
        "short" : "If addr/@nullFlavor is present, none of the address parts are required."
      },
      {
        "id" : "AD.use",
        "path" : "AD.use",
        "short" : "Identifies which address to use for a given purpose.",
        "comment" : "Historically this was bound to ValueSet PostalAddressUse urn:oid:2.16.840.1.113883.1.11.10637 STATIC 2005-05-01, but this contained 'CONF' which is not allowed by CDA. So the binding has been removed in the current version of C-CDA."
      },
      {
        "id" : "AD.item.country",
        "path" : "AD.item.country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-Country2"
        }
      },
      {
        "id" : "AD.item.state",
        "path" : "AD.item.state",
        "binding" : {
          "strength" : "example",
          "description" : "If country is something other than US, the state MAY be present but MAY be bound to different vocabularies",
          "additional" : [
            {
              "purpose" : "required",
              "valueSet" : "http://terminology.hl7.org/ValueSet/USPS-State",
              "documentation" : "If the country is US, the state element is required and SHALL be selected from ValueSet StateValueSet but SHOULD have @nullFlavor if the state is unknown. If country is not specified, it's assumed to be US. (CONF:81-10024).",
              "shortDoco" : "For US Addresses"
            }
          ]
        }
      },
      {
        "id" : "AD.item.city",
        "path" : "AD.item.city",
        "short" : "city is required if nullFlavor is absent",
        "comment" : "SHALL contain exactly one [1..1] city (CONF:81-7292)."
      },
      {
        "id" : "AD.item.postalCode",
        "path" : "AD.item.postalCode",
        "short" : "If country is US, shall be a 5-digit or 9-digit zip code (##### or #####-####)"
      },
      {
        "id" : "AD.item.streetAddressLine",
        "path" : "AD.item.streetAddressLine",
        "short" : "Min: 1, Max: 4 streetAddressLine required if nullFlavor is absent"
      },
      {
        "id" : "AD.useablePeriod",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/SXPR-TS"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "AD.useablePeriod",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Previous Address - Current or prior place where a person may have been located or could have been contacted."
      }
    ]
  }
}

```
