# Transfer Summary - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Transfer Summary**

## Logical Model: Transfer Summary 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:TransferSummary |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.13:2024-05-01 | |

 
The Transfer Summary standardizes critical information for exchange of information between providers of care when a patient moves between health care settings. 
Standardization of information used in this form will promote interoperability; create information suitable for reuse in quality measurement, public health, research, and for reimbursement. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md) or both [AssessmentSection](StructureDefinition-AssessmentSection.md) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
* [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.md)
 
**Recommended Sections** 
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
* [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md)
* [DischargeDiagnosisSection](StructureDefinition-DischargeDiagnosisSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [MentalStatusSection](StructureDefinition-MentalStatusSection.md)
* [NutritionSection](StructureDefinition-NutritionSection.md)
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
 
**Additional Sections** 
* [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md)
* [EncountersSection](StructureDefinition-EncountersSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.md)
* [PayersSection](StructureDefinition-PayersSection.md)
* [GeneralStatusSection](StructureDefinition-GeneralStatusSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [AdmissionMedicationsSectionEntriesOptional](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.md)
* [AdmissionDiagnosisSection](StructureDefinition-AdmissionDiagnosisSection.md)
* [CourseofCareSection](StructureDefinition-CourseofCareSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/TransferSummary)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-TransferSummary.csv), [Excel](StructureDefinition-TransferSummary.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TransferSummary",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.13:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "TransferSummary",
  "title" : "Transfer Summary",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Transfer Summary standardizes critical information for exchange of information between providers of care when a patient moves between health care settings. \n\nStandardization of information used in this form will promote interoperability; create information suitable for reuse in quality measurement, public health, research, and for reimbursement.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.html) or both [AssessmentSection](StructureDefinition-AssessmentSection.html) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n- [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.html)\n\n**Recommended Sections**\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)\n- [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.html)\n- [DischargeDiagnosisSection](StructureDefinition-DischargeDiagnosisSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [MentalStatusSection](StructureDefinition-MentalStatusSection.html)\n- [NutritionSection](StructureDefinition-NutritionSection.html)\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n\n**Additional Sections**\n- [PhysicalExamSection](StructureDefinition-PhysicalExamSection.html)\n- [EncountersSection](StructureDefinition-EncountersSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.html)\n- [PayersSection](StructureDefinition-PayersSection.html)\n- [GeneralStatusSection](StructureDefinition-GeneralStatusSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [AdmissionMedicationsSectionEntriesOptional](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.html)\n- [AdmissionDiagnosisSection](StructureDefinition-AdmissionDiagnosisSection.html)\n- [CourseofCareSection](StructureDefinition-CourseofCareSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "category-18761-7",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '18761-7'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '18761-7' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-participant-indirect",
            "severity" : "warning",
            "human" : "SHOULD contain zero or more [0..*] participant such that it SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC)",
            "expression" : "participant.where(typeCode = 'IND').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-participant-callback",
            "severity" : "warning",
            "human" : "SHOULD contain zero or more [0..*] participant such that it SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC)",
            "expression" : "participant.where(typeCode = 'CALLBCK').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:transfer-summary",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "transfer-summary",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:transfer-summary.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.13"
      },
      {
        "id" : "ClinicalDocument.templateId:transfer-summary.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Transfer Summary. If present, there SHALL be a category of 18761-7 (Transfer summary note).",
        "condition" : ["should-sdtcCategory", "category-18761-7"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Transfer summary note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "18761-7"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Transfer Summary recommends use of the document type code 18761-7 \"Transfer summary note\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type. For example, an Obstetrics and Gynecology Transfer Summary note would not be authored by a Pediatric Cardiologist.\n\nPre-coordinated codes are those that indicate the specialty or service provided in the LOINC Long Common Name (Print Name in the TransferDocumentType valueSet table).\n\nWhen using a generic type of code such as 18761-7 (Provider - Unspecified Transfer Summary), the types of services involved in the care are handled in documentationOf/serviceEvent with the use of serviceEvent/code (e.g., use a SNOMED CT procedure code such as 69031006 (Excision of breast tissue) while performers/providers involved in the care can be identified using the functionCode (bound to Healthcare Provider Taxonomy role codes).",
        "comment" : "SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet TransferDocumentType http://hl7.org/fhir/ccda/ValueSet/2.16.840.1.113883.1.11.20.2.4 DYNAMIC (CONF:1198-28243).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.20.2.4"
        }
      },
      {
        "id" : "ClinicalDocument.title",
        "path" : "ClinicalDocument.title",
        "comment" : "SHALL contain exactly one [1..1] title (CONF:1198-29838)."
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "indirect",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31599) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-31872).",
        "fixedCode" : "IND"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31600)."
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode, which SHALL be selected from ValueSet INDRoleclassCodes urn:oid:2.16.840.1.113883.11.20.9.33 DYNAMIC (CONF:1198-31873).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31601).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] name (CONF:1198-31602).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "callback",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31626) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:callback.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" Call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-31627).",
        "fixedCode" : "CALLBCK"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31628).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode=\"ASSIGNED\" assigned entity (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110) (CONF:1198-31641).",
        "fixedCode" : "ASSIGNED"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.id",
        "path" : "ClinicalDocument.participant.associatedEntity.id",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] id (CONF:1198-31629).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.addr",
        "path" : "ClinicalDocument.participant.associatedEntity.addr",
        "comment" : "This associatedEntity SHOULD contain zero or more [0..*] addr (CONF:1198-31630).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.telecom",
        "path" : "ClinicalDocument.participant.associatedEntity.telecom",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] telecom (CONF:1198-31631).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31632).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] name (CONF:1198-31633).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.scopingOrganization",
        "path" : "ClinicalDocument.participant.associatedEntity.scopingOrganization",
        "comment" : "This associatedEntity MAY contain zero or one [0..1] scopingOrganization (CONF:1198-31634)."
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "comment" : "SHALL contain exactly one [1..1] documentationOf (CONF:1198-31570).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "short" : "The serviceEvent in a Transfer Note contains the representation of providers who are wholly or partially responsible for the safety and well-being of a subject of care.",
        "comment" : "This documentationOf SHALL contain exactly one [1..1] serviceEvent (CONF:1198-31571)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.classCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.classCode",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] @classCode=\"PCPR\" Care Provision (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-31572).",
        "min" : 1,
        "fixedCode" : "PCPR"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "short" : "Use serviceEvent/code when using a generic document type code such as 18761-7 (Provider-Unspecified Transfer Summary) to represent the service.",
        "comment" : "This serviceEvent MAY contain zero or one [0..1] code (CONF:1198-32650)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:performer1",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "sliceName" : "performer1",
        "comment" : "This serviceEvent SHALL contain at least one [1..*] performer (CONF:1198-31574) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:performer1.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PRF\" Participation of Physical Performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC) (CONF:1198-31575).",
        "fixedCode" : "PRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:performer1.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "short" : "Use performer/functionCode when using a generic document type code such as 18761-7 (Provider-Unspecified Transfer Summary) to represent the provider.",
        "comment" : "MAY contain zero or one [0..1] functionCode, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-32651).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-28251)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-28252).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ap-or-a-and-p",
            "severity" : "error",
            "human" : "**SHALL** include an Assessment and Plan Section, or both an Assessment Section and a Plan of Treatment Section.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() or (component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).count() = 2)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "ap-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain an Assessment and Plan Section (2.16.840.1.113883.10.20.22.2.9:2014-06-09) when either an Assessment Section (2.16.840.1.113883.10.20.22.2.8) or a Plan of Treatment Section (2.16.840.1.113883.10.20.22.2.10:2014-06-09) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-advance-directives",
            "severity" : "warning",
            "human" : "SHOULD contain am Advamce Directives Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-functional-status",
            "severity" : "warning",
            "human" : "SHOULD contain a Functional Status Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-discharge-dx",
            "severity" : "warning",
            "human" : "SHOULD contain a Discharge Diagnosis Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/DischargeDiagnosisSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-procedures",
            "severity" : "warning",
            "human" : "SHOULD contain a Procedures Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-social-history",
            "severity" : "warning",
            "human" : "SHOULD contain a Social History Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-mental-status",
            "severity" : "warning",
            "human" : "SHOULD contain a Mental Status Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-nutrition",
            "severity" : "warning",
            "human" : "SHOULD contain a Nutrition Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "key" : "should-section-hpi",
            "severity" : "warning",
            "human" : "SHOULD contain a History of Present Illness Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 7
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advanceDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advanceDirectives",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28253) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-advance-directives"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advanceDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "The component, if present, SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01) (CONF:1198-28254).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergiesAndIntolerances",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergiesAndIntolerances",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28255) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergiesAndIntolerances.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-28256).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "physicalExam",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28257) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Physical Exam Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.2.10:2024-05-01) (CONF:1198-28258).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:encounters",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "encounters",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28261) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:encounters.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Encounters Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.22.1:2024-05-01) (CONF:1198-28262).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncountersSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28263) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-28264).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "functionalStatus",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28265) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-functional-status"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.14:2014-06-09) (CONF:1198-28266).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeDiagnosis",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargeDiagnosis",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28271) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-discharge-dx"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeDiagnosis.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Discharge Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.24:2024-05-01) (CONF:1198-28272).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunizations",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28273) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-28274).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquip",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medicalEquip",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28275) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquip.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medical Equipment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09) (CONF:1198-28276).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28277) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-28278).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "payers",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28279) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Payers Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.18:2024-05-01) (CONF:1198-28280).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PayersSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28281) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-28282).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problem",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problem",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28283) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problem.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-28284).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28285) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-procedures"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section  (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-28286).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28287) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2024-05-01) (CONF:1198-28288).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHistory",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28289) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-social-history"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-28290).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28291) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-28292).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "mentalStatus",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28327) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-mental-status"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2024-05-01) (CONF:1198-28328).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "generalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28838) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] General Status Section (identifier: urn:oid:2.16.840.1.113883.10.20.2.5) (CONF:1198-28839).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30239) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-30240).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "nutrition",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30776) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-nutrition"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.57) (CONF:1198-30777).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForReferral",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForReferral",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-31342) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForReferral.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Referral Section (identifier: urn:hl7ii:1.3.6.1.4.1.19376.1.5.3.1.3.1:2014-06-09) (CONF:1198-31343).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforReferralSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "pastMedicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-31561) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-31562).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyOfPresentIllness",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "historyOfPresentIllness",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-31563) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-hpi"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyOfPresentIllness.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-31564).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessmentAndPlan",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-31565) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment and Plan Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.9:2014-06-09) (CONF:1198-31566).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-31567) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.8) (CONF:1198-31568).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionMedications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "admissionMedications",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-32445) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionMedications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Admission Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.44.1:2024-05-01) (CONF:1198-32446).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionMedicationsSectionEntriesOptional"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionDiagnosis",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "admissionDiagnosis",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-32447) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionDiagnosis.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Admission Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.43:2024-05-01) (CONF:1198-32448).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:courseOfCare",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "courseOfCare",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-32648) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:courseOfCare.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Course of Care Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.64) (CONF:1198-32649).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CourseofCareSection"
            ]
          }
        ]
      }
    ]
  }
}

```
